/*
 * Decompiled with CFR 0.152.
 */
package revxrsal.commands.core;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import revxrsal.commands.annotation.AutoComplete;
import revxrsal.commands.autocomplete.SuggestionProvider;
import revxrsal.commands.autocomplete.SuggestionProviderFactory;
import revxrsal.commands.command.CommandParameter;
import revxrsal.commands.util.Strings;

class AutoCompleterAnnotationFactory
implements SuggestionProviderFactory {
    private final Map<String, SuggestionProvider> tabProviders;

    public AutoCompleterAnnotationFactory(Map<String, SuggestionProvider> tabProviders) {
        this.tabProviders = tabProviders;
    }

    @Override
    @Nullable
    public SuggestionProvider createSuggestionProvider(@NotNull CommandParameter parameter) {
        AutoComplete ann = parameter.getDeclaringCommand().getAnnotation(AutoComplete.class);
        if (ann != null) {
            return this.parseTabAnnotation(ann, parameter.getCommandIndex());
        }
        return null;
    }

    private SuggestionProvider parseTabAnnotation(@NotNull AutoComplete annotation, int commandIndex) {
        if (annotation.value().isEmpty()) {
            return SuggestionProvider.EMPTY;
        }
        String[] values2 = Strings.SPACE.split(annotation.value());
        try {
            String providerV = values2[commandIndex];
            if (providerV.equals("*")) {
                return null;
            }
            if (providerV.startsWith("@")) {
                SuggestionProvider provider2 = this.tabProviders.get(providerV.substring(1));
                if (provider2 == null) {
                    throw new IllegalStateException("No such tab suggestion provider: " + providerV.substring(1));
                }
                return provider2;
            }
            List<String> suggestions = Arrays.asList(Strings.VERTICAL_BAR.split(providerV));
            return SuggestionProvider.of(suggestions);
        }
        catch (IndexOutOfBoundsException e) {
            return SuggestionProvider.EMPTY;
        }
    }
}

