/*
 * Decompiled with CFR 0.152.
 */
package revxrsal.commands.bukkit.core;

import com.google.common.collect.ForwardingList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import revxrsal.commands.autocomplete.SuggestionProvider;
import revxrsal.commands.autocomplete.SuggestionProviderFactory;
import revxrsal.commands.bukkit.BukkitCommandActor;
import revxrsal.commands.bukkit.EntitySelector;
import revxrsal.commands.bukkit.core.BukkitHandler;
import revxrsal.commands.bukkit.exception.InvalidPlayerException;
import revxrsal.commands.bukkit.exception.MalformedEntitySelectorException;
import revxrsal.commands.command.CommandActor;
import revxrsal.commands.command.CommandParameter;
import revxrsal.commands.exception.CommandErrorException;
import revxrsal.commands.process.ValueResolver;
import revxrsal.commands.process.ValueResolverFactory;
import revxrsal.commands.util.Primitives;

public enum EntitySelectorResolver implements ValueResolverFactory
{
    INSTANCE;

    private boolean supportComplexSelectors;

    private EntitySelectorResolver() {
        try {
            Bukkit.getServer().selectEntities((CommandSender)Bukkit.getConsoleSender(), "@a");
            this.supportComplexSelectors = true;
        }
        catch (Throwable t) {
            this.supportComplexSelectors = false;
        }
    }

    @Override
    @Nullable
    public ValueResolver<?> create(@NotNull CommandParameter parameter) {
        if (EntitySelector.class.isAssignableFrom(parameter.getType())) {
            Class entityType2 = (Class)Primitives.getInsideGeneric(parameter.getFullType(), Entity.class);
            if (Player.class.isAssignableFrom(entityType2)) {
                return this::resolvePlayerSelector;
            }
            return context -> {
                String selector = context.pop();
                try {
                    BukkitCommandActor actor = (BukkitCommandActor)context.actor();
                    ArrayList<Entity> c = new ArrayList<Entity>(Bukkit.getServer().selectEntities(actor.getSender(), selector));
                    c.removeIf(obj -> !entityType2.isInstance(obj));
                    return new EntitySelectorImpl(c);
                }
                catch (IllegalArgumentException e) {
                    throw new MalformedEntitySelectorException((CommandActor)context.actor(), selector, e.getCause().getMessage());
                }
                catch (NoSuchMethodError e) {
                    throw new CommandErrorException("Entity selectors on legacy versions are not supported yet!", new Object[0]);
                }
            };
        }
        return null;
    }

    private EntitySelector<Player> resolvePlayerSelector(ValueResolver.ValueResolverContext context) {
        String selector = context.pop().toLowerCase();
        try {
            BukkitCommandActor bActor = (BukkitCommandActor)context.actor();
            if (this.supportComplexSelectors) {
                List coll = Bukkit.getServer().selectEntities(bActor.getSender(), selector).stream().filter(c -> c instanceof Player).map(Player.class::cast).collect(Collectors.toList());
                return new EntitySelectorImpl<Player>(coll);
            }
            ArrayList<Player> coll = new ArrayList<Player>();
            Player[] players = Bukkit.getOnlinePlayers().toArray(new Player[0]);
            switch (selector) {
                case "@r": {
                    coll.add(players[ThreadLocalRandom.current().nextInt(players.length)]);
                    return new EntitySelectorImpl<Player>(coll);
                }
                case "@a": {
                    Collections.addAll(coll, players);
                    return new EntitySelectorImpl<Player>(coll);
                }
                case "@s": 
                case "@p": {
                    coll.add(bActor.requirePlayer());
                    return new EntitySelectorImpl<Player>(coll);
                }
            }
            Player player = Bukkit.getPlayer((String)selector);
            if (player == null) {
                throw new InvalidPlayerException(context.parameter(), selector);
            }
            coll.add(player);
            return new EntitySelectorImpl<Player>(coll);
        }
        catch (IllegalArgumentException e) {
            throw new MalformedEntitySelectorException((CommandActor)context.actor(), selector, e.getCause().getMessage());
        }
    }

    public boolean supportsComplexSelectors() {
        return this.supportComplexSelectors;
    }

    public static enum SelectorSuggestionFactory implements SuggestionProviderFactory
    {
        INSTANCE;

        private boolean supportComplexSelectors;

        private SelectorSuggestionFactory() {
            try {
                Bukkit.getServer().selectEntities((CommandSender)Bukkit.getConsoleSender(), "@a");
                this.supportComplexSelectors = true;
            }
            catch (Throwable t) {
                this.supportComplexSelectors = false;
            }
        }

        @Override
        @Nullable
        public SuggestionProvider createSuggestionProvider(@NotNull CommandParameter parameter) {
            if (parameter.getType().isAssignableFrom(EntitySelector.class)) {
                Class<? extends Entity> type = BukkitHandler.getSelectedEntity(parameter.getFullType());
                if (Player.class.isAssignableFrom(type) && !this.supportComplexSelectors) {
                    return SuggestionProvider.of("@a", "@p", "@r", "@s").compose(parameter.getCommandHandler().getAutoCompleter().getSuggestionProvider("players"));
                }
                if (!INSTANCE.supportComplexSelectors) {
                    return SuggestionProvider.EMPTY;
                }
            }
            return null;
        }
    }

    private static class EntitySelectorImpl<E extends Entity>
    extends ForwardingList<E>
    implements EntitySelector<E> {
        private final List<E> entities;

        public EntitySelectorImpl(List<E> entities) {
            this.entities = entities;
        }

        protected List<E> delegate() {
            return this.entities;
        }
    }
}

