/*
 * Decompiled with CFR 0.152.
 */
package revxrsal.commands.bukkit.core;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import net.kyori.adventure.platform.bukkit.BukkitAudiences;
import net.kyori.adventure.text.ComponentLike;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandMap;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import revxrsal.commands.CommandHandler;
import revxrsal.commands.autocomplete.SuggestionProvider;
import revxrsal.commands.bukkit.BukkitBrigadier;
import revxrsal.commands.bukkit.BukkitCommandActor;
import revxrsal.commands.bukkit.BukkitCommandHandler;
import revxrsal.commands.bukkit.adventure.AudienceSenderResolver;
import revxrsal.commands.bukkit.adventure.ComponentResponseHandler;
import revxrsal.commands.bukkit.brigadier.CommodoreBukkitBrigadier;
import revxrsal.commands.bukkit.core.BukkitActor;
import revxrsal.commands.bukkit.core.BukkitCommandExecutor;
import revxrsal.commands.bukkit.core.BukkitCommandListeners;
import revxrsal.commands.bukkit.core.BukkitPermissionReader;
import revxrsal.commands.bukkit.core.BukkitSenderResolver;
import revxrsal.commands.bukkit.core.EntitySelectorResolver;
import revxrsal.commands.bukkit.exception.BukkitExceptionAdapter;
import revxrsal.commands.bukkit.exception.InvalidPlayerException;
import revxrsal.commands.bukkit.exception.InvalidWorldException;
import revxrsal.commands.bukkit.exception.MalformedEntitySelectorException;
import revxrsal.commands.bukkit.exception.MoreThanOnePlayerException;
import revxrsal.commands.bukkit.exception.NonPlayerEntitiesException;
import revxrsal.commands.command.CommandActor;
import revxrsal.commands.command.CommandCategory;
import revxrsal.commands.command.ExecutableCommand;
import revxrsal.commands.core.BaseCommandHandler;
import revxrsal.commands.core.CommandPath;
import revxrsal.commands.exception.EnumNotFoundException;
import revxrsal.commands.util.Preconditions;
import revxrsal.commands.util.Primitives;

public final class BukkitHandler
extends BaseCommandHandler
implements BukkitCommandHandler {
    public static final SuggestionProvider playerSuggestionProvider;
    private final Plugin plugin;
    private Optional<BukkitBrigadier> brigadier;
    @Nullable
    Object bukkitAudiences;
    private static final Constructor<PluginCommand> COMMAND_CONSTRUCTOR;
    @Nullable
    private static final Field KNOWN_COMMANDS;
    private static final CommandMap COMMAND_MAP;

    public BukkitHandler(@NotNull Plugin plugin) {
        this.plugin = Preconditions.notNull(plugin, "plugin");
        try {
            this.brigadier = Optional.of(new CommodoreBukkitBrigadier(this));
        }
        catch (NoClassDefFoundError e) {
            this.brigadier = Optional.empty();
        }
        this.registerSenderResolver(BukkitSenderResolver.INSTANCE);
        this.registerValueResolver(Player.class, context -> {
            String value2 = context.pop();
            if (value2.equalsIgnoreCase("self") || value2.equalsIgnoreCase("me")) {
                return ((BukkitCommandActor)context.actor()).requirePlayer();
            }
            if (EntitySelectorResolver.INSTANCE.supportsComplexSelectors()) {
                try {
                    List entityList = Bukkit.selectEntities((CommandSender)((BukkitActor)context.actor()).getSender(), (String)value2);
                    if (entityList.stream().anyMatch(c -> !(c instanceof Player))) {
                        throw new NonPlayerEntitiesException(value2);
                    }
                    if (entityList.size() != 1) {
                        throw new MoreThanOnePlayerException(value2);
                    }
                    return (Player)entityList.get(0);
                }
                catch (IllegalArgumentException e) {
                    throw new MalformedEntitySelectorException((CommandActor)context.actor(), value2, e.getCause().getMessage());
                }
            }
            Player player = Bukkit.getPlayerExact((String)value2);
            if (player == null) {
                throw new InvalidPlayerException(context.parameter(), value2);
            }
            return player;
        });
        this.registerValueResolver(OfflinePlayer.class, context -> {
            String value2 = context.pop();
            if (value2.equalsIgnoreCase("self") || value2.equalsIgnoreCase("me")) {
                return ((BukkitCommandActor)context.actor()).requirePlayer();
            }
            OfflinePlayer player = Bukkit.getOfflinePlayer((String)value2);
            if (!player.hasPlayedBefore()) {
                throw new InvalidPlayerException(context.parameter(), value2);
            }
            return player;
        });
        this.registerValueResolver(World.class, context -> {
            String value2 = context.pop();
            if (value2.equalsIgnoreCase("self") || value2.equalsIgnoreCase("me")) {
                return ((BukkitCommandActor)context.actor()).requirePlayer().getWorld();
            }
            World world = Bukkit.getWorld((String)value2);
            if (world == null) {
                throw new InvalidWorldException(context.parameter(), value2);
            }
            return world;
        });
        this.registerValueResolver(EntityType.class, context -> {
            EntityType type;
            String value2 = context.pop().toLowerCase();
            if (value2.startsWith("minecraft:")) {
                value2 = value2.substring("minecraft:".length());
            }
            if ((type = EntityType.fromName((String)value2)) == null) {
                throw new EnumNotFoundException(context.parameter(), value2);
            }
            return type;
        });
        if (EntitySelectorResolver.INSTANCE.supportsComplexSelectors() && this.isBrigadierSupported()) {
            this.getAutoCompleter().registerParameterSuggestions(EntityType.class, SuggestionProvider.EMPTY);
        }
        this.registerValueResolverFactory(EntitySelectorResolver.INSTANCE);
        if (!this.isBrigadierSupported()) {
            this.getAutoCompleter().registerParameterSuggestions(Player.class, playerSuggestionProvider);
        }
        this.getAutoCompleter().registerSuggestion("players", playerSuggestionProvider);
        this.getAutoCompleter().registerSuggestion("worlds", SuggestionProvider.map(Bukkit::getWorlds, World::getName)).registerParameterSuggestions(Player.class, "players").registerParameterSuggestions(World.class, "worlds").registerSuggestionFactory(EntitySelectorResolver.SelectorSuggestionFactory.INSTANCE);
        this.registerContextValue(plugin.getClass(), plugin);
        this.registerDependency(plugin.getClass(), plugin);
        this.registerDependency(FileConfiguration.class, () -> ((Plugin)plugin).getConfig());
        this.registerDependency(Logger.class, () -> ((Plugin)plugin).getLogger());
        this.registerPermissionReader(BukkitPermissionReader.INSTANCE);
        this.setExceptionHandler(BukkitExceptionAdapter.INSTANCE);
        Bukkit.getServer().getPluginManager().registerEvents((Listener)new BukkitCommandListeners(this), plugin);
    }

    @Override
    @NotNull
    public CommandHandler register(Object ... commands) {
        super.register(commands);
        for (ExecutableCommand command2 : this.executables.values()) {
            if (command2.getParent() != null) continue;
            this.createPluginCommand(command2.getName(), command2.getDescription(), command2.getUsage());
        }
        for (CommandCategory category : this.categories.values()) {
            if (category.getParent() != null) continue;
            this.createPluginCommand(category.getName(), null, null);
        }
        return this;
    }

    @Override
    @NotNull
    public Optional<BukkitBrigadier> getBrigadier() {
        return this.brigadier;
    }

    @Override
    public boolean isBrigadierSupported() {
        return this.brigadier.isPresent();
    }

    @Override
    public BukkitCommandHandler registerBrigadier() {
        this.brigadier.ifPresent(BukkitBrigadier::register);
        return this;
    }

    @Override
    public void enableAdventure() {
        this.enableAdventure(BukkitAudiences.create((Plugin)this.plugin));
    }

    @Override
    public void enableAdventure(@NotNull BukkitAudiences audiences) {
        Preconditions.notNull(audiences, "audiences");
        this.bukkitAudiences = audiences;
        this.registerSenderResolver(new AudienceSenderResolver(audiences));
        this.registerResponseHandler(ComponentLike.class, new ComponentResponseHandler(audiences));
    }

    @Override
    @NotNull
    public Plugin getPlugin() {
        return this.plugin;
    }

    private void createPluginCommand(String name2, @Nullable String description2, @Nullable String usage) {
        PluginCommand cmd = COMMAND_CONSTRUCTOR.newInstance(name2, this.plugin);
        COMMAND_MAP.register(this.plugin.getName(), (Command)cmd);
        BukkitCommandExecutor executor = new BukkitCommandExecutor(this);
        cmd.setExecutor((CommandExecutor)executor);
        cmd.setTabCompleter((TabCompleter)executor);
        cmd.setDescription(description2 == null ? "" : description2);
        if (usage != null) {
            cmd.setUsage(usage);
        }
    }

    @Override
    public boolean unregister(@NotNull CommandPath path) {
        if (path.isRoot()) {
            PluginCommand command2 = ((JavaPlugin)this.plugin).getCommand(path.getFirst());
            this.unregisterCommand(command2);
        }
        return super.unregister(path);
    }

    private void unregisterCommand(PluginCommand command2) {
        if (command2 != null) {
            command2.unregister(COMMAND_MAP);
            Map<String, Command> knownCommands = BukkitHandler.getKnownCommands();
            if (knownCommands != null) {
                Command rawAlias = knownCommands.get(command2.getName());
                if (rawAlias instanceof PluginCommand && ((PluginCommand)rawAlias).getPlugin() == this.plugin) {
                    knownCommands.remove(command2.getName());
                }
                knownCommands.remove(this.plugin.getDescription().getName() + ":" + command2.getName());
            }
        }
    }

    public static Class<? extends Entity> getSelectedEntity(@NotNull Type selectorType) {
        return (Class)Primitives.getInsideGeneric(selectorType, Entity.class);
    }

    @Nullable
    private static Map<String, Command> getKnownCommands() {
        if (KNOWN_COMMANDS != null) {
            return (Map)KNOWN_COMMANDS.get(COMMAND_MAP);
        }
        return null;
    }

    static {
        CommandMap commandMap;
        Constructor ctr;
        playerSuggestionProvider = (args2, sender, command2) -> Bukkit.getOnlinePlayers().stream().filter(player -> !((BukkitCommandActor)sender).isPlayer() || ((BukkitCommandActor)sender).requirePlayer().canSee(player)).map(HumanEntity::getName).collect(Collectors.toList());
        Field knownCommands = null;
        try {
            ctr = PluginCommand.class.getDeclaredConstructor(String.class, Plugin.class);
            ctr.setAccessible(true);
            Field commandMapField = Bukkit.getServer().getClass().getDeclaredField("commandMap");
            commandMapField.setAccessible(true);
            commandMap = (CommandMap)commandMapField.get(Bukkit.getServer());
            if (commandMap instanceof SimpleCommandMap) {
                knownCommands = SimpleCommandMap.class.getDeclaredField("knownCommands");
                knownCommands.setAccessible(true);
            }
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Unable to access PluginCommand(String, Plugin) construtor!");
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
            throw new IllegalStateException("Unable to access Bukkit.getServer()#commandMap!");
        }
        COMMAND_CONSTRUCTOR = ctr;
        COMMAND_MAP = commandMap;
        KNOWN_COMMANDS = knownCommands;
    }
}

