/*
 * Decompiled with CFR 0.152.
 */
package revxrsal.commands.bukkit.core;

import java.util.Collections;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import revxrsal.commands.bukkit.core.BukkitActor;
import revxrsal.commands.bukkit.core.BukkitHandler;
import revxrsal.commands.command.ArgumentStack;
import revxrsal.commands.command.CommandActor;
import revxrsal.commands.exception.ArgumentParseException;

final class BukkitCommandExecutor
implements TabExecutor {
    private final BukkitHandler handler;

    public BukkitCommandExecutor(BukkitHandler handler2) {
        this.handler = handler2;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command2, @NotNull String label2, @NotNull String[] args2) {
        BukkitActor actor = new BukkitActor(sender, this.handler);
        try {
            ArgumentStack arguments = this.handler.parseArguments(args2);
            arguments.addFirst(command2.getName());
            this.handler.dispatch((CommandActor)actor, arguments);
        }
        catch (Throwable t) {
            this.handler.getExceptionHandler().handleException(t, actor);
        }
        return true;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command2, @NotNull String alias, @NotNull String[] args2) {
        try {
            BukkitActor actor = new BukkitActor(sender, this.handler);
            ArgumentStack arguments = this.handler.parseArgumentsForCompletion(args2);
            arguments.addFirst(command2.getName());
            return this.handler.getAutoCompleter().complete((CommandActor)actor, arguments);
        }
        catch (ArgumentParseException e) {
            return Collections.emptyList();
        }
    }
}

