/*
 * Decompiled with CFR 0.152.
 */
package revxrsal.commands.bukkit.core;

import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.UUID;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.platform.bukkit.BukkitAudiences;
import net.kyori.adventure.text.ComponentLike;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import revxrsal.commands.CommandHandler;
import revxrsal.commands.bukkit.BukkitCommandActor;
import revxrsal.commands.bukkit.BukkitCommandHandler;
import revxrsal.commands.bukkit.core.BukkitHandler;
import revxrsal.commands.bukkit.exception.SenderNotConsoleException;
import revxrsal.commands.bukkit.exception.SenderNotPlayerException;
import revxrsal.commands.locales.Locales;
import revxrsal.commands.util.Preconditions;
import revxrsal.commands.util.Strings;

@ApiStatus.Internal
public final class BukkitActor
implements BukkitCommandActor {
    private static final UUID CONSOLE_UUID = UUID.nameUUIDFromBytes("CONSOLE".getBytes(StandardCharsets.UTF_8));
    private final CommandSender sender;
    private final BukkitHandler handler;

    public BukkitActor(CommandSender sender, CommandHandler handler2) {
        this.sender = Preconditions.notNull(sender, "sender");
        this.handler = (BukkitHandler)Preconditions.notNull(handler2, "handler");
    }

    @Override
    @NotNull
    public CommandSender getSender() {
        return this.sender;
    }

    @Override
    public boolean isPlayer() {
        return this.sender instanceof Player;
    }

    @Override
    public boolean isConsole() {
        return this.sender instanceof ConsoleCommandSender;
    }

    @Override
    @Nullable
    public Player getAsPlayer() {
        return this.isPlayer() ? (Player)this.sender : null;
    }

    @Override
    @NotNull
    public Player requirePlayer() {
        if (!this.isPlayer()) {
            throw new SenderNotPlayerException();
        }
        return (Player)this.sender;
    }

    @Override
    @NotNull
    public ConsoleCommandSender requireConsole() {
        if (!this.isConsole()) {
            throw new SenderNotConsoleException();
        }
        return (ConsoleCommandSender)this.sender;
    }

    @Override
    @NotNull
    public Audience audience() {
        BukkitAudiences audiences = (BukkitAudiences)this.handler.bukkitAudiences;
        if (audiences == null) {
            throw new IllegalStateException("You must call BukkitCommandHandler.enableAdventure() to access this method!");
        }
        return audiences.sender(this.getSender());
    }

    @Override
    public void reply(@NotNull ComponentLike component) {
        this.audience().sendMessage(component);
    }

    @Override
    @NotNull
    public String getName() {
        return this.sender.getName();
    }

    @Override
    @NotNull
    public UUID getUniqueId() {
        if (this.isPlayer()) {
            return ((Player)this.sender).getUniqueId();
        }
        if (this.isConsole()) {
            return CONSOLE_UUID;
        }
        return UUID.nameUUIDFromBytes(this.getName().getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public void reply(@NotNull String message2) {
        Preconditions.notNull(message2, "message");
        this.sender.sendMessage(Strings.colorize(this.handler.getMessagePrefix() + message2));
    }

    @Override
    public void error(@NotNull String message2) {
        Preconditions.notNull(message2, "message");
        this.sender.sendMessage(Strings.colorize(this.handler.getMessagePrefix() + "&c" + message2));
    }

    @Override
    public BukkitCommandHandler getCommandHandler() {
        return this.handler;
    }

    @Override
    @NotNull
    public Locale getLocale() {
        if (this.isPlayer()) {
            String playerLocale;
            try {
                playerLocale = this.requirePlayer().getLocale();
            }
            catch (NoSuchMethodError e) {
                try {
                    playerLocale = this.requirePlayer().spigot().getLocale();
                }
                catch (NoSuchMethodError e2) {
                    return BukkitCommandActor.super.getLocale();
                }
            }
            Locale locale = Locales.get(playerLocale);
            return locale == null ? BukkitCommandActor.super.getLocale() : locale;
        }
        return BukkitCommandActor.super.getLocale();
    }
}

