/*
 * Decompiled with CFR 0.152.
 */
package revxrsal.commands.bukkit.brigadier;

import java.util.Objects;
import org.bukkit.plugin.Plugin;
import revxrsal.commands.bukkit.brigadier.Commodore;
import revxrsal.commands.bukkit.brigadier.MinecraftArgumentType;

final class CommodoreProvider {
    private static final Throwable SETUP_EXCEPTION = CommodoreProvider.checkSupported();

    private CommodoreProvider() {
        throw new AssertionError();
    }

    private static Throwable checkSupported() {
        try {
            Class.forName("com.mojang.brigadier.CommandDispatcher");
            Commodore.ensureSetup();
            MinecraftArgumentType.ensureSetup();
            return null;
        }
        catch (Throwable e) {
            return e;
        }
    }

    public static boolean isSupported() {
        return SETUP_EXCEPTION == null;
    }

    public static Commodore getCommodore(Plugin plugin) {
        Objects.requireNonNull(plugin, "plugin");
        return new Commodore(plugin);
    }
}

