/*
 * Decompiled with CFR 0.152.
 */
package revxrsal.commands.bukkit.brigadier;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.tree.LiteralCommandNode;
import org.bukkit.command.Command;
import org.bukkit.command.PluginCommand;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import revxrsal.commands.bukkit.BukkitBrigadier;
import revxrsal.commands.bukkit.BukkitCommandHandler;
import revxrsal.commands.bukkit.EntitySelector;
import revxrsal.commands.bukkit.brigadier.ArgumentTypeResolver;
import revxrsal.commands.bukkit.brigadier.BrigadierTreeParser;
import revxrsal.commands.bukkit.brigadier.Commodore;
import revxrsal.commands.bukkit.brigadier.CommodoreProvider;
import revxrsal.commands.bukkit.brigadier.DefaultArgTypeResolvers;
import revxrsal.commands.bukkit.brigadier.MinecraftArgumentType;
import revxrsal.commands.bukkit.core.BukkitActor;
import revxrsal.commands.command.CommandActor;
import revxrsal.commands.command.CommandParameter;
import revxrsal.commands.util.ClassMap;
import revxrsal.commands.util.Preconditions;

public final class CommodoreBukkitBrigadier
implements BukkitBrigadier {
    private final BukkitCommandHandler handler;
    private final Commodore commodore;
    private final ClassMap<ArgumentTypeResolver> argumentTypes = new ClassMap();

    public CommodoreBukkitBrigadier(BukkitCommandHandler handler2) {
        this.handler = handler2;
        this.commodore = new Commodore(handler2.getPlugin());
        if (CommodoreProvider.isSupported()) {
            this.bind(String.class, DefaultArgTypeResolvers.STRING);
            this.bind(Number.class, DefaultArgTypeResolvers.NUMBER);
            this.bind(Boolean.class, DefaultArgTypeResolvers.BOOLEAN);
            this.bind(Player.class, DefaultArgTypeResolvers.PLAYER);
            this.bind(EntitySelector.class, DefaultArgTypeResolvers.ENTITY_SELECTOR);
        }
    }

    @Override
    public void bind(@NotNull Class<?> type, @NotNull ArgumentTypeResolver resolver) {
        Preconditions.notNull(type, "type");
        Preconditions.notNull(resolver, "resolver");
        this.argumentTypes.add(type, resolver);
    }

    @Override
    public void bind(@NotNull Class<?> type, @NotNull ArgumentType<?> argumentType) {
        Preconditions.notNull(type, "type");
        Preconditions.notNull(argumentType, "argument type");
        this.argumentTypes.add(type, parameter -> argumentType);
    }

    @Override
    public void bind(@NotNull Class<?> type, @NotNull MinecraftArgumentType argumentType) {
        Preconditions.notNull(type, "type");
        Preconditions.notNull(argumentType, "argument type");
        argumentType.getIfPresent().ifPresent(c -> this.argumentTypes.add(type, parameter -> c));
    }

    @Override
    @NotNull
    public ArgumentType<?> getArgumentType(@NotNull CommandParameter parameter) {
        ArgumentType<?> type;
        ArgumentTypeResolver resolver = this.argumentTypes.getFlexible(parameter.getType());
        if (resolver != null && (type = resolver.getArgumentType(parameter)) != null) {
            return type;
        }
        return StringArgumentType.string();
    }

    private void checkSupported() {
        if (this.commodore == null) {
            throw new IllegalArgumentException("Brigadier is not supported on this version.");
        }
    }

    @Override
    @NotNull
    public CommandActor wrapSource(@NotNull Object commandSource) {
        this.checkSupported();
        return new BukkitActor(this.commodore.getBukkitSender(commandSource), this.handler);
    }

    @Override
    public void register() {
        if (!CommodoreProvider.isSupported()) {
            return;
        }
        BrigadierTreeParser.parse(this, this.handler).forEach(n -> this.register(n.build()));
    }

    private void register(@NotNull LiteralCommandNode<?> node) {
        PluginCommand command2 = ((JavaPlugin)this.handler.getPlugin()).getCommand(node.getLiteral());
        if (command2 == null) {
            this.commodore.register(node);
        } else {
            this.commodore.register((Command)command2, node);
        }
    }
}

