/*
 * Decompiled with CFR 0.152.
 */
package revxrsal.commands.bukkit.brigadier;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.LiteralMessage;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import revxrsal.commands.CommandHandler;
import revxrsal.commands.autocomplete.SuggestionProvider;
import revxrsal.commands.bukkit.BukkitBrigadier;
import revxrsal.commands.bukkit.core.BukkitHandler;
import revxrsal.commands.command.ArgumentStack;
import revxrsal.commands.command.CommandActor;
import revxrsal.commands.command.CommandCategory;
import revxrsal.commands.command.CommandParameter;
import revxrsal.commands.command.ExecutableCommand;
import revxrsal.commands.exception.ArgumentParseException;

public final class BrigadierTreeParser {
    private static final Command NO_ACTION = context -> 1;

    public static <T> List<LiteralArgumentBuilder<T>> parse(@NotNull BukkitBrigadier brigadier2, @NotNull CommandHandler handler2) {
        ArrayList<LiteralArgumentBuilder<T>> nodes = new ArrayList<LiteralArgumentBuilder<T>>();
        List roots = handler2.getCategories().values().stream().filter(c -> c.getPath().isRoot()).collect(Collectors.toList());
        List rootCommands = handler2.getCommands().values().stream().filter(c -> c.getPath().isRoot()).collect(Collectors.toList());
        for (Comparable<CommandCategory> root : roots) {
            nodes.add(BrigadierTreeParser.parse(brigadier2, LiteralArgumentBuilder.literal((String)root.getName()), (CommandCategory)root));
        }
        for (Comparable<CommandCategory> root : rootCommands) {
            nodes.add(BrigadierTreeParser.parse(brigadier2, LiteralArgumentBuilder.literal((String)root.getName()), root));
        }
        return nodes;
    }

    public static <T> LiteralArgumentBuilder<T> parse(BukkitBrigadier brigadier2, LiteralArgumentBuilder<?> into, CommandCategory category) {
        LiteralArgumentBuilder<T> childLiteral;
        for (CommandCategory commandCategory : category.getCategories().values()) {
            childLiteral = BrigadierTreeParser.parse(brigadier2, LiteralArgumentBuilder.literal((String)commandCategory.getName()), commandCategory);
            into.then(childLiteral);
        }
        for (ExecutableCommand executableCommand : category.getCommands().values()) {
            childLiteral = BrigadierTreeParser.parse(brigadier2, LiteralArgumentBuilder.literal((String)executableCommand.getName()), executableCommand);
            into.then(childLiteral);
        }
        if (category.getDefaultAction() != null) {
            BrigadierTreeParser.parse(brigadier2, into, category.getDefaultAction());
        }
        into.requires(a -> category.hasPermission(brigadier2.wrapSource(a)));
        return into;
    }

    public static <T> LiteralArgumentBuilder<T> parse(BukkitBrigadier brigadier2, LiteralArgumentBuilder<?> into, ExecutableCommand command2) {
        CommandNode lastParameter = null;
        ArrayList<CommandParameter> sortedParameters = new ArrayList<CommandParameter>(command2.getValueParameters().values());
        Collections.sort(sortedParameters);
        for (int i = 0; i < sortedParameters.size(); ++i) {
            boolean isLast = i == sortedParameters.size() - 1;
            CommandParameter parameter2 = (CommandParameter)sortedParameters.get(i);
            if (parameter2.isFlag()) break;
            ArgumentBuilder builder = BrigadierTreeParser.getBuilder(brigadier2, command2, parameter2);
            if (!isLast && ((CommandParameter)sortedParameters.get(i + 1)).isOptional()) {
                builder.executes(NO_ACTION);
            }
            if (lastParameter == null) {
                if (parameter2.isOptional()) {
                    into.executes(NO_ACTION);
                }
                lastParameter = builder.build();
                into.then(lastParameter);
                continue;
            }
            CommandNode commandNode = lastParameter;
            lastParameter = builder.build();
            commandNode.addChild(lastParameter);
        }
        sortedParameters.removeIf(parameter -> !parameter.isFlag());
        LiteralCommandNode next = null;
        for (CommandParameter parameter2 : sortedParameters) {
            if (next == null) {
                if (lastParameter == null) {
                    next = LiteralArgumentBuilder.literal((String)(parameter2.getCommandHandler().getFlagPrefix() + parameter2.getFlagName())).build();
                    into.then((CommandNode)next);
                } else {
                    next = LiteralArgumentBuilder.literal((String)(parameter2.getCommandHandler().getFlagPrefix() + parameter2.getFlagName())).build();
                    lastParameter.addChild((CommandNode)next);
                }
            } else {
                LiteralCommandNode literalCommandNode = next;
                next = LiteralArgumentBuilder.literal((String)(parameter2.getCommandHandler().getFlagPrefix() + parameter2.getFlagName())).build();
                literalCommandNode.addChild((CommandNode)next);
            }
            LiteralCommandNode literalCommandNode = next;
            next = BrigadierTreeParser.getBuilder(brigadier2, command2, parameter2).build();
            literalCommandNode.addChild((CommandNode)next);
        }
        into.requires(a -> command2.hasPermission(brigadier2.wrapSource(a)));
        return into;
    }

    private static ArgumentBuilder getBuilder(BukkitBrigadier brigadier2, ExecutableCommand command2, CommandParameter parameter) {
        if (parameter.isSwitch()) {
            return LiteralArgumentBuilder.literal((String)(parameter.getCommandHandler().getSwitchPrefix() + parameter.getSwitchName()));
        }
        ArgumentType<?> argumentType = brigadier2.getArgumentType(parameter);
        return ((RequiredArgumentBuilder)RequiredArgumentBuilder.argument((String)parameter.getName(), argumentType).requires(a -> parameter.hasPermission(brigadier2.wrapSource(a)))).suggests(BrigadierTreeParser.createSuggestionProvider(brigadier2, command2, parameter));
    }

    private static com.mojang.brigadier.suggestion.SuggestionProvider<Object> createSuggestionProvider(BukkitBrigadier brigadier2, ExecutableCommand command2, CommandParameter parameter) {
        if (parameter.getSuggestionProvider() == SuggestionProvider.EMPTY) {
            return null;
        }
        if (parameter.getSuggestionProvider() == BukkitHandler.playerSuggestionProvider) {
            return null;
        }
        return (context, builder) -> {
            try {
                CommandActor actor = brigadier2.wrapSource(context.getSource());
                String tooltipMessage = parameter.getDescription() == null ? parameter.getName() : parameter.getDescription();
                LiteralMessage tooltip = new LiteralMessage(tooltipMessage);
                String input2 = context.getInput();
                try {
                    ArgumentStack args2 = parameter.getCommandHandler().parseArgumentsForCompletion(input2.startsWith("/") ? input2.substring(1) : input2);
                    parameter.getSuggestionProvider().getSuggestions(args2, actor, command2).stream().filter(c -> c.toLowerCase().startsWith(((String)args2.getLast()).toLowerCase())).sorted(String.CASE_INSENSITIVE_ORDER).distinct().forEach(arg_0 -> BrigadierTreeParser.lambda$null$8(builder, (Message)tooltip, arg_0));
                }
                catch (ArgumentParseException argumentParseException) {}
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            return builder.buildFuture();
        };
    }

    private static /* synthetic */ void lambda$null$8(SuggestionsBuilder builder, Message tooltip, String c) {
        builder.suggest(c, tooltip);
    }
}

