/*
 * Decompiled with CFR 0.152.
 */
package revxrsal.commands.autocomplete;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import revxrsal.commands.command.CommandActor;
import revxrsal.commands.command.ExecutableCommand;
import revxrsal.commands.util.Collections;

public interface SuggestionProvider {
    public static final SuggestionProvider EMPTY = (args2, sender, command2) -> java.util.Collections.emptyList();

    @NotNull
    public Collection<String> getSuggestions(@NotNull List<String> var1, @NotNull CommandActor var2, @NotNull ExecutableCommand var3) throws Throwable;

    @Contract(value="null -> this; !null -> new")
    default public SuggestionProvider compose(@Nullable SuggestionProvider other) {
        if (other == null) {
            return this;
        }
        return (args2, sender, command2) -> {
            HashSet<String> completions = new HashSet<String>(other.getSuggestions(args2, sender, command2));
            completions.addAll(this.getSuggestions(args2, sender, command2));
            return completions;
        };
    }

    public static SuggestionProvider of(@Nullable Collection<String> suggestions) {
        if (suggestions == null) {
            return EMPTY;
        }
        return (args2, sender, command2) -> suggestions;
    }

    public static SuggestionProvider of(String ... suggestions) {
        if (suggestions == null) {
            return EMPTY;
        }
        List<String> values2 = Collections.listOf(suggestions);
        return (args2, sender, command2) -> values2;
    }

    public static SuggestionProvider of(@NotNull Supplier<Collection<String>> supplier) {
        return (args2, sender, command2) -> (Collection)supplier.get();
    }

    public static <T> SuggestionProvider map(@NotNull Supplier<Collection<T>> values2, Function<T, String> function) {
        return (args2, sender, command2) -> ((Collection)values2.get()).stream().map(function).collect(Collectors.toList());
    }
}

