/*
 * Decompiled with CFR 0.152.
 */
package revxrsal.commands.annotation.dynamic;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringJoiner;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import revxrsal.commands.util.Preconditions;

public final class Annotations {
    @NotNull
    public static <T extends Annotation> T create(@NotNull Class<T> type) {
        return Annotations.create(type, Collections.emptyMap());
    }

    @NotNull
    public static <T extends Annotation> T create(@NotNull Class<T> type, @NotNull Map<String, Object> members2) {
        Preconditions.notNull(type, "type");
        Preconditions.notNull(members2, "members");
        return (T)((Annotation)type.cast(Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type}, (InvocationHandler)new DynamicAnnotationHandler(type, members2))));
    }

    @NotNull
    public static <T extends Annotation> T create(@NotNull Class<T> type, Object ... members2) {
        Preconditions.notNull(type, "type");
        Preconditions.notNull(members2, "members");
        if (members2.length % 2 != 0) {
            throw new IllegalArgumentException("Cannot have a non-even amount of members! Found " + members2.length);
        }
        HashMap<String, Object> values2 = new HashMap<String, Object>();
        for (int i = 0; i < members2.length; i += 2) {
            String key = String.valueOf(members2[i]);
            Object value2 = members2[i + 1];
            values2.put(key, value2);
        }
        return (T)((Annotation)type.cast(Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type}, (InvocationHandler)new DynamicAnnotationHandler(type, values2))));
    }

    private static int hashCode(Class<? extends Annotation> type, Map<String, Object> members2) {
        int result2 = 0;
        for (Method method : type.getDeclaredMethods()) {
            String name2 = method.getName();
            Object value2 = members2.get(name2);
            result2 += 127 * name2.hashCode() ^ Arrays.deepHashCode(new Object[]{value2}) - 31;
        }
        return result2;
    }

    private static boolean equals(Class<? extends Annotation> type, Map<String, Object> members2, Object other) throws Exception {
        if (!type.isInstance(other)) {
            return false;
        }
        for (Method method : type.getDeclaredMethods()) {
            String name2 = method.getName();
            if (Arrays.deepEquals(new Object[]{method.invoke(other, new Object[0])}, new Object[]{members2.get(name2)})) continue;
            return false;
        }
        return true;
    }

    private static String toString(Class<? extends Annotation> type, Map<String, Object> members2) {
        StringBuilder sb = new StringBuilder().append("@").append(type.getName()).append("(");
        StringJoiner joiner = new StringJoiner(", ");
        for (Map.Entry<String, Object> entry : members2.entrySet()) {
            joiner.add(entry.getKey() + "=" + Annotations.deepToString(entry.getValue()));
        }
        sb.append(joiner);
        return sb.append(")").toString();
    }

    private static String deepToString(Object arg) {
        String s = Arrays.deepToString(new Object[]{arg});
        return s.substring(1, s.length() - 1);
    }

    private static class DynamicAnnotationHandler
    implements InvocationHandler {
        private final Class<? extends Annotation> annotationType;
        private final Map<String, Object> annotationMembers;

        DynamicAnnotationHandler(Class<? extends Annotation> annotationType, Map<String, Object> annotationMembers) {
            this.annotationType = annotationType;
            this.annotationMembers = new HashMap<String, Object>(annotationMembers);
            for (Method method : annotationType.getDeclaredMethods()) {
                this.annotationMembers.putIfAbsent(method.getName(), method.getDefaultValue());
            }
        }

        @Override
        public Object invoke(Object proxy2, Method method, Object[] args2) throws Throwable {
            switch (method.getName()) {
                case "toString": {
                    return Annotations.toString(this.annotationType, this.annotationMembers);
                }
                case "hashCode": {
                    return Annotations.hashCode(this.annotationType, this.annotationMembers);
                }
                case "equals": {
                    return Annotations.equals(this.annotationType, this.annotationMembers, args2[0]);
                }
                case "annotationType": {
                    return this.annotationType;
                }
            }
            Object v = this.annotationMembers.get(method.getName());
            if (v == null) {
                throw new AbstractMethodError(method.getName());
            }
            return v instanceof Supplier ? ((Supplier)v).get() : v;
        }
    }
}

