/*
 * Decompiled with CFR 0.152.
 */
package org.json;

import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.XMLTokener;

public class XML {
    public static final Character AMP = Character.valueOf('&');
    public static final Character APOS = Character.valueOf('\'');
    public static final Character BANG = Character.valueOf('!');
    public static final Character EQ = Character.valueOf('=');
    public static final Character GT = Character.valueOf('>');
    public static final Character LT = Character.valueOf('<');
    public static final Character QUEST = Character.valueOf('?');
    public static final Character QUOT = Character.valueOf('\"');
    public static final Character SLASH = Character.valueOf('/');

    private static Iterable<Integer> codePointIterator(final String string2) {
        return new Iterable<Integer>(){

            @Override
            public Iterator<Integer> iterator() {
                return new Iterator<Integer>(){
                    private int nextIndex = 0;
                    private int length;
                    {
                        this.length = string2.length();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.nextIndex < this.length;
                    }

                    @Override
                    public Integer next() {
                        int result2 = string2.codePointAt(this.nextIndex);
                        this.nextIndex += Character.charCount(result2);
                        return result2;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public static String escape(String string2) {
        StringBuilder sb = new StringBuilder(string2.length());
        block7: for (int cp : XML.codePointIterator(string2)) {
            switch (cp) {
                case 38: {
                    sb.append("&amp;");
                    continue block7;
                }
                case 60: {
                    sb.append("&lt;");
                    continue block7;
                }
                case 62: {
                    sb.append("&gt;");
                    continue block7;
                }
                case 34: {
                    sb.append("&quot;");
                    continue block7;
                }
                case 39: {
                    sb.append("&apos;");
                    continue block7;
                }
            }
            if (XML.mustEscape(cp)) {
                sb.append("&#x");
                sb.append(Integer.toHexString(cp));
                sb.append(";");
                continue;
            }
            sb.appendCodePoint(cp);
        }
        return sb.toString();
    }

    private static boolean mustEscape(int cp) {
        return Character.isISOControl(cp) && cp != 9 && cp != 10 && cp != 13 || (cp < 32 || cp > 55295) && (cp < 57344 || cp > 65533) && (cp < 65536 || cp > 0x10FFFF);
    }

    public static String unescape(String string2) {
        StringBuilder sb = new StringBuilder(string2.length());
        int length = string2.length();
        for (int i = 0; i < length; ++i) {
            char c = string2.charAt(i);
            if (c == '&') {
                int semic = string2.indexOf(59, i);
                if (semic > i) {
                    String entity = string2.substring(i + 1, semic);
                    if (entity.charAt(0) == '#') {
                        int cp = entity.charAt(1) == 'x' ? Integer.parseInt(entity.substring(2), 16) : Integer.parseInt(entity.substring(1));
                        sb.appendCodePoint(cp);
                    } else if ("quot".equalsIgnoreCase(entity)) {
                        sb.append('\"');
                    } else if ("amp".equalsIgnoreCase(entity)) {
                        sb.append('&');
                    } else if ("apos".equalsIgnoreCase(entity)) {
                        sb.append('\'');
                    } else if ("lt".equalsIgnoreCase(entity)) {
                        sb.append('<');
                    } else if ("gt".equalsIgnoreCase(entity)) {
                        sb.append('>');
                    } else {
                        sb.append('&').append(entity).append(';');
                    }
                    i += entity.length() + 1;
                    continue;
                }
                sb.append(c);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static void noSpace(String string2) throws JSONException {
        int length = string2.length();
        if (length == 0) {
            throw new JSONException("Empty string.");
        }
        for (int i = 0; i < length; ++i) {
            if (!Character.isWhitespace(string2.charAt(i))) continue;
            throw new JSONException("'" + string2 + "' contains a space character.");
        }
    }

    private static boolean parse(XMLTokener x, JSONObject context, String name2, boolean keepStrings) throws JSONException {
        String string2;
        JSONObject jsonobject = null;
        Object token2 = x.nextToken();
        if (token2 == BANG) {
            char c = x.next();
            if (c == '-') {
                if (x.next() == '-') {
                    x.skipPast("-->");
                    return false;
                }
                x.back();
            } else if (c == '[') {
                token2 = x.nextToken();
                if ("CDATA".equals(token2) && x.next() == '[') {
                    String string3 = x.nextCDATA();
                    if (string3.length() > 0) {
                        context.accumulate("content", string3);
                    }
                    return false;
                }
                throw x.syntaxError("Expected 'CDATA['");
            }
            int i = 1;
            do {
                if ((token2 = x.nextMeta()) == null) {
                    throw x.syntaxError("Missing '>' after '<!'.");
                }
                if (token2 == LT) {
                    ++i;
                    continue;
                }
                if (token2 != GT) continue;
                --i;
            } while (i > 0);
            return false;
        }
        if (token2 == QUEST) {
            x.skipPast("?>");
            return false;
        }
        if (token2 == SLASH) {
            token2 = x.nextToken();
            if (name2 == null) {
                throw x.syntaxError("Mismatched close tag " + token2);
            }
            if (!token2.equals(name2)) {
                throw x.syntaxError("Mismatched " + name2 + " and " + token2);
            }
            if (x.nextToken() != GT) {
                throw x.syntaxError("Misshaped close tag");
            }
            return true;
        }
        if (token2 instanceof Character) {
            throw x.syntaxError("Misshaped tag");
        }
        String tagName = (String)token2;
        token2 = null;
        jsonobject = new JSONObject();
        while (true) {
            if (token2 == null) {
                token2 = x.nextToken();
            }
            if (!(token2 instanceof String)) break;
            string2 = (String)token2;
            token2 = x.nextToken();
            if (token2 == EQ) {
                token2 = x.nextToken();
                if (!(token2 instanceof String)) {
                    throw x.syntaxError("Missing value");
                }
                jsonobject.accumulate(string2, keepStrings ? XML.unescape((String)token2) : XML.stringToValue((String)token2));
                token2 = null;
                continue;
            }
            jsonobject.accumulate(string2, "");
        }
        if (token2 == SLASH) {
            if (x.nextToken() != GT) {
                throw x.syntaxError("Misshaped tag");
            }
            if (jsonobject.length() > 0) {
                context.accumulate(tagName, jsonobject);
            } else {
                context.accumulate(tagName, "");
            }
            return false;
        }
        if (token2 == GT) {
            while (true) {
                if ((token2 = x.nextContent()) == null) {
                    if (tagName != null) {
                        throw x.syntaxError("Unclosed tag " + tagName);
                    }
                    return false;
                }
                if (token2 instanceof String) {
                    string2 = (String)token2;
                    if (string2.length() <= 0) continue;
                    jsonobject.accumulate("content", keepStrings ? XML.unescape(string2) : XML.stringToValue(string2));
                    continue;
                }
                if (token2 == LT && XML.parse(x, jsonobject, tagName, keepStrings)) break;
            }
            if (jsonobject.length() == 0) {
                context.accumulate(tagName, "");
            } else if (jsonobject.length() == 1 && jsonobject.opt("content") != null) {
                context.accumulate(tagName, jsonobject.opt("content"));
            } else {
                context.accumulate(tagName, jsonobject);
            }
            return false;
        }
        throw x.syntaxError("Misshaped tag");
    }

    public static Object stringToValue(String string2) {
        Object ret = JSONObject.stringToValue(string2);
        if (ret instanceof String) {
            return XML.unescape((String)ret);
        }
        return ret;
    }

    public static JSONObject toJSONObject(String string2) throws JSONException {
        return XML.toJSONObject(string2, false);
    }

    public static JSONObject toJSONObject(String string2, boolean keepStrings) throws JSONException {
        JSONObject jo = new JSONObject();
        XMLTokener x = new XMLTokener(string2);
        while (x.more() && x.skipPast("<")) {
            XML.parse(x, jo, null, keepStrings);
        }
        return jo;
    }

    public static String toString(Object object) throws JSONException {
        return XML.toString(object, null);
    }

    public static String toString(Object object, String tagName) throws JSONException {
        String string2;
        StringBuilder sb = new StringBuilder();
        if (object instanceof JSONObject) {
            if (tagName != null) {
                sb.append('<');
                sb.append(tagName);
                sb.append('>');
            }
            JSONObject jo = (JSONObject)object;
            Iterator<String> keys2 = jo.keys();
            while (keys2.hasNext()) {
                JSONArray ja;
                String string3;
                String key = keys2.next();
                Object value2 = jo.opt(key);
                if (value2 == null) {
                    value2 = "";
                } else if (value2.getClass().isArray()) {
                    value2 = new JSONArray(value2);
                }
                String string4 = string3 = value2 instanceof String ? (String)value2 : null;
                if ("content".equals(key)) {
                    if (value2 instanceof JSONArray) {
                        ja = (JSONArray)value2;
                        int i = 0;
                        for (Object val : ja) {
                            if (i > 0) {
                                sb.append('\n');
                            }
                            sb.append(XML.escape(val.toString()));
                            ++i;
                        }
                        continue;
                    }
                    sb.append(XML.escape(value2.toString()));
                    continue;
                }
                if (value2 instanceof JSONArray) {
                    ja = (JSONArray)value2;
                    for (Object val : ja) {
                        if (val instanceof JSONArray) {
                            sb.append('<');
                            sb.append(key);
                            sb.append('>');
                            sb.append(XML.toString(val));
                            sb.append("</");
                            sb.append(key);
                            sb.append('>');
                            continue;
                        }
                        sb.append(XML.toString(val, key));
                    }
                    continue;
                }
                if ("".equals(value2)) {
                    sb.append('<');
                    sb.append(key);
                    sb.append("/>");
                    continue;
                }
                sb.append(XML.toString(value2, key));
            }
            if (tagName != null) {
                sb.append("</");
                sb.append(tagName);
                sb.append('>');
            }
            return sb.toString();
        }
        if (object != null) {
            if (object.getClass().isArray()) {
                object = new JSONArray(object);
            }
            if (object instanceof JSONArray) {
                JSONArray ja = (JSONArray)object;
                for (Object val : ja) {
                    sb.append(XML.toString(val, tagName == null ? "array" : tagName));
                }
                return sb.toString();
            }
        }
        String string5 = string2 = object == null ? "null" : XML.escape(object.toString());
        return tagName == null ? "\"" + string2 + "\"" : (string2.length() == 0 ? "<" + tagName + "/>" : "<" + tagName + ">" + string2 + "</" + tagName + ">");
    }
}

