/*
 * Decompiled with CFR 0.152.
 */
package org.json;

import java.util.Iterator;
import java.util.Locale;
import org.json.HTTPTokener;
import org.json.JSONException;
import org.json.JSONObject;

public class HTTP {
    public static final String CRLF = "\r\n";

    public static JSONObject toJSONObject(String string2) throws JSONException {
        JSONObject jo = new JSONObject();
        HTTPTokener x = new HTTPTokener(string2);
        String token2 = x.nextToken();
        if (token2.toUpperCase(Locale.ROOT).startsWith("HTTP")) {
            jo.put("HTTP-Version", token2);
            jo.put("Status-Code", x.nextToken());
            jo.put("Reason-Phrase", x.nextTo('\u0000'));
            x.next();
        } else {
            jo.put("Method", token2);
            jo.put("Request-URI", x.nextToken());
            jo.put("HTTP-Version", x.nextToken());
        }
        while (x.more()) {
            String name2 = x.nextTo(':');
            x.next(':');
            jo.put(name2, x.nextTo('\u0000'));
            x.next();
        }
        return jo;
    }

    public static String toString(JSONObject jo) throws JSONException {
        Iterator<String> keys2 = jo.keys();
        StringBuilder sb = new StringBuilder();
        if (jo.has("Status-Code") && jo.has("Reason-Phrase")) {
            sb.append(jo.getString("HTTP-Version"));
            sb.append(' ');
            sb.append(jo.getString("Status-Code"));
            sb.append(' ');
            sb.append(jo.getString("Reason-Phrase"));
        } else if (jo.has("Method") && jo.has("Request-URI")) {
            sb.append(jo.getString("Method"));
            sb.append(' ');
            sb.append('\"');
            sb.append(jo.getString("Request-URI"));
            sb.append('\"');
            sb.append(' ');
            sb.append(jo.getString("HTTP-Version"));
        } else {
            throw new JSONException("Not enough material for an HTTP header.");
        }
        sb.append(CRLF);
        while (keys2.hasNext()) {
            String string2 = keys2.next();
            if ("HTTP-Version".equals(string2) || "Status-Code".equals(string2) || "Reason-Phrase".equals(string2) || "Method".equals(string2) || "Request-URI".equals(string2) || jo.isNull(string2)) continue;
            sb.append(string2);
            sb.append(": ");
            sb.append(jo.getString(string2));
            sb.append(CRLF);
        }
        sb.append(CRLF);
        return sb.toString();
    }
}

