/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import java.util.ArrayList;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.serialization.json.internal.AbstractJsonLexerKt;
import kotlinx.serialization.json.internal.JsonExceptionsKt;
import kotlinx.serialization.json.internal.JsonPath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\r\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u0001\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\r\b \u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0004H\u0002J\u0018\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0004H\u0002J\u0018\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u0004H\u0002J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u0004H\u0014J\b\u0010\u001f\u001a\u00020 H&J\u0006\u0010!\u001a\u00020 J\u0010\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020\u0004H\u0003J\u0006\u0010#\u001a\u00020 J\u0018\u0010$\u001a\u00020\u001c2\u0006\u0010%\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u0004H\u0002J\b\u0010&\u001a\u00020\u000fH&J\u001a\u0010'\u001a\u0004\u0018\u00010\u000f2\u0006\u0010(\u001a\u00020\u000f2\u0006\u0010)\u001a\u00020 H&J\b\u0010*\u001a\u00020+H&J\u000e\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020+J\u0010\u0010*\u001a\u00020\u001c2\u0006\u0010,\u001a\u00020-H\u0016J\u0006\u0010.\u001a\u00020/J\u0006\u00100\u001a\u00020\u000fJ \u00100\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0004H\u0005J\u0006\u00101\u001a\u00020\u000fJ\u0006\u00102\u001a\u00020\u000fJ\u0018\u00103\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004H\u0002J\b\u00104\u001a\u00020\u001cH\u0016J\u0006\u00105\u001a\u00020\u001cJ\u0015\u00106\u001a\u0002072\u0006\u00108\u001a\u00020+H\u0000\u00a2\u0006\u0002\b9J\"\u00106\u001a\u0002072\u0006\u0010:\u001a\u00020\u000f2\b\b\u0002\u0010;\u001a\u00020\u00042\b\b\u0002\u0010<\u001a\u00020\u000fJ\u000e\u0010=\u001a\u00020\u001c2\u0006\u0010>\u001a\u00020\u000fJ\u0018\u0010?\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0003\u001a\u00020\u0004H\u0002J\u0018\u0010@\u001a\u00020\u00042\u0006\u0010A\u001a\u00020-2\u0006\u0010\u001a\u001a\u00020\u0004H\u0016J\u0006\u0010B\u001a\u00020 J\u0010\u0010C\u001a\u00020 2\u0006\u0010D\u001a\u00020-H\u0004J\u0006\u0010E\u001a\u00020+J\u0010\u0010F\u001a\u0004\u0018\u00010\u000f2\u0006\u0010)\u001a\u00020 J\u0010\u0010G\u001a\u00020\u00042\u0006\u0010;\u001a\u00020\u0004H&J1\u0010H\u001a\u00020\u001c2\u0006\u0010I\u001a\u00020 2\b\b\u0002\u0010;\u001a\u00020\u00042\f\u0010:\u001a\b\u0012\u0004\u0012\u00020\u000f0JH\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0002\bKJ\u000e\u0010L\u001a\u00020\u001c2\u0006\u0010M\u001a\u00020 J\b\u0010N\u001a\u00020\u0004H\u0016J\u0018\u0010O\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010P\u001a\u00020\u0004H\u0016J\b\u0010Q\u001a\u00020\u000fH\u0002J\b\u0010R\u001a\u00020\u000fH\u0016J\b\u0010S\u001a\u00020 H&J\u0006\u0010T\u001a\u00020 J\u0010\u0010U\u001a\u00020\u001c2\u0006\u0010,\u001a\u00020-H\u0004J\b\u0010V\u001a\u00020 H\u0002R\u0012\u0010\u0003\u001a\u00020\u00048\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0010\u0010\f\u001a\u00020\r8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0010\u001a\u00020\u0011X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006W"}, d2={"Lkotlinx/serialization/json/internal/AbstractJsonLexer;", "", "()V", "currentPosition", "", "escapedString", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "getEscapedString", "()Ljava/lang/StringBuilder;", "setEscapedString", "(Ljava/lang/StringBuilder;)V", "path", "Lkotlinx/serialization/json/internal/JsonPath;", "peekedString", "", "source", "", "getSource", "()Ljava/lang/CharSequence;", "appendEsc", "startPosition", "appendEscape", "lastPosition", "current", "appendHex", "startPos", "appendRange", "", "fromIndex", "toIndex", "canConsumeValue", "", "consumeBoolean", "start", "consumeBooleanLenient", "consumeBooleanLiteral", "literalSuffix", "consumeKeyString", "consumeLeadingMatchingValue", "keyToMatch", "isLenient", "consumeNextToken", "", "expected", "", "consumeNumericLiteral", "", "consumeString", "consumeStringLenient", "consumeStringLenientNotNull", "decodedString", "ensureHaveChars", "expectEof", "fail", "", "expectedToken", "fail$kotlinx_serialization_json", "message", "position", "hint", "failOnUnknownKey", "key", "fromHexChar", "indexOf", "char", "isNotEof", "isValidValueStart", "c", "peekNextToken", "peekString", "prefetchOrEof", "require", "condition", "Lkotlin/Function0;", "require$kotlinx_serialization_json", "skipElement", "allowLenientStrings", "skipWhitespaces", "substring", "endPos", "takePeeked", "toString", "tryConsumeComma", "tryConsumeNotNull", "unexpectedToken", "wasUnquotedString", "kotlinx-serialization-json"})
public abstract class AbstractJsonLexer {
    @JvmField
    protected int currentPosition;
    @JvmField
    @NotNull
    public final JsonPath path = new JsonPath();
    @Nullable
    private String peekedString;
    @NotNull
    private StringBuilder escapedString = new StringBuilder();

    @NotNull
    protected abstract CharSequence getSource();

    public void ensureHaveChars() {
    }

    public final boolean isNotEof() {
        return this.peekNextToken() != 10;
    }

    public abstract int prefetchOrEof(int var1);

    public abstract boolean tryConsumeComma();

    public abstract boolean canConsumeValue();

    public abstract byte consumeNextToken();

    protected final boolean isValidValueStart(char c) {
        char c2 = c;
        return !(((c2 == '}' ? true : c2 == ']') ? true : c2 == ':') ? true : c2 == ',');
    }

    public final void expectEof() {
        byte nextToken = this.consumeNextToken();
        if (nextToken != 10) {
            AbstractJsonLexer.fail$default(this, "Expected EOF after parsing, but had " + this.getSource().charAt(this.currentPosition - 1) + " instead", 0, null, 6, null);
            throw new KotlinNothingValueException();
        }
    }

    @NotNull
    protected final StringBuilder getEscapedString() {
        return this.escapedString;
    }

    protected final void setEscapedString(@NotNull StringBuilder stringBuilder) {
        Intrinsics.checkNotNullParameter(stringBuilder, "<set-?>");
        this.escapedString = stringBuilder;
    }

    public final byte consumeNextToken(byte expected) {
        byte token2 = this.consumeNextToken();
        if (token2 != expected) {
            this.fail$kotlinx_serialization_json(expected);
            throw new KotlinNothingValueException();
        }
        return token2;
    }

    public void consumeNextToken(char expected) {
        this.ensureHaveChars();
        CharSequence source = this.getSource();
        int cpos = this.currentPosition;
        while ((cpos = this.prefetchOrEof(cpos)) != -1) {
            char c;
            if ((c = source.charAt(cpos++)) == ' ' || c == '\n' || c == '\r' || c == '\t') continue;
            this.currentPosition = cpos;
            if (c == expected) {
                return;
            }
            this.unexpectedToken(expected);
        }
        this.currentPosition = cpos;
        this.unexpectedToken(expected);
    }

    protected final void unexpectedToken(char expected) {
        this.currentPosition += -1;
        if (this.currentPosition >= 0 && expected == '\"' && Intrinsics.areEqual(this.consumeStringLenient(), "null")) {
            this.fail("Expected string literal but 'null' literal was found", this.currentPosition - 4, "Use 'coerceInputValues = true' in 'Json {}` builder to coerce nulls to default values.");
            throw new KotlinNothingValueException();
        }
        this.fail$kotlinx_serialization_json(AbstractJsonLexerKt.charToTokenClass(expected));
        throw new KotlinNothingValueException();
    }

    @NotNull
    public final Void fail$kotlinx_serialization_json(byte expectedToken) {
        byte by = expectedToken;
        String expected = by == 1 ? "quotation mark '\"'" : (by == 4 ? "comma ','" : (by == 5 ? "colon ':'" : (by == 6 ? "start of the object '{'" : (by == 7 ? "end of the object '}'" : (by == 8 ? "start of the array '['" : (by == 9 ? "end of the array ']'" : "valid token"))))));
        String s = this.currentPosition == this.getSource().length() || this.currentPosition <= 0 ? "EOF" : String.valueOf(this.getSource().charAt(this.currentPosition - 1));
        AbstractJsonLexer.fail$default(this, "Expected " + expected + ", but had '" + s + "' instead", this.currentPosition - 1, null, 4, null);
        throw new KotlinNothingValueException();
    }

    public final byte peekNextToken() {
        CharSequence source = this.getSource();
        int cpos = this.currentPosition;
        while ((cpos = this.prefetchOrEof(cpos)) != -1) {
            char ch = source.charAt(cpos);
            if (ch == ' ' || ch == '\n' || ch == '\r' || ch == '\t') {
                ++cpos;
                continue;
            }
            this.currentPosition = cpos;
            return AbstractJsonLexerKt.charToTokenClass(ch);
        }
        this.currentPosition = cpos;
        return 10;
    }

    public final boolean tryConsumeNotNull() {
        int current = this.skipWhitespaces();
        current = this.prefetchOrEof(current);
        int len = this.getSource().length() - current;
        if (len < 4 || current == -1) {
            return true;
        }
        for (int i = 0; i < 4; ++i) {
            if ("null".charAt(i) == this.getSource().charAt(current + i)) continue;
            return true;
        }
        if (len > 4 && AbstractJsonLexerKt.charToTokenClass(this.getSource().charAt(current + 4)) == 0) {
            return true;
        }
        this.currentPosition = current + 4;
        return false;
    }

    public int skipWhitespaces() {
        char c;
        int current = this.currentPosition;
        while ((current = this.prefetchOrEof(current)) != -1 && ((c = this.getSource().charAt(current)) == ' ' || c == '\n' || c == '\r' || c == '\t')) {
            ++current;
        }
        this.currentPosition = current;
        return current;
    }

    @Nullable
    public abstract String consumeLeadingMatchingValue(@NotNull String var1, boolean var2);

    @Nullable
    public final String peekString(boolean isLenient) {
        String string2;
        String string3;
        byte token2 = this.peekNextToken();
        if (isLenient) {
            if (token2 != 1 && token2 != 0) {
                return null;
            }
            string3 = this.consumeStringLenient();
        } else {
            if (token2 != 1) {
                return null;
            }
            string3 = this.consumeString();
        }
        this.peekedString = string2 = string3;
        return string2;
    }

    public int indexOf(char c, int startPos) {
        return StringsKt.indexOf$default(this.getSource(), c, startPos, false, 4, null);
    }

    @NotNull
    public String substring(int startPos, int endPos) {
        return ((Object)this.getSource().subSequence(startPos, endPos)).toString();
    }

    @NotNull
    public abstract String consumeKeyString();

    @NotNull
    public final String consumeString() {
        if (this.peekedString != null) {
            return this.takePeeked();
        }
        return this.consumeKeyString();
    }

    @NotNull
    protected final String consumeString(@NotNull CharSequence source, int startPosition, int current) {
        Intrinsics.checkNotNullParameter(source, "source");
        int currentPosition = current;
        int lastPosition = startPosition;
        char c = source.charAt(currentPosition);
        boolean usedAppend = false;
        while (c != '\"') {
            if (c == '\\') {
                usedAppend = true;
                if ((currentPosition = this.prefetchOrEof(this.appendEscape(lastPosition, currentPosition))) == -1) {
                    AbstractJsonLexer.fail$default(this, "EOF", currentPosition, null, 4, null);
                    throw new KotlinNothingValueException();
                }
                lastPosition = currentPosition;
            } else if (++currentPosition >= source.length()) {
                usedAppend = true;
                this.appendRange(lastPosition, currentPosition);
                currentPosition = this.prefetchOrEof(currentPosition);
                if (currentPosition == -1) {
                    AbstractJsonLexer.fail$default(this, "EOF", currentPosition, null, 4, null);
                    throw new KotlinNothingValueException();
                }
                lastPosition = currentPosition;
            }
            c = source.charAt(currentPosition);
        }
        String string2 = !usedAppend ? this.substring(lastPosition, currentPosition) : this.decodedString(lastPosition, currentPosition);
        this.currentPosition = currentPosition + 1;
        return string2;
    }

    private final int appendEscape(int lastPosition, int current) {
        this.appendRange(lastPosition, current);
        return this.appendEsc(current + 1);
    }

    private final String decodedString(int lastPosition, int currentPosition) {
        this.appendRange(lastPosition, currentPosition);
        String string2 = this.escapedString.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "escapedString.toString()");
        String result2 = string2;
        this.escapedString.setLength(0);
        return result2;
    }

    private final String takePeeked() {
        String string2;
        String string3 = this.peekedString;
        Intrinsics.checkNotNull(string3);
        String it = string2 = string3;
        boolean bl = false;
        this.peekedString = null;
        return string2;
    }

    @NotNull
    public final String consumeStringLenientNotNull() {
        String result2 = this.consumeStringLenient();
        if (Intrinsics.areEqual(result2, "null") && this.wasUnquotedString()) {
            AbstractJsonLexer.fail$default(this, "Unexpected 'null' value instead of string literal", 0, null, 6, null);
            throw new KotlinNothingValueException();
        }
        return result2;
    }

    private final boolean wasUnquotedString() {
        return this.getSource().charAt(this.currentPosition - 1) != '\"';
    }

    @NotNull
    public final String consumeStringLenient() {
        if (this.peekedString != null) {
            return this.takePeeked();
        }
        int current = this.skipWhitespaces();
        if (current >= this.getSource().length() || current == -1) {
            AbstractJsonLexer.fail$default(this, "EOF", current, null, 4, null);
            throw new KotlinNothingValueException();
        }
        byte token2 = AbstractJsonLexerKt.charToTokenClass(this.getSource().charAt(current));
        if (token2 == 1) {
            return this.consumeString();
        }
        if (token2 != 0) {
            AbstractJsonLexer.fail$default(this, "Expected beginning of the string, but got " + this.getSource().charAt(current), 0, null, 6, null);
            throw new KotlinNothingValueException();
        }
        boolean usedAppend = false;
        while (AbstractJsonLexerKt.charToTokenClass(this.getSource().charAt(current)) == 0) {
            if (++current < this.getSource().length()) continue;
            usedAppend = true;
            this.appendRange(this.currentPosition, current);
            int eof = this.prefetchOrEof(current);
            if (eof == -1) {
                this.currentPosition = current;
                return this.decodedString(0, 0);
            }
            current = eof;
        }
        String result2 = !usedAppend ? this.substring(this.currentPosition, current) : this.decodedString(this.currentPosition, current);
        this.currentPosition = current;
        return result2;
    }

    protected void appendRange(int fromIndex, int toIndex) {
        this.escapedString.append(this.getSource(), fromIndex, toIndex);
    }

    private final int appendEsc(int startPosition) {
        int currentPosition = startPosition;
        if ((currentPosition = this.prefetchOrEof(currentPosition)) == -1) {
            AbstractJsonLexer.fail$default(this, "Expected escape sequence to continue, got EOF", 0, null, 6, null);
            throw new KotlinNothingValueException();
        }
        char currentChar = this.getSource().charAt(currentPosition++);
        if (currentChar == 'u') {
            return this.appendHex(this.getSource(), currentPosition);
        }
        char c = AbstractJsonLexerKt.escapeToChar(currentChar);
        if (c == '\u0000') {
            AbstractJsonLexer.fail$default(this, "Invalid escaped char '" + currentChar + '\'', 0, null, 6, null);
            throw new KotlinNothingValueException();
        }
        this.escapedString.append(c);
        return currentPosition;
    }

    private final int appendHex(CharSequence source, int startPos) {
        if (startPos + 4 >= source.length()) {
            this.currentPosition = startPos;
            this.ensureHaveChars();
            if (this.currentPosition + 4 >= source.length()) {
                AbstractJsonLexer.fail$default(this, "Unexpected EOF during unicode escape", 0, null, 6, null);
                throw new KotlinNothingValueException();
            }
            return this.appendHex(source, this.currentPosition);
        }
        this.escapedString.append((char)((this.fromHexChar(source, startPos) << 12) + (this.fromHexChar(source, startPos + 1) << 8) + (this.fromHexChar(source, startPos + 2) << 4) + this.fromHexChar(source, startPos + 3)));
        return startPos + 4;
    }

    public final void require$kotlinx_serialization_json(boolean condition, int position2, @NotNull Function0<String> message2) {
        Intrinsics.checkNotNullParameter(message2, "message");
        boolean $i$f$require$kotlinx_serialization_json = false;
        if (!condition) {
            AbstractJsonLexer.fail$default(this, message2.invoke(), position2, null, 4, null);
            throw new KotlinNothingValueException();
        }
    }

    public static /* synthetic */ void require$kotlinx_serialization_json$default(AbstractJsonLexer $this, boolean condition, int position2, Function0 message2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: require");
        }
        if ((n & 2) != 0) {
            position2 = $this.currentPosition;
        }
        Intrinsics.checkNotNullParameter(message2, "message");
        boolean $i$f$require$kotlinx_serialization_json = false;
        if (!condition) {
            AbstractJsonLexer.fail$default($this, (String)message2.invoke(), position2, null, 4, null);
            throw new KotlinNothingValueException();
        }
    }

    private final int fromHexChar(CharSequence source, int currentPosition) {
        int n;
        char character = source.charAt(currentPosition);
        boolean bl = '0' <= character ? character < ':' : false;
        if (bl) {
            n = character - 48;
        } else {
            boolean bl2 = 'a' <= character ? character < 'g' : false;
            if (bl2) {
                n = character - 97 + 10;
            } else {
                boolean bl3 = 'A' <= character ? character < 'G' : false;
                if (bl3) {
                    n = character - 65 + 10;
                } else {
                    AbstractJsonLexer.fail$default(this, "Invalid toHexChar char '" + character + "' in unicode escape", 0, null, 6, null);
                    throw new KotlinNothingValueException();
                }
            }
        }
        return n;
    }

    public final void skipElement(boolean allowLenientStrings) {
        List tokenStack = new ArrayList();
        byte lastToken = this.peekNextToken();
        if (lastToken != 8 && lastToken != 6) {
            this.consumeStringLenient();
            return;
        }
        while (true) {
            if ((lastToken = this.peekNextToken()) == 1) {
                if (allowLenientStrings) {
                    this.consumeStringLenient();
                    continue;
                }
                this.consumeKeyString();
                continue;
            }
            byte by = lastToken;
            if (by == 8 ? true : by == 6) {
                tokenStack.add(lastToken);
            } else if (by == 9) {
                if (((Number)CollectionsKt.last(tokenStack)).byteValue() != 8) {
                    throw JsonExceptionsKt.JsonDecodingException(this.currentPosition, "found ] instead of } at path: " + this.path, this.getSource());
                }
                CollectionsKt.removeLast(tokenStack);
            } else if (by == 7) {
                if (((Number)CollectionsKt.last(tokenStack)).byteValue() != 6) {
                    throw JsonExceptionsKt.JsonDecodingException(this.currentPosition, "found } instead of ] at path: " + this.path, this.getSource());
                }
                CollectionsKt.removeLast(tokenStack);
            } else if (by == 10) {
                AbstractJsonLexer.fail$default(this, "Unexpected end of input due to malformed JSON during ignoring unknown keys", 0, null, 6, null);
                throw new KotlinNothingValueException();
            }
            this.consumeNextToken();
            if (tokenStack.size() == 0) break;
        }
    }

    @NotNull
    public String toString() {
        return "JsonReader(source='" + this.getSource() + "', currentPosition=" + this.currentPosition + ')';
    }

    public final void failOnUnknownKey(@NotNull String key) {
        Intrinsics.checkNotNullParameter(key, "key");
        String processed = this.substring(0, this.currentPosition);
        int lastIndexOf2 = StringsKt.lastIndexOf$default((CharSequence)processed, key, 0, false, 6, null);
        this.fail("Encountered an unknown key '" + key + '\'', lastIndexOf2, "Use 'ignoreUnknownKeys = true' in 'Json {}' builder to ignore unknown keys.");
        throw new KotlinNothingValueException();
    }

    @NotNull
    public final Void fail(@NotNull String message2, int position2, @NotNull String hint) {
        Intrinsics.checkNotNullParameter(message2, "message");
        Intrinsics.checkNotNullParameter(hint, "hint");
        String hintMessage = ((CharSequence)hint).length() == 0 ? "" : '\n' + hint;
        throw JsonExceptionsKt.JsonDecodingException(position2, message2 + " at path: " + this.path.getPath() + hintMessage, this.getSource());
    }

    public static /* synthetic */ Void fail$default(AbstractJsonLexer abstractJsonLexer, String string2, int n, String string3, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: fail");
        }
        if ((n2 & 2) != 0) {
            n = abstractJsonLexer.currentPosition;
        }
        if ((n2 & 4) != 0) {
            string3 = "";
        }
        return abstractJsonLexer.fail(string2, n, string3);
    }

    public final long consumeNumericLiteral() {
        long l;
        boolean bl;
        int current = this.skipWhitespaces();
        if ((current = this.prefetchOrEof(current)) >= this.getSource().length() || current == -1) {
            AbstractJsonLexer.fail$default(this, "EOF", 0, null, 6, null);
            throw new KotlinNothingValueException();
        }
        if (this.getSource().charAt(current) == '\"') {
            if (++current == this.getSource().length()) {
                AbstractJsonLexer.fail$default(this, "EOF", 0, null, 6, null);
                throw new KotlinNothingValueException();
            }
            bl = true;
        } else {
            bl = false;
        }
        boolean hasQuotation = bl;
        long accumulator = 0L;
        boolean isNegative = false;
        int start2 = current;
        boolean hasChars = true;
        while (hasChars) {
            char ch = this.getSource().charAt(current);
            if (ch == '-') {
                if (current != start2) {
                    AbstractJsonLexer.fail$default(this, "Unexpected symbol '-' in numeric literal", 0, null, 6, null);
                    throw new KotlinNothingValueException();
                }
                isNegative = true;
                ++current;
                continue;
            }
            byte token2 = AbstractJsonLexerKt.charToTokenClass(ch);
            if (token2 != 0) break;
            hasChars = ++current != this.getSource().length();
            int digit = ch - 48;
            if (!(0 <= digit ? digit < 10 : false)) {
                AbstractJsonLexer.fail$default(this, "Unexpected symbol '" + ch + "' in numeric literal", 0, null, 6, null);
                throw new KotlinNothingValueException();
            }
            if ((accumulator = accumulator * (long)10 - (long)digit) <= 0L) continue;
            AbstractJsonLexer.fail$default(this, "Numeric value overflow", 0, null, 6, null);
            throw new KotlinNothingValueException();
        }
        if (start2 == current || isNegative && start2 == current - 1) {
            AbstractJsonLexer.fail$default(this, "Expected numeric literal", 0, null, 6, null);
            throw new KotlinNothingValueException();
        }
        if (hasQuotation) {
            if (!hasChars) {
                AbstractJsonLexer.fail$default(this, "EOF", 0, null, 6, null);
                throw new KotlinNothingValueException();
            }
            if (this.getSource().charAt(current) != '\"') {
                AbstractJsonLexer.fail$default(this, "Expected closing quotation mark", 0, null, 6, null);
                throw new KotlinNothingValueException();
            }
            ++current;
        }
        this.currentPosition = current;
        if (isNegative) {
            l = accumulator;
        } else if (accumulator != Long.MIN_VALUE) {
            l = -accumulator;
        } else {
            AbstractJsonLexer.fail$default(this, "Numeric value overflow", 0, null, 6, null);
            throw new KotlinNothingValueException();
        }
        return l;
    }

    public final boolean consumeBoolean() {
        return this.consumeBoolean(this.skipWhitespaces());
    }

    public final boolean consumeBooleanLenient() {
        boolean bl;
        int current = this.skipWhitespaces();
        if (current == this.getSource().length()) {
            AbstractJsonLexer.fail$default(this, "EOF", 0, null, 6, null);
            throw new KotlinNothingValueException();
        }
        if (this.getSource().charAt(current) == '\"') {
            ++current;
            bl = true;
        } else {
            bl = false;
        }
        boolean hasQuotation = bl;
        boolean result2 = this.consumeBoolean(current);
        if (hasQuotation) {
            if (this.currentPosition == this.getSource().length()) {
                AbstractJsonLexer.fail$default(this, "EOF", 0, null, 6, null);
                throw new KotlinNothingValueException();
            }
            if (this.getSource().charAt(this.currentPosition) != '\"') {
                AbstractJsonLexer.fail$default(this, "Expected closing quotation mark", 0, null, 6, null);
                throw new KotlinNothingValueException();
            }
            ++this.currentPosition;
        }
        return result2;
    }

    private final boolean consumeBoolean(int start2) {
        boolean bl;
        int current = this.prefetchOrEof(start2);
        if (current >= this.getSource().length() || current == -1) {
            AbstractJsonLexer.fail$default(this, "EOF", 0, null, 6, null);
            throw new KotlinNothingValueException();
        }
        switch (this.getSource().charAt(current++) | 0x20) {
            case 116: {
                this.consumeBooleanLiteral("rue", current);
                bl = true;
                break;
            }
            case 102: {
                this.consumeBooleanLiteral("alse", current);
                bl = false;
                break;
            }
            default: {
                AbstractJsonLexer.fail$default(this, "Expected valid boolean literal prefix, but had '" + this.consumeStringLenient() + '\'', 0, null, 6, null);
                throw new KotlinNothingValueException();
            }
        }
        return bl;
    }

    private final void consumeBooleanLiteral(String literalSuffix, int current) {
        if (this.getSource().length() - current < literalSuffix.length()) {
            AbstractJsonLexer.fail$default(this, "Unexpected end of boolean literal", 0, null, 6, null);
            throw new KotlinNothingValueException();
        }
        int n = literalSuffix.length();
        for (int i = 0; i < n; ++i) {
            char actual;
            char expected = literalSuffix.charAt(i);
            if (expected == ((actual = this.getSource().charAt(current + i)) | 0x20)) continue;
            AbstractJsonLexer.fail$default(this, "Expected valid boolean literal prefix, but had '" + this.consumeStringLenient() + '\'', 0, null, 6, null);
            throw new KotlinNothingValueException();
        }
        this.currentPosition = current + literalSuffix.length();
    }
}

