/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.datetime.internal;

import kotlin.Metadata;
import kotlinx.datetime.internal.DivRemResult;
import kotlinx.datetime.internal.MathJvmKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a\u0011\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0082\b\u001a\u0019\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006H\u0082\b\u001a\u0011\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0082\b\u001a(\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u0001H\u0000\u001a \u0010\r\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u0001H\u0000\u001a \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0001H\u0000\u001a\u0018\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u0001H\u0000\u001a\f\u0010\u0014\u001a\u00020\u0006*\u00020\u0001H\u0000\u00a8\u0006\u0015"}, d2={"high", "", "x", "indexBit", "value", "bit", "", "low", "multiplyAddAndDivide", "d", "n", "r", "m", "multiplyAndAdd", "multiplyAndDivide", "Lkotlinx/datetime/internal/DivRemResult;", "a", "b", "c", "safeMultiplyOrZero", "clampToInt", "kotlinx-datetime"})
public final class MathKt {
    public static final int clampToInt(long $this$clampToInt) {
        return $this$clampToInt > Integer.MAX_VALUE ? Integer.MAX_VALUE : ($this$clampToInt < Integer.MIN_VALUE ? Integer.MIN_VALUE : (int)$this$clampToInt);
    }

    public static final long safeMultiplyOrZero(long a, long b) {
        long l = b;
        if (l == -1L) {
            if (a == Long.MIN_VALUE) {
                return 0L;
            }
            return -a;
        }
        if (l == 1L) {
            return a;
        }
        long total = a * b;
        if (total / b != a) {
            return 0L;
        }
        return total;
    }

    @NotNull
    public static final DivRemResult multiplyAndDivide(long a, long b, long c) {
        int sign;
        if (a == 0L || b == 0L) {
            return new DivRemResult(0L, 0L);
        }
        long ab = MathKt.safeMultiplyOrZero(a, b);
        if (ab != 0L) {
            return new DivRemResult(ab / c, ab % c);
        }
        if (b == c) {
            return new DivRemResult(a, 0L);
        }
        if (a == c) {
            return new DivRemResult(b, 0L);
        }
        long ae = a >= 0L ? 0L : -1L;
        long be = b >= 0L ? 0L : -1L;
        boolean $i$f$low = false;
        long al = a & 0xFFFFFFFFL;
        boolean $i$f$high = false;
        long ah = a >> 32 & 0xFFFFFFFFL;
        boolean $i$f$low2 = false;
        long bl = b & 0xFFFFFFFFL;
        boolean $i$f$high2 = false;
        long bh = b >> 32 & 0xFFFFFFFFL;
        long w = ae * bh + ah * be;
        long x = ae * bl + ah * bh + al * be;
        long y1 = ah * bl;
        long y2 = al * bh;
        long z = al * bl;
        boolean $i$f$low3 = false;
        long r4 = z & 0xFFFFFFFFL;
        boolean $i$f$low4 = false;
        $i$f$low4 = false;
        boolean $i$f$high3 = false;
        long r3c = (y1 & 0xFFFFFFFFL) + (y2 & 0xFFFFFFFFL) + (z >> 32 & 0xFFFFFFFFL);
        boolean $i$f$low5 = false;
        long r3 = r3c & 0xFFFFFFFFL;
        boolean $i$f$high4 = false;
        boolean $i$f$low6 = false;
        $i$f$high4 = false;
        $i$f$high4 = false;
        long r2c = (r3c >> 32 & 0xFFFFFFFFL) + (x & 0xFFFFFFFFL) + (y1 >> 32 & 0xFFFFFFFFL) + (y2 >> 32 & 0xFFFFFFFFL);
        boolean $i$f$low7 = false;
        long r2 = r2c & 0xFFFFFFFFL;
        boolean $i$f$high5 = false;
        $i$f$high5 = false;
        boolean $i$f$low8 = false;
        long r1 = (r2c >> 32 & 0xFFFFFFFFL) + (x >> 32 & 0xFFFFFFFFL) + (w & 0xFFFFFFFFL);
        long abl = r3 << 32 | r4;
        long abh = r1 << 32 | r2;
        int bit$iv = 63;
        boolean $i$f$indexBit = false;
        int n = sign = (abh >> bit$iv & 1L) == 1L ? -1 : 1;
        if (sign == -1) {
            abl = (abl ^ 0xFFFFFFFFFFFFFFFFL) + 1L;
            abh ^= 0xFFFFFFFFFFFFFFFFL;
            if (abl == 0L) {
                ++abh;
            }
        }
        long q = 0L;
        long r = 0L;
        for (int bitNo = 127; -1 < bitNo; --bitNo) {
            long l;
            if (bitNo < 64) {
                boolean $i$f$indexBit2 = false;
                l = abl >> bitNo & 1L;
            } else {
                int bit$iv2 = bitNo - 64;
                boolean $i$f$indexBit3 = false;
                l = abh >> bit$iv2 & 1L;
            }
            long nextBit = l;
            r = r << 1 | nextBit;
            if (r < c && r >= 0L) continue;
            r -= c;
            if (bitNo < 63) {
                q |= 1L << bitNo;
                continue;
            }
            throw new ArithmeticException("The result of a multiplication followed by division overflows a long");
        }
        return new DivRemResult((long)sign * q, (long)sign * r);
    }

    private static final long low(long x) {
        boolean $i$f$low = false;
        return x & 0xFFFFFFFFL;
    }

    private static final long high(long x) {
        boolean $i$f$high = false;
        return x >> 32 & 0xFFFFFFFFL;
    }

    private static final long indexBit(long value2, int bit) {
        boolean $i$f$indexBit = false;
        return value2 >> bit & 1L;
    }

    public static final long multiplyAddAndDivide(long d, long n, long r, long m) {
        long l;
        long md = d;
        long mr = r;
        if (d > 0L && r < 0L) {
            l = md;
            md = l + -1L;
            mr += n;
        } else if (d < 0L && r > 0L) {
            l = md;
            md = l + 1L;
            mr -= n;
        }
        if (md == 0L) {
            return mr / m;
        }
        DivRemResult divRemResult = MathKt.multiplyAndDivide(md, n, m);
        long rd = divRemResult.component1();
        long rr = divRemResult.component2();
        return MathJvmKt.safeAdd(rd, MathJvmKt.safeAdd(mr / m, MathJvmKt.safeAdd(mr % m, rr) / m));
    }

    public static final long multiplyAndAdd(long d, long n, long r) {
        long md = d;
        long mr = r;
        if (d > 0L && r < 0L) {
            long l = md;
            md = l + -1L;
            mr += n;
        } else if (d < 0L && r > 0L) {
            long l = md;
            md = l + 1L;
            mr -= n;
        }
        return MathJvmKt.safeAdd(MathJvmKt.safeMultiply(md, n), mr);
    }
}

