/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.datetime;

import java.time.DateTimeException;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.datetime.DateTimeArithmeticException;
import kotlinx.datetime.DateTimePeriod;
import kotlinx.datetime.DateTimePeriodKt;
import kotlinx.datetime.DateTimeUnit;
import kotlinx.datetime.Instant;
import kotlinx.datetime.InstantKt;
import kotlinx.datetime.TimeZone;
import kotlinx.datetime.UtcOffset;
import kotlinx.datetime.internal.DivRemResult;
import kotlinx.datetime.internal.MathJvmKt;
import kotlinx.datetime.internal.MathKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\"\u0010\u0005\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0004\u001a\u001a\u0010\u000b\u001a\u00020\f*\u00020\u00022\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u0004\u001a\"\u0010\u000e\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0004\u001a\"\u0010\u000e\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0004\u001a\u001a\u0010\u000e\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\u0010\u001a\u001a\u0010\u000e\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u0004\u001a\u001a\u0010\u000e\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0004\u001a\u0014\u0010\u0012\u001a\u00020\u0013*\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u001a\"\u0010\u0016\u001a\u00020\u000f*\u00020\u00022\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0004\u00a8\u0006\u0017"}, d2={"atZone", "Ljava/time/ZonedDateTime;", "Lkotlinx/datetime/Instant;", "zone", "Lkotlinx/datetime/TimeZone;", "minus", "value", "", "unit", "Lkotlinx/datetime/DateTimeUnit;", "timeZone", "periodUntil", "Lkotlinx/datetime/DateTimePeriod;", "other", "plus", "", "Lkotlinx/datetime/DateTimeUnit$TimeBased;", "period", "toStringWithOffset", "", "offset", "Lkotlinx/datetime/UtcOffset;", "until", "kotlinx-datetime"})
@JvmName(name="InstantJvmKt")
public final class InstantJvmKt {
    private static final ZonedDateTime atZone(Instant $this$atZone, TimeZone zone) {
        ZonedDateTime zonedDateTime;
        try {
            ZonedDateTime zonedDateTime2 = $this$atZone.getValue$kotlinx_datetime().atZone(zone.getZoneId$kotlinx_datetime());
            Intrinsics.checkNotNullExpressionValue(zonedDateTime2, "{\n    value.atZone(zone.zoneId)\n}");
            zonedDateTime = zonedDateTime2;
        }
        catch (DateTimeException e) {
            throw new DateTimeArithmeticException(e);
        }
        return zonedDateTime;
    }

    @NotNull
    public static final Instant plus(@NotNull Instant $this$plus, @NotNull DateTimePeriod period, @NotNull TimeZone timeZone) {
        Intrinsics.checkNotNullParameter($this$plus, "<this>");
        Intrinsics.checkNotNullParameter(period, "period");
        Intrinsics.checkNotNullParameter(timeZone, "timeZone");
        try {
            ZonedDateTime thisZdt = InstantJvmKt.atZone($this$plus, timeZone);
            DateTimePeriod $this$plus_u24lambda_u2d3 = period;
            boolean bl = false;
            ZonedDateTime $this$plus_u24lambda_u2d3_u24lambda_u2d0 = thisZdt;
            boolean bl2 = false;
            ZonedDateTime $this$plus_u24lambda_u2d3_u24lambda_u2d1 = $this$plus_u24lambda_u2d3.getTotalMonths$kotlinx_datetime() != 0 ? $this$plus_u24lambda_u2d3_u24lambda_u2d0.plusMonths($this$plus_u24lambda_u2d3.getTotalMonths$kotlinx_datetime()) : $this$plus_u24lambda_u2d3_u24lambda_u2d0;
            boolean bl3 = false;
            ZonedDateTime $this$plus_u24lambda_u2d3_u24lambda_u2d2 = $this$plus_u24lambda_u2d3.getDays() != 0 ? $this$plus_u24lambda_u2d3_u24lambda_u2d1.plusDays($this$plus_u24lambda_u2d3.getDays()) : $this$plus_u24lambda_u2d3_u24lambda_u2d1;
            boolean bl4 = false;
            java.time.Instant p0 = ($this$plus_u24lambda_u2d3.getTotalNanoseconds$kotlinx_datetime() != 0L ? $this$plus_u24lambda_u2d3_u24lambda_u2d2.plusNanos($this$plus_u24lambda_u2d3.getTotalNanoseconds$kotlinx_datetime()) : $this$plus_u24lambda_u2d3_u24lambda_u2d2).toInstant();
            boolean bl5 = false;
            return new Instant(p0);
        }
        catch (DateTimeException e) {
            throw new DateTimeArithmeticException(e);
        }
    }

    @NotNull
    public static final Instant plus(@NotNull Instant $this$plus, @NotNull DateTimeUnit unit, @NotNull TimeZone timeZone) {
        Intrinsics.checkNotNullParameter($this$plus, "<this>");
        Intrinsics.checkNotNullParameter(unit, "unit");
        Intrinsics.checkNotNullParameter(timeZone, "timeZone");
        return InstantJvmKt.plus($this$plus, 1L, unit, timeZone);
    }

    @NotNull
    public static final Instant plus(@NotNull Instant $this$plus, int value2, @NotNull DateTimeUnit unit, @NotNull TimeZone timeZone) {
        Intrinsics.checkNotNullParameter($this$plus, "<this>");
        Intrinsics.checkNotNullParameter(unit, "unit");
        Intrinsics.checkNotNullParameter(timeZone, "timeZone");
        return InstantJvmKt.plus($this$plus, (long)value2, unit, timeZone);
    }

    @NotNull
    public static final Instant minus(@NotNull Instant $this$minus, int value2, @NotNull DateTimeUnit unit, @NotNull TimeZone timeZone) {
        Intrinsics.checkNotNullParameter($this$minus, "<this>");
        Intrinsics.checkNotNullParameter(unit, "unit");
        Intrinsics.checkNotNullParameter(timeZone, "timeZone");
        return InstantJvmKt.plus($this$minus, -((long)value2), unit, timeZone);
    }

    @NotNull
    public static final Instant plus(@NotNull Instant $this$plus, long value2, @NotNull DateTimeUnit unit, @NotNull TimeZone timeZone) {
        Instant instant;
        Intrinsics.checkNotNullParameter($this$plus, "<this>");
        Intrinsics.checkNotNullParameter(unit, "unit");
        Intrinsics.checkNotNullParameter(timeZone, "timeZone");
        try {
            java.time.Instant instant2;
            ZonedDateTime thisZdt = InstantJvmKt.atZone($this$plus, timeZone);
            DateTimeUnit dateTimeUnit = unit;
            if (dateTimeUnit instanceof DateTimeUnit.TimeBased) {
                java.time.Instant instant3;
                java.time.Instant it = instant3 = InstantJvmKt.plus($this$plus, value2, (DateTimeUnit.TimeBased)unit).getValue$kotlinx_datetime();
                boolean bl = false;
                it.atZone(timeZone.getZoneId$kotlinx_datetime());
                instant2 = instant3;
            } else if (dateTimeUnit instanceof DateTimeUnit.DayBased) {
                instant2 = thisZdt.plusDays(MathJvmKt.safeMultiply(value2, (long)((DateTimeUnit.DayBased)unit).getDays())).toInstant();
            } else if (dateTimeUnit instanceof DateTimeUnit.MonthBased) {
                instant2 = thisZdt.plusMonths(MathJvmKt.safeMultiply(value2, (long)((DateTimeUnit.MonthBased)unit).getMonths())).toInstant();
            } else {
                throw new NoWhenBranchMatchedException();
            }
            java.time.Instant p0 = instant2;
            boolean bl = false;
            instant = new Instant(p0);
        }
        catch (Exception e) {
            if (!(e instanceof DateTimeException) && !(e instanceof ArithmeticException)) {
                throw e;
            }
            throw new DateTimeArithmeticException("Instant " + $this$plus + " cannot be represented as local date when adding " + value2 + ' ' + unit + " to it", e);
        }
        return instant;
    }

    @NotNull
    public static final Instant plus(@NotNull Instant $this$plus, long value2, @NotNull DateTimeUnit.TimeBased unit) {
        Instant instant;
        Intrinsics.checkNotNullParameter($this$plus, "<this>");
        Intrinsics.checkNotNullParameter(unit, "unit");
        try {
            DivRemResult divRemResult = MathKt.multiplyAndDivide(value2, unit.getNanoseconds(), 1000000000L);
            boolean bl = false;
            long d = divRemResult.component1();
            long r = divRemResult.component2();
            java.time.Instant instant2 = $this$plus.getValue$kotlinx_datetime().plusSeconds(d).plusNanos(r);
            Intrinsics.checkNotNullExpressionValue(instant2, "this.value.plusSeconds(d).plusNanos(r)");
            instant = new Instant(instant2);
        }
        catch (Exception e) {
            if (!(e instanceof DateTimeException) && !(e instanceof ArithmeticException)) {
                throw e;
            }
            instant = value2 > 0L ? Instant.Companion.getMAX$kotlinx_datetime() : Instant.Companion.getMIN$kotlinx_datetime();
        }
        return instant;
    }

    @NotNull
    public static final DateTimePeriod periodUntil(@NotNull Instant $this$periodUntil, @NotNull Instant other, @NotNull TimeZone timeZone) {
        Intrinsics.checkNotNullParameter($this$periodUntil, "<this>");
        Intrinsics.checkNotNullParameter(other, "other");
        Intrinsics.checkNotNullParameter(timeZone, "timeZone");
        ZonedDateTime thisZdt = InstantJvmKt.atZone($this$periodUntil, timeZone);
        ZonedDateTime otherZdt = InstantJvmKt.atZone(other, timeZone);
        long months = thisZdt.until(otherZdt, ChronoUnit.MONTHS);
        ZonedDateTime zonedDateTime = thisZdt.plusMonths(months);
        Intrinsics.checkNotNullExpressionValue(zonedDateTime, "thisZdt.plusMonths(months)");
        thisZdt = zonedDateTime;
        long days = thisZdt.until(otherZdt, ChronoUnit.DAYS);
        ZonedDateTime zonedDateTime2 = thisZdt.plusDays(days);
        Intrinsics.checkNotNullExpressionValue(zonedDateTime2, "thisZdt.plusDays(days)");
        thisZdt = zonedDateTime2;
        long nanoseconds = thisZdt.until(otherZdt, ChronoUnit.NANOS);
        if (months > Integer.MAX_VALUE || months < Integer.MIN_VALUE) {
            throw new DateTimeArithmeticException("The number of months between " + $this$periodUntil + " and " + other + " does not fit in an Int");
        }
        return DateTimePeriodKt.buildDateTimePeriod((int)months, (int)days, nanoseconds);
    }

    public static final long until(@NotNull Instant $this$until, @NotNull Instant other, @NotNull DateTimeUnit unit, @NotNull TimeZone timeZone) {
        long l;
        Intrinsics.checkNotNullParameter($this$until, "<this>");
        Intrinsics.checkNotNullParameter(other, "other");
        Intrinsics.checkNotNullParameter(unit, "unit");
        Intrinsics.checkNotNullParameter(timeZone, "timeZone");
        try {
            long l2;
            ZonedDateTime thisZdt = InstantJvmKt.atZone($this$until, timeZone);
            ZonedDateTime otherZdt = InstantJvmKt.atZone(other, timeZone);
            DateTimeUnit dateTimeUnit = unit;
            if (dateTimeUnit instanceof DateTimeUnit.TimeBased) {
                l2 = InstantKt.until($this$until, other, (DateTimeUnit.TimeBased)unit);
            } else if (dateTimeUnit instanceof DateTimeUnit.DayBased) {
                l2 = thisZdt.until(otherZdt, ChronoUnit.DAYS) / (long)((DateTimeUnit.DayBased)unit).getDays();
            } else if (dateTimeUnit instanceof DateTimeUnit.MonthBased) {
                l2 = thisZdt.until(otherZdt, ChronoUnit.MONTHS) / (long)((DateTimeUnit.MonthBased)unit).getMonths();
            } else {
                throw new NoWhenBranchMatchedException();
            }
            l = l2;
        }
        catch (DateTimeException e) {
            throw new DateTimeArithmeticException(e);
        }
        catch (ArithmeticException e) {
            l = $this$until.getValue$kotlinx_datetime().compareTo(other.getValue$kotlinx_datetime()) < 0 ? Long.MAX_VALUE : Long.MIN_VALUE;
        }
        return l;
    }

    @NotNull
    public static final String toStringWithOffset(@NotNull Instant $this$toStringWithOffset, @NotNull UtcOffset offset) {
        Intrinsics.checkNotNullParameter($this$toStringWithOffset, "<this>");
        Intrinsics.checkNotNullParameter(offset, "offset");
        String string2 = OffsetDateTime.ofInstant($this$toStringWithOffset.getValue$kotlinx_datetime(), offset.getZoneOffset$kotlinx_datetime()).toString();
        Intrinsics.checkNotNullExpressionValue(string2, "ofInstant(this.value, of\u2026et.zoneOffset).toString()");
        return string2;
    }
}

