/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.utils.io.internal;

import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0001H\u0000\u001a\u0014\u0010\u0005\u001a\u00020\u0001*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0000\u001a\f\u0010\b\u001a\u00020\t*\u00020\u0006H\u0000\u001a\u001e\u0010\n\u001a\u00020\u0001*\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u00062\b\b\u0002\u0010\f\u001a\u00020\u0001H\u0000\u001a\u001e\u0010\r\u001a\u00020\u0001*\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u00062\b\b\u0002\u0010\u000e\u001a\u00020\u0001H\u0000\u001a\u001e\u0010\u000f\u001a\u00020\t*\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00062\b\b\u0002\u0010\u0011\u001a\u00020\u0001H\u0000\u00a8\u0006\u0012"}, d2={"getIOIntProperty", "", "name", "", "default", "indexOfPartial", "Ljava/nio/ByteBuffer;", "sub", "isEmpty", "", "putAtMost", "src", "n", "putLimited", "limit", "startsWith", "prefix", "prefixSkip", "ktor-io"})
public final class UtilsKt {
    public static final boolean isEmpty(@NotNull ByteBuffer $this$isEmpty) {
        Intrinsics.checkNotNullParameter($this$isEmpty, "<this>");
        return !$this$isEmpty.hasRemaining();
    }

    public static final int getIOIntProperty(@NotNull String name2, int n) {
        Object object;
        Intrinsics.checkNotNullParameter(name2, "name");
        try {
            object = System.getProperty("io.ktor.utils.io." + name2);
        }
        catch (SecurityException e) {
            object = null;
        }
        String string2 = object;
        return string2 != null && (object = StringsKt.toIntOrNull(string2)) != null ? (Integer)object : n;
    }

    public static final int indexOfPartial(@NotNull ByteBuffer $this$indexOfPartial, @NotNull ByteBuffer sub) {
        Intrinsics.checkNotNullParameter($this$indexOfPartial, "<this>");
        Intrinsics.checkNotNullParameter(sub, "sub");
        int subPosition = sub.position();
        int subSize = sub.remaining();
        byte first2 = sub.get(subPosition);
        int limit2 = $this$indexOfPartial.limit();
        block0: for (int idx = $this$indexOfPartial.position(); idx < limit2; ++idx) {
            if ($this$indexOfPartial.get(idx) != first2) continue;
            for (int j = 1; j < subSize && idx + j != limit2; ++j) {
                if ($this$indexOfPartial.get(idx + j) != sub.get(subPosition + j)) continue block0;
            }
            return idx - $this$indexOfPartial.position();
        }
        return -1;
    }

    public static final boolean startsWith(@NotNull ByteBuffer $this$startsWith, @NotNull ByteBuffer prefix, int prefixSkip) {
        Intrinsics.checkNotNullParameter($this$startsWith, "<this>");
        Intrinsics.checkNotNullParameter(prefix, "prefix");
        int size2 = Math.min($this$startsWith.remaining(), prefix.remaining() - prefixSkip);
        if (size2 <= 0) {
            return false;
        }
        int position2 = $this$startsWith.position();
        int prefixPosition = prefix.position() + prefixSkip;
        for (int i = 0; i < size2; ++i) {
            if ($this$startsWith.get(position2 + i) == prefix.get(prefixPosition + i)) continue;
            return false;
        }
        return true;
    }

    public static /* synthetic */ boolean startsWith$default(ByteBuffer byteBuffer, ByteBuffer byteBuffer2, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return UtilsKt.startsWith(byteBuffer, byteBuffer2, n);
    }

    public static final int putAtMost(@NotNull ByteBuffer $this$putAtMost, @NotNull ByteBuffer src, int n) {
        int n2;
        Intrinsics.checkNotNullParameter($this$putAtMost, "<this>");
        Intrinsics.checkNotNullParameter(src, "src");
        int rem = $this$putAtMost.remaining();
        int srcRem = src.remaining();
        if (srcRem <= rem && srcRem <= n) {
            $this$putAtMost.put(src);
            n2 = srcRem;
        } else {
            int idx = 1;
            int size2 = Math.min(rem, Math.min(srcRem, n));
            if (idx <= size2) {
                while (true) {
                    $this$putAtMost.put(src.get());
                    if (idx == size2) break;
                    ++idx;
                }
            }
            n2 = size2;
        }
        return n2;
    }

    public static /* synthetic */ int putAtMost$default(ByteBuffer byteBuffer, ByteBuffer byteBuffer2, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = byteBuffer2.remaining();
        }
        return UtilsKt.putAtMost(byteBuffer, byteBuffer2, n);
    }

    public static final int putLimited(@NotNull ByteBuffer $this$putLimited, @NotNull ByteBuffer src, int limit2) {
        Intrinsics.checkNotNullParameter($this$putLimited, "<this>");
        Intrinsics.checkNotNullParameter(src, "src");
        return UtilsKt.putAtMost($this$putLimited, src, limit2 - src.position());
    }

    public static /* synthetic */ int putLimited$default(ByteBuffer byteBuffer, ByteBuffer byteBuffer2, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = byteBuffer.limit();
        }
        return UtilsKt.putLimited(byteBuffer, byteBuffer2, n);
    }
}

