/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.serialization.kotlinx;

import io.ktor.serialization.WebsocketContentConverter;
import io.ktor.serialization.WebsocketConverterNotFoundException;
import io.ktor.serialization.WebsocketDeserializeException;
import io.ktor.serialization.kotlinx.KotlinxSerializationBase;
import io.ktor.serialization.kotlinx.KotlinxWebsocketSerializationConverter;
import io.ktor.serialization.kotlinx.SerializationParameters;
import io.ktor.serialization.kotlinx.SerializerLookupKt;
import io.ktor.util.reflect.TypeInfo;
import io.ktor.websocket.Frame;
import io.ktor.websocket.FrameCommonKt;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.BinaryFormat;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerialFormat;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.StringFormat;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000G\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004*\u0001\u0006\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J/\u0010\b\u001a\u0004\u0018\u00010\t2\n\u0010\n\u001a\u00060\u000bj\u0002`\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0010H\u0016J&\u0010\u0015\u001a\u00020\u00102\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u00172\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0018\u001a\u0004\u0018\u00010\tH\u0002J/\u0010\u0019\u001a\u00020\u00102\n\u0010\n\u001a\u00060\u000bj\u0002`\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u0018\u001a\u0004\u0018\u00010\tH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001aR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001b"}, d2={"Lio/ktor/serialization/kotlinx/KotlinxWebsocketSerializationConverter;", "Lio/ktor/serialization/WebsocketContentConverter;", "format", "Lkotlinx/serialization/SerialFormat;", "(Lkotlinx/serialization/SerialFormat;)V", "serializationBase", "io/ktor/serialization/kotlinx/KotlinxWebsocketSerializationConverter$serializationBase$1", "Lio/ktor/serialization/kotlinx/KotlinxWebsocketSerializationConverter$serializationBase$1;", "deserialize", "", "charset", "Ljava/nio/charset/Charset;", "Lio/ktor/utils/io/charsets/Charset;", "typeInfo", "Lio/ktor/util/reflect/TypeInfo;", "content", "Lio/ktor/websocket/Frame;", "(Ljava/nio/charset/Charset;Lio/ktor/util/reflect/TypeInfo;Lio/ktor/websocket/Frame;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "isApplicable", "", "frame", "serializeContent", "serializer", "Lkotlinx/serialization/KSerializer;", "value", "serializeNullable", "(Ljava/nio/charset/Charset;Lio/ktor/util/reflect/TypeInfo;Ljava/lang/Object;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "ktor-serialization-kotlinx"})
public final class KotlinxWebsocketSerializationConverter
implements WebsocketContentConverter {
    @NotNull
    private final SerialFormat format;
    @NotNull
    private final serializationBase.1 serializationBase;

    public KotlinxWebsocketSerializationConverter(@NotNull SerialFormat format) {
        Intrinsics.checkNotNullParameter(format, "format");
        this.format = format;
        if (!(this.format instanceof BinaryFormat || this.format instanceof StringFormat)) {
            boolean bl = false;
            String string2 = "Only binary and string formats are supported, " + this.format + " is not supported.";
            throw new IllegalArgumentException(string2.toString());
        }
        SerialFormat serialFormat = this.format;
        this.serializationBase = new KotlinxSerializationBase<Frame>(this, serialFormat){
            final /* synthetic */ KotlinxWebsocketSerializationConverter this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            @Nullable
            public Object serializeContent$ktor_serialization_kotlinx(@NotNull SerializationParameters parameters2, @NotNull Continuation<? super Frame> $completion) {
                return KotlinxWebsocketSerializationConverter.access$serializeContent(this.this$0, parameters2.getSerializer(), parameters2.getFormat(), parameters2.getValue());
            }
        };
    }

    @Override
    @Nullable
    public Object serializeNullable(@NotNull Charset charset, @NotNull TypeInfo typeInfo, @Nullable Object value2, @NotNull Continuation<? super Frame> $completion) {
        return this.serializationBase.serialize$ktor_serialization_kotlinx(new SerializationParameters(this.format, value2, typeInfo, charset), $completion);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Nullable
    public Object deserialize(@NotNull Charset charset, @NotNull TypeInfo typeInfo, @NotNull Frame content2, @NotNull Continuation<Object> $completion) {
        Object t;
        if (!this.isApplicable(content2)) {
            throw new WebsocketConverterNotFoundException("Unsupported frame " + content2.getFrameType().name(), null, 2, null);
        }
        KSerializer<?> serializer2 = SerializerLookupKt.serializerFromTypeInfo(typeInfo, this.format.getSerializersModule());
        SerialFormat serialFormat = this.format;
        if (serialFormat instanceof StringFormat) {
            if (!(content2 instanceof Frame.Text)) throw new WebsocketDeserializeException("Unsupported format " + this.format + " for " + content2.getFrameType().name(), null, content2, 2, null);
            t = ((StringFormat)this.format).decodeFromString(serializer2, FrameCommonKt.readText((Frame.Text)content2));
            return t;
        } else if (serialFormat instanceof BinaryFormat) {
            if (!(content2 instanceof Frame.Binary)) throw new WebsocketDeserializeException("Unsupported format " + this.format + " for " + content2.getFrameType().name(), null, content2, 2, null);
            t = ((BinaryFormat)this.format).decodeFromByteArray(serializer2, FrameCommonKt.readBytes(content2));
            return t;
        } else {
            String string2 = "Unsupported format " + this.format;
            throw new IllegalStateException(string2.toString());
        }
    }

    @Override
    public boolean isApplicable(@NotNull Frame frame) {
        Intrinsics.checkNotNullParameter(frame, "frame");
        return frame instanceof Frame.Text || frame instanceof Frame.Binary;
    }

    private final Frame serializeContent(KSerializer<?> serializer2, SerialFormat format, Object value2) {
        Frame frame;
        SerialFormat serialFormat = format;
        if (serialFormat instanceof StringFormat) {
            String content2 = ((StringFormat)format).encodeToString((SerializationStrategy)serializer2, value2);
            frame = new Frame.Text(content2);
        } else if (serialFormat instanceof BinaryFormat) {
            byte[] content3 = ((BinaryFormat)format).encodeToByteArray((SerializationStrategy)serializer2, value2);
            frame = new Frame.Binary(true, content3);
        } else {
            throw new IllegalStateException(("Unsupported format " + format).toString());
        }
        return frame;
    }

    @Override
    @Nullable
    public Object serialize(@NotNull Charset charset, @NotNull TypeInfo typeInfo, @NotNull Object value2, @NotNull Continuation<? super Frame> $completion) {
        return WebsocketContentConverter.DefaultImpls.serialize(this, charset, typeInfo, value2, $completion);
    }

    public static final /* synthetic */ Frame access$serializeContent(KotlinxWebsocketSerializationConverter $this, KSerializer serializer2, SerialFormat format, Object value2) {
        return $this.serializeContent(serializer2, format, value2);
    }
}

