/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.network.tls.extensions;

import io.ktor.network.tls.OID;
import io.ktor.network.tls.TLSException;
import io.ktor.network.tls.extensions.HashAlgorithm;
import io.ktor.network.tls.extensions.HashAndSign;
import io.ktor.network.tls.extensions.SignatureAlgorithm;
import io.ktor.utils.io.core.ByteReadPacket;
import io.ktor.utils.io.core.InputPrimitivesKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a&\u0010\u0005\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\nH\u0000\u001a\u001c\u0010\u000b\u001a\u0004\u0018\u00010\u0002*\u00020\f2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0007\u001a\u0012\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u0010H\u0000\u001a\u000e\u0010\u0011\u001a\u0004\u0018\u00010\u0002*\u00020\u0010H\u0000\"\u0017\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0012"}, d2={"SupportedSignatureAlgorithms", "", "Lio/ktor/network/tls/extensions/HashAndSign;", "getSupportedSignatureAlgorithms", "()Ljava/util/List;", "HashAndSign", "hashValue", "", "signValue", "oidValue", "", "byCode", "Lio/ktor/network/tls/extensions/HashAndSign$Companion;", "hash", "sign", "parseSignatureAlgorithms", "Lio/ktor/utils/io/core/ByteReadPacket;", "readHashAndSign", "ktor-network-tls"})
public final class SignatureAlgorithmKt {
    @NotNull
    private static final List<HashAndSign> SupportedSignatureAlgorithms;

    @Nullable
    public static final HashAndSign HashAndSign(byte hashValue, byte signValue, @Nullable String oidValue) {
        OID oID;
        HashAlgorithm hash = HashAlgorithm.Companion.byCode(hashValue);
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.Companion.byCode(signValue);
        if (signatureAlgorithm == null) {
            return null;
        }
        SignatureAlgorithm sign = signatureAlgorithm;
        String string2 = oidValue;
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            oID = new OID(it);
        } else {
            oID = null;
        }
        OID oid = oID;
        return new HashAndSign(hash, sign, oid);
    }

    public static /* synthetic */ HashAndSign HashAndSign$default(byte by, byte by2, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = null;
        }
        return SignatureAlgorithmKt.HashAndSign(by, by2, string2);
    }

    @NotNull
    public static final List<HashAndSign> getSupportedSignatureAlgorithms() {
        return SupportedSignatureAlgorithms;
    }

    @NotNull
    public static final List<HashAndSign> parseSignatureAlgorithms(@NotNull ByteReadPacket $this$parseSignatureAlgorithms) {
        Intrinsics.checkNotNullParameter($this$parseSignatureAlgorithms, "<this>");
        int length = InputPrimitivesKt.readShort($this$parseSignatureAlgorithms) & 0xFFFF;
        List result2 = new ArrayList();
        while ($this$parseSignatureAlgorithms.getRemaining() > 0L) {
            Collection collection = result2;
            HashAndSign hashAndSign = SignatureAlgorithmKt.readHashAndSign($this$parseSignatureAlgorithms);
            if (hashAndSign == null) continue;
            collection.add(hashAndSign);
        }
        if ((int)$this$parseSignatureAlgorithms.getRemaining() != length) {
            throw new TLSException("Invalid hash and sign packet size: expected " + length + ", actual " + result2.size(), null, 2, null);
        }
        return result2;
    }

    @Nullable
    public static final HashAndSign readHashAndSign(@NotNull ByteReadPacket $this$readHashAndSign) {
        Intrinsics.checkNotNullParameter($this$readHashAndSign, "<this>");
        byte hash = $this$readHashAndSign.readByte();
        byte sign = $this$readHashAndSign.readByte();
        return SignatureAlgorithmKt.byCode(HashAndSign.Companion, hash, sign);
    }

    @Nullable
    public static final HashAndSign byCode(@NotNull HashAndSign.Companion $this$byCode, byte hash, byte sign) {
        HashAndSign hashAndSign;
        Object v0;
        block3: {
            Intrinsics.checkNotNullParameter($this$byCode, "<this>");
            if (!(sign != SignatureAlgorithm.ANON.getCode())) {
                boolean bl = false;
                String string2 = "Anonymous signature not allowed.";
                throw new IllegalStateException(string2.toString());
            }
            Iterable iterable = SupportedSignatureAlgorithms;
            for (Object t : iterable) {
                HashAndSign it = (HashAndSign)t;
                boolean bl = false;
                if (!(it.getHash().getCode() == hash && it.getSign().getCode() == sign)) continue;
                v0 = t;
                break block3;
            }
            v0 = null;
        }
        if ((hashAndSign = (HashAndSign)v0) == null) {
            hashAndSign = SignatureAlgorithmKt.HashAndSign$default(hash, sign, null, 4, null);
        }
        return hashAndSign;
    }

    static {
        HashAndSign[] hashAndSignArray = new HashAndSign[]{new HashAndSign(HashAlgorithm.SHA384, SignatureAlgorithm.ECDSA, OID.Companion.getECDSAwithSHA384Encryption()), new HashAndSign(HashAlgorithm.SHA256, SignatureAlgorithm.ECDSA, OID.Companion.getECDSAwithSHA256Encryption()), new HashAndSign(HashAlgorithm.SHA512, SignatureAlgorithm.RSA, OID.Companion.getRSAwithSHA512Encryption()), new HashAndSign(HashAlgorithm.SHA384, SignatureAlgorithm.RSA, OID.Companion.getRSAwithSHA384Encryption()), new HashAndSign(HashAlgorithm.SHA256, SignatureAlgorithm.RSA, OID.Companion.getRSAwithSHA256Encryption()), new HashAndSign(HashAlgorithm.SHA1, SignatureAlgorithm.RSA, OID.Companion.getRSAwithSHA1Encryption())};
        SupportedSignatureAlgorithms = CollectionsKt.listOf(hashAndSignArray);
    }
}

