/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http;

import io.ktor.http.ContentRange;
import io.ktor.http.RangesSpecifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.LongRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\u001a\u0010\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0018\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005*\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0000\u001a \u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005*\b\u0012\u0004\u0012\u00020\b0\u00052\u0006\u0010\t\u001a\u00020\nH\u0000\u00a8\u0006\u000b"}, d2={"parseRangesSpecifier", "Lio/ktor/http/RangesSpecifier;", "rangeSpec", "", "mergeRangesKeepOrder", "", "Lkotlin/ranges/LongRange;", "toLongRanges", "Lio/ktor/http/ContentRange;", "contentLength", "", "ktor-http"})
public final class RangesKt {
    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final RangesSpecifier parseRangesSpecifier(@NotNull String rangeSpec) {
        Intrinsics.checkNotNullParameter(rangeSpec, "rangeSpec");
        try {
            void $this$mapTo$iv$iv;
            void $this$chomp$iv;
            String string2 = rangeSpec;
            String separator$iv = "=";
            boolean $i$f$chomp = false;
            int idx$iv22 = StringsKt.indexOf$default((CharSequence)$this$chomp$iv, separator$iv, 0, false, 6, null);
            if (idx$iv22 == -1) {
                boolean bl = false;
                return null;
            }
            String string3 = $this$chomp$iv.substring(0, idx$iv22);
            Intrinsics.checkNotNullExpressionValue(string3, "this as java.lang.String\u2026ing(startIndex, endIndex)");
            String string4 = $this$chomp$iv.substring(idx$iv22 + 1);
            Intrinsics.checkNotNullExpressionValue(string4, "this as java.lang.String).substring(startIndex)");
            Pair<String, String> pair = TuplesKt.to(string3, string4);
            String unit = pair.component1();
            String allRangesString = pair.component2();
            char[] idx$iv22 = new char[]{','};
            Iterable $this$map$iv = StringsKt.split$default((CharSequence)allRangesString, idx$iv22, false, 0, 6, null);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                ContentRange contentRange;
                void it;
                String string5 = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                if (StringsKt.startsWith$default((String)it, "-", false, 2, null)) {
                    contentRange = new ContentRange.Suffix(Long.parseLong(StringsKt.removePrefix((String)it, (CharSequence)"-")));
                } else {
                    Pair<String, String> pair2;
                    void $this$chomp$iv2;
                    void var14_18 = it;
                    String separator$iv2 = "-";
                    boolean $i$f$chomp2 = false;
                    int idx$iv = StringsKt.indexOf$default((CharSequence)$this$chomp$iv2, separator$iv2, 0, false, 6, null);
                    if (idx$iv == -1) {
                        boolean bl2 = false;
                        pair2 = TuplesKt.to("", "");
                    } else {
                        String string6 = $this$chomp$iv2.substring(0, idx$iv);
                        Intrinsics.checkNotNullExpressionValue(string6, "this as java.lang.String\u2026ing(startIndex, endIndex)");
                        String string7 = $this$chomp$iv2.substring(idx$iv + 1);
                        Intrinsics.checkNotNullExpressionValue(string7, "this as java.lang.String).substring(startIndex)");
                        pair2 = TuplesKt.to(string6, string7);
                    }
                    Pair<String, String> pair3 = pair2;
                    String from2 = pair3.component1();
                    String to = pair3.component2();
                    contentRange = ((CharSequence)to).length() > 0 ? (ContentRange)new ContentRange.Bounded(Long.parseLong(from2), Long.parseLong(to)) : (ContentRange)new ContentRange.TailFrom(Long.parseLong(from2));
                }
                collection.add(contentRange);
            }
            List allRanges = (List)destination$iv$iv;
            if (allRanges.isEmpty() || ((CharSequence)unit).length() == 0) {
                return null;
            }
            RangesSpecifier spec = new RangesSpecifier(unit, (List<? extends ContentRange>)allRanges);
            return RangesSpecifier.isValid$default(spec, null, 1, null) ? spec : null;
        }
        catch (Throwable e) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<LongRange> toLongRanges(@NotNull List<? extends ContentRange> $this$toLongRanges, long contentLength) {
        void $this$filterNotTo$iv$iv;
        LongRange it;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$toLongRanges, "<this>");
        Iterable $this$map$iv = $this$toLongRanges;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            LongRange longRange;
            ContentRange contentRange = (ContentRange)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            LongRange longRange2 = it;
            if (longRange2 instanceof ContentRange.Bounded) {
                longRange = new LongRange(((ContentRange.Bounded)((Object)it)).getFrom(), kotlin.ranges.RangesKt.coerceAtMost(((ContentRange.Bounded)((Object)it)).getTo(), contentLength - 1L));
            } else if (longRange2 instanceof ContentRange.TailFrom) {
                longRange = kotlin.ranges.RangesKt.until(((ContentRange.TailFrom)((Object)it)).getFrom(), contentLength);
            } else if (longRange2 instanceof ContentRange.Suffix) {
                longRange = kotlin.ranges.RangesKt.until(kotlin.ranges.RangesKt.coerceAtLeast(contentLength - ((ContentRange.Suffix)((Object)it)).getLastCount(), 0L), contentLength);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            collection.add(longRange);
        }
        Iterable $this$filterNot$iv = (List)destination$iv$iv;
        boolean $i$f$filterNot = false;
        $this$mapTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (LongRange)element$iv$iv;
            boolean bl = false;
            if (it.isEmpty()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<LongRange> mergeRangesKeepOrder(@NotNull List<LongRange> $this$mergeRangesKeepOrder) {
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter($this$mergeRangesKeepOrder, "<this>");
        Iterable $this$sortedBy$iv = $this$mergeRangesKeepOrder;
        boolean $i$f$sortedBy = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

            public final int compare(T a, T b) {
                LongRange it = (LongRange)a;
                boolean bl = false;
                Comparable comparable = it.getStart();
                it = (LongRange)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, (Comparable)it.getStart());
            }
        });
        ArrayList<Object> initial$iv = new ArrayList<Object>($this$mergeRangesKeepOrder.size());
        boolean bl = false;
        ArrayList<Object> accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void range;
            LongRange longRange = (LongRange)element$iv;
            ArrayList<Object> acc = accumulator$iv;
            boolean bl2 = false;
            if (acc.isEmpty()) {
                acc.add(range);
            } else if (((LongRange)CollectionsKt.last((List)acc)).getEndInclusive() < range.getStart() - 1L) {
                acc.add(range);
            } else {
                LongRange last2 = (LongRange)CollectionsKt.last((List)acc);
                acc.set(CollectionsKt.getLastIndex((List)acc), new LongRange(last2.getStart(), Math.max(last2.getEndInclusive(), range.getEndInclusive())));
            }
            accumulator$iv = acc;
        }
        ArrayList<Object> sortedMerged = accumulator$iv;
        LongRange[] result2 = new LongRange[$this$mergeRangesKeepOrder.size()];
        block1: for (LongRange longRange : sortedMerged) {
            int n = $this$mergeRangesKeepOrder.size();
            for (int i = 0; i < n; ++i) {
                Intrinsics.checkNotNullExpressionValue(longRange, "range");
                if (!io.ktor.util.RangesKt.contains(longRange, $this$mergeRangesKeepOrder.get(i))) continue;
                result2[i] = longRange;
                continue block1;
            }
        }
        return ArraysKt.filterNotNull(result2);
    }
}

