/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http;

import io.ktor.http.CodecsKt;
import io.ktor.http.Cookie;
import io.ktor.http.CookieEncoding;
import io.ktor.http.CookieKt;
import io.ktor.http.DateUtilsKt;
import io.ktor.util.Base64Kt;
import io.ktor.util.TextKt;
import io.ktor.util.date.GMTDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.sequences.SequencesKt;
import kotlin.text.CharsKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000N\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u001a#\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0082\b\u001a\u001b\u0010\r\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\b\u0010\t\u001a\u0004\u0018\u00010\u0006H\u0082\b\u001a\u0019\u0010\u000e\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u000fH\u0082\b\u001a\u001b\u0010\u0010\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0082\b\u001a\u0016\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f\u001a\u0016\u0010\u0013\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f\u001a$\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00152\u0006\u0010\u0016\u001a\u00020\u00062\b\b\u0002\u0010\u0017\u001a\u00020\u000f\u001a\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u0006\u001a\u000e\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u0019\u001a\u000e\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u0019\u001a\u0084\u0001\u0010\u001c\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00062\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\u001d\u001a\u00020\u001e2\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010 2\n\b\u0002\u0010!\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010#\u001a\u00020\u000f2\b\b\u0002\u0010$\u001a\u00020\u000f2\u0016\b\u0002\u0010%\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00152\b\b\u0002\u0010&\u001a\u00020\u000f\u001a\f\u0010'\u001a\u00020\u0006*\u00020\u0006H\u0002\u001a\f\u0010(\u001a\u00020\u000f*\u00020\u0004H\u0002\u001a\f\u0010)\u001a\u00020\u001e*\u00020\u0006H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"clientCookieHeaderPattern", "Lkotlin/text/Regex;", "cookieCharsShouldBeEscaped", "", "", "loweredPartNames", "", "cookiePart", "name", "value", "", "encoding", "Lio/ktor/http/CookieEncoding;", "cookiePartExt", "cookiePartFlag", "", "cookiePartUnencoded", "decodeCookieValue", "encodedValue", "encodeCookieValue", "parseClientCookiesHeader", "", "cookiesHeader", "skipEscaped", "parseServerSetCookieHeader", "Lio/ktor/http/Cookie;", "renderCookieHeader", "cookie", "renderSetCookieHeader", "maxAge", "", "expires", "Lio/ktor/util/date/GMTDate;", "domain", "path", "secure", "httpOnly", "extensions", "includeEncoding", "assertCookieName", "shouldEscapeInCookies", "toIntClamping", "ktor-http"})
public final class CookieKt {
    @NotNull
    private static final Set<String> loweredPartNames;
    @NotNull
    private static final Regex clientCookieHeaderPattern;
    @NotNull
    private static final Set<Character> cookieCharsShouldBeEscaped;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Cookie parseServerSetCookieHeader(@NotNull String cookiesHeader) {
        Map map2;
        void $this$filterKeys$iv;
        void $this$mapKeysTo$iv$iv;
        Object object;
        Map.Entry first2;
        Map<String, String> it;
        Map<String, String> asMap;
        block7: {
            block6: {
                Object element$iv2;
                block5: {
                    Intrinsics.checkNotNullParameter(cookiesHeader, "cookiesHeader");
                    asMap = CookieKt.parseClientCookiesHeader(cookiesHeader, false);
                    Iterable $this$first$iv = asMap.entrySet();
                    boolean $i$f$first = false;
                    for (Object element$iv2 : $this$first$iv) {
                        it = (Map.Entry)element$iv2;
                        boolean bl = false;
                        if (!(!StringsKt.startsWith$default((String)it.getKey(), "$", false, 2, null))) continue;
                        break block5;
                    }
                    throw new NoSuchElementException("Collection contains no element matching the predicate.");
                }
                first2 = (Map.Entry)element$iv2;
                object = asMap.get("$x-enc");
                if (object == null) break block6;
                it = object;
                boolean bl = false;
                CookieEncoding cookieEncoding = CookieEncoding.valueOf((String)((Object)it));
                object = cookieEncoding;
                if (cookieEncoding != null) break block7;
            }
            object = CookieEncoding.RAW;
        }
        Object encoding = object;
        Map<String, String> $this$mapKeys$iv = asMap;
        boolean $i$f$mapKeys = false;
        it = $this$mapKeys$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity($this$mapKeys$iv.size()));
        boolean $i$f$mapKeysTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            void it2;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            String string2 = TextKt.toLowerCasePreservingASCIIRules((String)it2.getKey());
            Map map4 = map3;
            boolean bl2 = false;
            entry = it$iv$iv.getValue();
            map4.put(string2, entry);
        }
        Map loweredMap = destination$iv$iv;
        String string3 = (String)loweredMap.get("max-age");
        String string4 = (String)loweredMap.get("expires");
        $this$mapKeys$iv = asMap;
        boolean bl = loweredMap.containsKey("httponly");
        boolean bl3 = loweredMap.containsKey("secure");
        String string5 = (String)loweredMap.get("path");
        String string6 = (String)loweredMap.get("domain");
        GMTDate gMTDate = string4 != null ? DateUtilsKt.fromCookieToGmtDate(string4) : null;
        int n = string3 != null ? CookieKt.toIntClamping(string3) : 0;
        Object object2 = encoding;
        String string7 = CookieKt.decodeCookieValue((String)first2.getValue(), (CookieEncoding)((Object)encoding));
        String string8 = (String)first2.getKey();
        boolean $i$f$filterKeys = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterKeys$iv.entrySet()) {
            String it3 = (String)entry$iv.getKey();
            boolean bl4 = false;
            if (!(!loweredPartNames.contains(TextKt.toLowerCasePreservingASCIIRules(it3)) && !Intrinsics.areEqual(it3, first2.getKey()))) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        Map map5 = map2 = (Map)result$iv;
        boolean bl5 = bl;
        boolean bl6 = bl3;
        String string9 = string5;
        String string10 = string6;
        GMTDate gMTDate2 = gMTDate;
        int n2 = n;
        Object object3 = object2;
        String string11 = string7;
        String string12 = string8;
        return new Cookie(string12, string11, (CookieEncoding)((Object)object3), n2, gMTDate2, string10, string9, bl6, bl5, map5);
    }

    @NotNull
    public static final Map<String, String> parseClientCookiesHeader(@NotNull String cookiesHeader, boolean skipEscaped) {
        Intrinsics.checkNotNullParameter(cookiesHeader, "cookiesHeader");
        return MapsKt.toMap(SequencesKt.map(SequencesKt.filter(SequencesKt.map(Regex.findAll$default(clientCookieHeaderPattern, cookiesHeader, 0, 2, null), parseClientCookiesHeader.1.INSTANCE), (Function1)new Function1<Pair<? extends String, ? extends String>, Boolean>(skipEscaped){
            final /* synthetic */ boolean $skipEscaped;
            {
                this.$skipEscaped = $skipEscaped;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Pair<String, String> it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return !this.$skipEscaped || !StringsKt.startsWith$default(it.getFirst(), "$", false, 2, null);
            }
        }), parseClientCookiesHeader.3.INSTANCE));
    }

    public static /* synthetic */ Map parseClientCookiesHeader$default(String string2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return CookieKt.parseClientCookiesHeader(string2, bl);
    }

    @NotNull
    public static final String renderSetCookieHeader(@NotNull Cookie cookie) {
        Intrinsics.checkNotNullParameter(cookie, "cookie");
        Cookie $this$renderSetCookieHeader_u24lambda_u2d4 = cookie;
        boolean bl = false;
        return CookieKt.renderSetCookieHeader$default($this$renderSetCookieHeader_u24lambda_u2d4.getName(), $this$renderSetCookieHeader_u24lambda_u2d4.getValue(), $this$renderSetCookieHeader_u24lambda_u2d4.getEncoding(), $this$renderSetCookieHeader_u24lambda_u2d4.getMaxAgeInt(), $this$renderSetCookieHeader_u24lambda_u2d4.getExpires(), $this$renderSetCookieHeader_u24lambda_u2d4.getDomain(), $this$renderSetCookieHeader_u24lambda_u2d4.getPath(), $this$renderSetCookieHeader_u24lambda_u2d4.getSecure(), $this$renderSetCookieHeader_u24lambda_u2d4.getHttpOnly(), $this$renderSetCookieHeader_u24lambda_u2d4.getExtensions(), false, 1024, null);
    }

    @NotNull
    public static final String renderCookieHeader(@NotNull Cookie cookie) {
        Intrinsics.checkNotNullParameter(cookie, "cookie");
        Cookie $this$renderCookieHeader_u24lambda_u2d5 = cookie;
        boolean bl = false;
        return $this$renderCookieHeader_u24lambda_u2d5.getName() + '=' + CookieKt.encodeCookieValue($this$renderCookieHeader_u24lambda_u2d5.getValue(), $this$renderCookieHeader_u24lambda_u2d5.getEncoding());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String renderSetCookieHeader(@NotNull String name2, @NotNull String value2, @NotNull CookieEncoding encoding, int maxAge2, @Nullable GMTDate expires, @Nullable String domain, @Nullable String path, boolean secure, boolean httpOnly, @NotNull Map<String, String> extensions, boolean includeEncoding) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Object object;
        Iterable name$iv;
        String it;
        void $this$mapTo$iv$iv;
        String $this$map$iv;
        Intrinsics.checkNotNullParameter(name2, "name");
        Intrinsics.checkNotNullParameter(value2, "value");
        Intrinsics.checkNotNullParameter((Object)encoding, "encoding");
        Intrinsics.checkNotNullParameter(extensions, "extensions");
        Object object2 = new String[7];
        String name$iv2 = CookieKt.assertCookieName(name2);
        boolean $i$f$cookiePart = false;
        object2[0] = name$iv2 + '=' + CookieKt.encodeCookieValue(value2.toString(), encoding);
        name$iv2 = "Max-Age";
        Object value$iv = maxAge2 > 0 ? Integer.valueOf(maxAge2) : null;
        boolean $i$f$cookiePartUnencoded = false;
        object2[1] = value$iv != null ? name$iv2 + '=' + value$iv : "";
        name$iv2 = "Expires";
        GMTDate gMTDate = expires;
        value$iv = gMTDate != null ? DateUtilsKt.toHttpDate(gMTDate) : null;
        $i$f$cookiePartUnencoded = false;
        object2[2] = value$iv != null ? name$iv2 + '=' + value$iv : "";
        name$iv2 = "Domain";
        CookieEncoding encoding$iv = CookieEncoding.RAW;
        boolean $i$f$cookiePart2 = false;
        object2[3] = domain != null ? name$iv2 + '=' + CookieKt.encodeCookieValue(domain.toString(), encoding$iv) : "";
        name$iv2 = "Path";
        encoding$iv = CookieEncoding.RAW;
        $i$f$cookiePart2 = false;
        object2[4] = path != null ? name$iv2 + '=' + CookieKt.encodeCookieValue(path.toString(), encoding$iv) : "";
        name$iv2 = "Secure";
        boolean $i$f$cookiePartFlag = false;
        object2[5] = secure ? name$iv2 : "";
        name$iv2 = "HttpOnly";
        $i$f$cookiePartFlag = false;
        object2[6] = httpOnly ? name$iv2 : "";
        Collection collection = CollectionsKt.listOf(object2);
        object2 = extensions;
        Collection collection2 = collection;
        boolean $i$f$map = false;
        void $i$f$cookiePartFlag2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            String string2;
            void name$iv3;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator2.next();
            Collection collection3 = destination$iv$iv;
            boolean bl = false;
            String string3 = CookieKt.assertCookieName((String)it.getKey());
            String value$iv2 = (String)it.getValue();
            boolean $i$f$cookiePartExt = false;
            if (value$iv2 == null) {
                boolean value$iv$iv = true;
                boolean $i$f$cookiePartFlag3 = false;
                string2 = name$iv3;
            } else {
                CookieEncoding encoding$iv$iv = CookieEncoding.RAW;
                boolean $i$f$cookiePart3 = false;
                string2 = (String)name$iv3 + '=' + CookieKt.encodeCookieValue(value$iv2.toString(), encoding$iv$iv);
            }
            collection3.add(string2);
        }
        Collection collection4 = CollectionsKt.plus(collection2, (Iterable)((List)destination$iv$iv));
        if (includeEncoding) {
            $this$map$iv = "$x-enc";
            String value$iv3 = encoding.name();
            boolean $i$f$cookiePartExt = false;
            if (value$iv3 == null) {
                boolean value$iv$iv = true;
                boolean $i$f$cookiePartFlag4 = false;
                object = name$iv;
            } else {
                CookieEncoding encoding$iv$iv = CookieEncoding.RAW;
                boolean $i$f$cookiePart4 = false;
                object = (String)((Object)name$iv) + '=' + CookieKt.encodeCookieValue(value$iv3.toString(), encoding$iv$iv);
            }
        } else {
            object = "";
        }
        name$iv = CollectionsKt.plus(collection4, object);
        boolean $i$f$filter = false;
        void $i$f$cookiePartExt = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Map.Entry element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)((Object)element$iv$iv);
            boolean bl = false;
            boolean bl2 = ((CharSequence)it).length() > 0;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.joinToString$default((List)destination$iv$iv, "; ", null, null, 0, null, null, 62, null);
    }

    public static /* synthetic */ String renderSetCookieHeader$default(String string2, String string3, CookieEncoding cookieEncoding, int n, GMTDate gMTDate, String string4, String string5, boolean bl, boolean bl2, Map map2, boolean bl3, int n2, Object object) {
        if ((n2 & 4) != 0) {
            cookieEncoding = CookieEncoding.URI_ENCODING;
        }
        if ((n2 & 8) != 0) {
            n = 0;
        }
        if ((n2 & 0x10) != 0) {
            gMTDate = null;
        }
        if ((n2 & 0x20) != 0) {
            string4 = null;
        }
        if ((n2 & 0x40) != 0) {
            string5 = null;
        }
        if ((n2 & 0x80) != 0) {
            bl = false;
        }
        if ((n2 & 0x100) != 0) {
            bl2 = false;
        }
        if ((n2 & 0x200) != 0) {
            map2 = MapsKt.emptyMap();
        }
        if ((n2 & 0x400) != 0) {
            bl3 = true;
        }
        return CookieKt.renderSetCookieHeader(string2, string3, cookieEncoding, n, gMTDate, string4, string5, bl, bl2, map2, bl3);
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public static final String encodeCookieValue(@NotNull String value, @NotNull CookieEncoding encoding) {
        Intrinsics.checkNotNullParameter(value, "value");
        Intrinsics.checkNotNullParameter((Object)encoding, "encoding");
        switch (WhenMappings.$EnumSwitchMapping$0[encoding.ordinal()]) {
            case 1: {
                $this$any$iv = value;
                $i$f$any = false;
                for (var4_6 = 0; var4_6 < $this$any$iv.length(); ++var4_6) {
                    it = element$iv = $this$any$iv.charAt(var4_6);
                    $i$a$-any-CookieKt$encodeCookieValue$1 = false;
                    if (!CookieKt.shouldEscapeInCookies(it)) continue;
                    v0 = true;
                    ** GOTO lbl15
                }
                v0 = false;
lbl15:
                // 2 sources

                if (v0) {
                    throw new IllegalArgumentException("The cookie value contains characters that cannot be encoded in RAW format.  Consider URL_ENCODING mode");
                }
                v1 = value;
                break;
            }
            case 2: {
                if (StringsKt.contains$default((CharSequence)value, '\"', false, 2, null)) {
                    throw new IllegalArgumentException("The cookie value contains characters that cannot be encoded in DQUOTES format. Consider URL_ENCODING mode");
                }
                $this$any$iv = value;
                $i$f$any = false;
                for (var4_7 = 0; var4_7 < $this$any$iv.length(); ++var4_7) {
                    it = element$iv = $this$any$iv.charAt(var4_7);
                    $i$a$-any-CookieKt$encodeCookieValue$2 = false;
                    if (!CookieKt.shouldEscapeInCookies(it)) continue;
                    v2 = true;
                    ** GOTO lbl32
                }
                v2 = false;
lbl32:
                // 2 sources

                if (v2) {
                    v1 = '\"' + value + '\"';
                    break;
                }
                v1 = value;
                break;
            }
            case 3: {
                v1 = Base64Kt.encodeBase64(value);
                break;
            }
            case 4: {
                v1 = CodecsKt.encodeURLQueryComponent$default(value, false, true, null, 4, null);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return v1;
    }

    @NotNull
    public static final String decodeCookieValue(@NotNull String encodedValue, @NotNull CookieEncoding encoding) {
        String string2;
        Intrinsics.checkNotNullParameter(encodedValue, "encodedValue");
        Intrinsics.checkNotNullParameter((Object)encoding, "encoding");
        switch (WhenMappings.$EnumSwitchMapping$0[encoding.ordinal()]) {
            case 1: 
            case 2: {
                if (StringsKt.startsWith$default(((Object)StringsKt.trimStart((CharSequence)encodedValue)).toString(), "\"", false, 2, null) && StringsKt.endsWith$default(((Object)StringsKt.trimEnd((CharSequence)encodedValue)).toString(), "\"", false, 2, null)) {
                    string2 = StringsKt.removeSurrounding(((Object)StringsKt.trim((CharSequence)encodedValue)).toString(), (CharSequence)"\"");
                    break;
                }
                string2 = encodedValue;
                break;
            }
            case 4: {
                string2 = CodecsKt.decodeURLQueryComponent$default(encodedValue, 0, 0, true, null, 11, null);
                break;
            }
            case 3: {
                string2 = Base64Kt.decodeBase64String(encodedValue);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string2;
    }

    private static final String assertCookieName(String $this$assertCookieName) {
        boolean bl;
        block2: {
            CharSequence $this$any$iv = $this$assertCookieName;
            boolean $i$f$any = false;
            for (int i = 0; i < $this$any$iv.length(); ++i) {
                char element$iv;
                char it = element$iv = $this$any$iv.charAt(i);
                boolean bl2 = false;
                if (!CookieKt.shouldEscapeInCookies(it)) continue;
                bl = true;
                break block2;
            }
            bl = false;
        }
        if (bl) {
            throw new IllegalArgumentException("Cookie name is not valid: " + $this$assertCookieName);
        }
        return $this$assertCookieName;
    }

    private static final boolean shouldEscapeInCookies(char $this$shouldEscapeInCookies) {
        return CharsKt.isWhitespace($this$shouldEscapeInCookies) || Intrinsics.compare($this$shouldEscapeInCookies, 32) < 0 || cookieCharsShouldBeEscaped.contains(Character.valueOf($this$shouldEscapeInCookies));
    }

    private static final String cookiePart(String name2, Object value2, CookieEncoding encoding) {
        boolean $i$f$cookiePart = false;
        return value2 != null ? name2 + '=' + CookieKt.encodeCookieValue(value2.toString(), encoding) : "";
    }

    private static final String cookiePartUnencoded(String name2, Object value2) {
        boolean $i$f$cookiePartUnencoded = false;
        return value2 != null ? name2 + '=' + value2 : "";
    }

    private static final String cookiePartFlag(String name2, boolean value2) {
        boolean $i$f$cookiePartFlag = false;
        return value2 ? name2 : "";
    }

    private static final String cookiePartExt(String name2, String value2) {
        String string2;
        boolean $i$f$cookiePartExt = false;
        if (value2 == null) {
            boolean value$iv = true;
            boolean $i$f$cookiePartFlag = false;
            string2 = name2;
        } else {
            CookieEncoding encoding$iv = CookieEncoding.RAW;
            boolean $i$f$cookiePart = false;
            string2 = name2 + '=' + CookieKt.encodeCookieValue(value2.toString(), encoding$iv);
        }
        return string2;
    }

    private static final int toIntClamping(String $this$toIntClamping) {
        return (int)RangesKt.coerceIn(Long.parseLong($this$toIntClamping), 0L, Integer.MAX_VALUE);
    }

    static {
        Object[] objectArray = new String[]{"max-age", "expires", "domain", "path", "secure", "httponly", "$x-enc"};
        loweredPartNames = SetsKt.setOf(objectArray);
        clientCookieHeaderPattern = new Regex("(^|;)\\s*([^;=\\{\\}\\s]+)\\s*(=\\s*(\"[^\"]*\"|[^;]*))?");
        objectArray = new Character[]{Character.valueOf(';'), Character.valueOf(','), Character.valueOf('\"')};
        cookieCharsShouldBeEscaped = SetsKt.setOf(objectArray);
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CookieEncoding.values().length];
            nArray[CookieEncoding.RAW.ordinal()] = 1;
            nArray[CookieEncoding.DQUOTES.ordinal()] = 2;
            nArray[CookieEncoding.BASE64_ENCODING.ordinal()] = 3;
            nArray[CookieEncoding.URI_ENCODING.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

