/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.client.request;

import io.ktor.client.request.HttpRequestBuilder;
import io.ktor.http.ContentType;
import io.ktor.http.Cookie;
import io.ktor.http.CookieKt;
import io.ktor.http.HttpHeaders;
import io.ktor.http.HttpMessageBuilder;
import io.ktor.util.Base64Kt;
import io.ktor.util.date.GMTDate;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\u001a\u0012\u0010\u000e\u001a\u00020\u000f*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u001a\u0010\u0013\u001a\u00020\u000f*\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u0001\u001a\u0012\u0010\u0016\u001a\u00020\u000f*\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0001\u001at\u0010\u0018\u001a\u00020\u000f*\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u00012\u0006\u0010\u0000\u001a\u00020\u00012\b\b\u0002\u0010\u001a\u001a\u00020\b2\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u00012\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u00012\b\b\u0002\u0010\u001f\u001a\u00020 2\b\b\u0002\u0010!\u001a\u00020 2\u0016\b\u0002\u0010\"\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u00010#\u001a\u001c\u0010$\u001a\u00020\u000f*\u00020\u00102\u0006\u0010%\u001a\u00020\u00012\b\u0010\u0000\u001a\u0004\u0018\u00010&\u001a\u001c\u0010'\u001a\u00020\u000f*\u00020\u00032\u0006\u0010%\u001a\u00020\u00012\b\u0010\u0000\u001a\u0004\u0018\u00010&\"(\u0010\u0002\u001a\u00020\u0001*\u00020\u00032\u0006\u0010\u0000\u001a\u00020\u00018F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0004\u0010\u0005\"\u0004\b\u0006\u0010\u0007\"(\u0010\t\u001a\u00020\b*\u00020\u00032\u0006\u0010\u0000\u001a\u00020\b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006("}, d2={"value", "", "host", "Lio/ktor/client/request/HttpRequestBuilder;", "getHost", "(Lio/ktor/client/request/HttpRequestBuilder;)Ljava/lang/String;", "setHost", "(Lio/ktor/client/request/HttpRequestBuilder;Ljava/lang/String;)V", "", "port", "getPort", "(Lio/ktor/client/request/HttpRequestBuilder;)I", "setPort", "(Lio/ktor/client/request/HttpRequestBuilder;I)V", "accept", "", "Lio/ktor/http/HttpMessageBuilder;", "contentType", "Lio/ktor/http/ContentType;", "basicAuth", "username", "password", "bearerAuth", "token", "cookie", "name", "maxAge", "expires", "Lio/ktor/util/date/GMTDate;", "domain", "path", "secure", "", "httpOnly", "extensions", "", "header", "key", "", "parameter", "ktor-client-core"})
public final class UtilsKt {
    @NotNull
    public static final String getHost(@NotNull HttpRequestBuilder $this$host) {
        Intrinsics.checkNotNullParameter($this$host, "<this>");
        return $this$host.getUrl().getHost();
    }

    public static final void setHost(@NotNull HttpRequestBuilder $this$host, @NotNull String value2) {
        Intrinsics.checkNotNullParameter($this$host, "<this>");
        Intrinsics.checkNotNullParameter(value2, "value");
        $this$host.getUrl().setHost(value2);
    }

    public static final int getPort(@NotNull HttpRequestBuilder $this$port) {
        Intrinsics.checkNotNullParameter($this$port, "<this>");
        return $this$port.getUrl().getPort();
    }

    public static final void setPort(@NotNull HttpRequestBuilder $this$port, int value2) {
        Intrinsics.checkNotNullParameter($this$port, "<this>");
        $this$port.getUrl().setPort(value2);
    }

    public static final void header(@NotNull HttpMessageBuilder $this$header, @NotNull String key, @Nullable Object value2) {
        Unit unit;
        Intrinsics.checkNotNullParameter($this$header, "<this>");
        Intrinsics.checkNotNullParameter(key, "key");
        Object object = value2;
        if (object != null) {
            Object it = object;
            boolean bl = false;
            $this$header.getHeaders().append(key, it.toString());
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit == null) {
            // empty if block
        }
    }

    public static final void cookie(@NotNull HttpMessageBuilder $this$cookie, @NotNull String name2, @NotNull String value2, int maxAge2, @Nullable GMTDate expires, @Nullable String domain, @Nullable String path, boolean secure, boolean httpOnly, @NotNull Map<String, String> extensions) {
        Intrinsics.checkNotNullParameter($this$cookie, "<this>");
        Intrinsics.checkNotNullParameter(name2, "name");
        Intrinsics.checkNotNullParameter(value2, "value");
        Intrinsics.checkNotNullParameter(extensions, "extensions");
        Cookie p0 = new Cookie(name2, value2, null, maxAge2, expires, domain, path, secure, httpOnly, extensions, 4, null);
        boolean bl = false;
        String renderedCookie = CookieKt.renderCookieHeader(p0);
        if (!$this$cookie.getHeaders().contains(HttpHeaders.INSTANCE.getCookie())) {
            $this$cookie.getHeaders().append(HttpHeaders.INSTANCE.getCookie(), renderedCookie);
            return;
        }
        $this$cookie.getHeaders().set(HttpHeaders.INSTANCE.getCookie(), $this$cookie.getHeaders().get(HttpHeaders.INSTANCE.getCookie()) + "; " + renderedCookie);
    }

    public static /* synthetic */ void cookie$default(HttpMessageBuilder httpMessageBuilder, String string2, String string3, int n, GMTDate gMTDate, String string4, String string5, boolean bl, boolean bl2, Map map2, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 0;
        }
        if ((n2 & 8) != 0) {
            gMTDate = null;
        }
        if ((n2 & 0x10) != 0) {
            string4 = null;
        }
        if ((n2 & 0x20) != 0) {
            string5 = null;
        }
        if ((n2 & 0x40) != 0) {
            bl = false;
        }
        if ((n2 & 0x80) != 0) {
            bl2 = false;
        }
        if ((n2 & 0x100) != 0) {
            map2 = MapsKt.emptyMap();
        }
        UtilsKt.cookie(httpMessageBuilder, string2, string3, n, gMTDate, string4, string5, bl, bl2, map2);
    }

    public static final void parameter(@NotNull HttpRequestBuilder $this$parameter, @NotNull String key, @Nullable Object value2) {
        Unit unit;
        Intrinsics.checkNotNullParameter($this$parameter, "<this>");
        Intrinsics.checkNotNullParameter(key, "key");
        Object object = value2;
        if (object != null) {
            Object it = object;
            boolean bl = false;
            $this$parameter.getUrl().getParameters().append(key, it.toString());
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit == null) {
            // empty if block
        }
    }

    public static final void accept(@NotNull HttpMessageBuilder $this$accept, @NotNull ContentType contentType2) {
        Intrinsics.checkNotNullParameter($this$accept, "<this>");
        Intrinsics.checkNotNullParameter(contentType2, "contentType");
        $this$accept.getHeaders().append(HttpHeaders.INSTANCE.getAccept(), contentType2.toString());
    }

    public static final void basicAuth(@NotNull HttpMessageBuilder $this$basicAuth, @NotNull String username2, @NotNull String password) {
        Intrinsics.checkNotNullParameter($this$basicAuth, "<this>");
        Intrinsics.checkNotNullParameter(username2, "username");
        Intrinsics.checkNotNullParameter(password, "password");
        UtilsKt.header($this$basicAuth, HttpHeaders.INSTANCE.getAuthorization(), "Basic " + Base64Kt.encodeBase64(username2 + ':' + password));
    }

    public static final void bearerAuth(@NotNull HttpMessageBuilder $this$bearerAuth, @NotNull String token2) {
        Intrinsics.checkNotNullParameter($this$bearerAuth, "<this>");
        Intrinsics.checkNotNullParameter(token2, "token");
        UtilsKt.header($this$bearerAuth, HttpHeaders.INSTANCE.getAuthorization(), "Bearer " + token2);
    }
}

