/*
 * Decompiled with CFR 0.152.
 */
package dev.kord.rest.request;

import dev.kord.rest.ratelimit.BucketKey;
import dev.kord.rest.ratelimit.ExclusionRequestRateLimiter;
import dev.kord.rest.ratelimit.RateLimit;
import dev.kord.rest.ratelimit.Remaining;
import dev.kord.rest.ratelimit.RequestRateLimiter;
import dev.kord.rest.ratelimit.RequestResponse;
import dev.kord.rest.ratelimit.Reset;
import dev.kord.rest.ratelimit.Total;
import dev.kord.rest.request.HttpUtilsKt;
import dev.kord.rest.request.KtorRequestHandler;
import dev.kord.rest.request.KtorRequestHandlerKt;
import io.ktor.client.HttpClient;
import io.ktor.client.HttpClientKt;
import io.ktor.client.engine.cio.CIO;
import io.ktor.client.statement.HttpResponse;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.datetime.Clock;
import kotlinx.datetime.Instant;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a,\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\u0001\u001a\u001a\u0010\r\u001a\u00020\u000e*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000b\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0012"}, d2={"jsonDefault", "Lkotlinx/serialization/json/Json;", "getJsonDefault", "()Lkotlinx/serialization/json/Json;", "KtorRequestHandler", "Ldev/kord/rest/request/KtorRequestHandler;", "token", "", "requestRateLimiter", "Ldev/kord/rest/ratelimit/RequestRateLimiter;", "clock", "Lkotlinx/datetime/Clock;", "parser", "from", "Ldev/kord/rest/ratelimit/RequestResponse;", "Ldev/kord/rest/ratelimit/RequestResponse$Companion;", "response", "Lio/ktor/client/statement/HttpResponse;", "rest"})
public final class KtorRequestHandlerKt {
    @NotNull
    private static final Json jsonDefault = JsonKt.Json$default(null, jsonDefault.1.INSTANCE, 1, null);

    @NotNull
    public static final Json getJsonDefault() {
        return jsonDefault;
    }

    @NotNull
    public static final KtorRequestHandler KtorRequestHandler(@NotNull String token2, @NotNull RequestRateLimiter requestRateLimiter, @NotNull Clock clock, @NotNull Json parser) {
        Intrinsics.checkNotNullParameter(token2, "token");
        Intrinsics.checkNotNullParameter(requestRateLimiter, "requestRateLimiter");
        Intrinsics.checkNotNullParameter(clock, "clock");
        Intrinsics.checkNotNullParameter(parser, "parser");
        HttpClient client2 = HttpClientKt.HttpClient(CIO.INSTANCE, KtorRequestHandler.client.1.INSTANCE);
        return new KtorRequestHandler(client2, requestRateLimiter, clock, parser, token2);
    }

    public static /* synthetic */ KtorRequestHandler KtorRequestHandler$default(String string2, RequestRateLimiter requestRateLimiter, Clock clock, Json json2, int n, Object object) {
        if ((n & 2) != 0) {
            requestRateLimiter = new ExclusionRequestRateLimiter(null, 1, null);
        }
        if ((n & 4) != 0) {
            clock = Clock.System.INSTANCE;
        }
        if ((n & 8) != 0) {
            json2 = jsonDefault;
        }
        return KtorRequestHandlerKt.KtorRequestHandler(string2, requestRateLimiter, clock, json2);
    }

    @NotNull
    public static final RequestResponse from(@NotNull RequestResponse.Companion $this$from, @NotNull HttpResponse response2, @NotNull Clock clock) {
        RequestResponse requestResponse;
        RateLimit rateLimit;
        Intrinsics.checkNotNullParameter($this$from, "<this>");
        Intrinsics.checkNotNullParameter(response2, "response");
        Intrinsics.checkNotNullParameter(clock, "clock");
        String bucket = HttpUtilsKt.getBucket(response2);
        RequestResponse.Companion $this$from_u24lambda_u240 = $this$from;
        boolean bl = false;
        Long l = HttpUtilsKt.getRateLimitTotal(response2);
        if (l == null) {
            rateLimit = null;
        } else {
            long total = Total.constructor-impl(l);
            Long l2 = HttpUtilsKt.getRateLimitRemaining(response2);
            if (l2 == null) {
                rateLimit = null;
            } else {
                long remaining = Remaining.constructor-impl(l2);
                rateLimit = new RateLimit(total, remaining, null);
            }
        }
        RateLimit rateLimit2 = rateLimit;
        Instant reset = Reset.constructor-impl(HttpUtilsKt.channelResetPoint(response2, clock));
        if (HttpUtilsKt.isGlobalRateLimit(response2)) {
            requestResponse = new RequestResponse.GlobalRateLimit(bucket, rateLimit2, reset, null);
        } else if (HttpUtilsKt.isRateLimit(response2)) {
            String string2 = bucket;
            if (string2 == null) {
                string2 = BucketKey.constructor-impl("missing");
            }
            requestResponse = new RequestResponse.BucketRateLimit(string2, rateLimit2, reset, null);
        } else {
            requestResponse = HttpUtilsKt.isError(response2) ? (RequestResponse)RequestResponse.Error.INSTANCE : (RequestResponse)new RequestResponse.Accepted(bucket, rateLimit2, reset, null);
        }
        return requestResponse;
    }
}

