/*
 * Decompiled with CFR 0.152.
 */
package dev.kord.rest.request;

import dev.kord.rest.ratelimit.BucketKey;
import dev.kord.rest.request.HttpUtilsKt;
import dev.kord.rest.request.Request;
import dev.kord.rest.request.RequestBuilder;
import io.ktor.client.statement.HttpResponse;
import io.ktor.client.statement.ReadersKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.datetime.Clock;
import kotlinx.datetime.Instant;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000L\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a \u0010\u0000\u001a\u00020\u001f\"\u0004\b\u0000\u0010 *\b\u0012\u0004\u0012\u0002H 0!2\b\u0010\"\u001a\u0004\u0018\u00010\u0001\u001a\u0012\u0010\u000e\u001a\u00020\u000f*\u00020\u000b2\u0006\u0010#\u001a\u00020$\u001a\u0015\u0010%\u001a\u00020\u0001*\u00020\u000bH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010&\u001a\u0012\u0010'\u001a\u00020\u001a*\u00020\u000b2\u0006\u0010#\u001a\u00020$\u001a\u001a\u0010(\u001a\u00020\u0001*\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030)2\u0006\u0010*\u001a\u00020\u0001\u001a\u0012\u0010(\u001a\u00020\u0001*\u00020\u000b2\u0006\u0010*\u001a\u00020\u0001\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\t\u001a\u0004\u0018\u00010\n*\u00020\u000b8F\u00f8\u0001\u0000\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\"\u0015\u0010\u000e\u001a\u00020\u000f*\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\"\u0015\u0010\u0012\u001a\u00020\u0013*\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0014\"\u0015\u0010\u0015\u001a\u00020\u0013*\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0014\"\u0015\u0010\u0016\u001a\u00020\u0013*\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0014\"\u0015\u0010\u0017\u001a\u00020\u0013*\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0014\"\u0015\u0010\u0018\u001a\u00020\u0013*\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0014\"\u0017\u0010\u0019\u001a\u0004\u0018\u00010\u001a*\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\"\u0017\u0010\u001d\u001a\u0004\u0018\u00010\u001a*\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001c\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006+"}, d2={"auditLogReason", "", "bucketRateLimitKey", "rateLimit", "rateLimitGlobalHeader", "rateLimitRemainingHeader", "rateLimitResetAfter", "resetTimeHeader", "retryAfterHeader", "bucket", "Ldev/kord/rest/ratelimit/BucketKey;", "Lio/ktor/client/statement/HttpResponse;", "getBucket", "(Lio/ktor/client/statement/HttpResponse;)Ljava/lang/String;", "channelResetPoint", "Lkotlinx/datetime/Instant;", "getChannelResetPoint", "(Lio/ktor/client/statement/HttpResponse;)Lkotlinx/datetime/Instant;", "isChannelRateLimit", "", "(Lio/ktor/client/statement/HttpResponse;)Z", "isError", "isErrorWithRateLimit", "isGlobalRateLimit", "isRateLimit", "rateLimitRemaining", "", "getRateLimitRemaining", "(Lio/ktor/client/statement/HttpResponse;)Ljava/lang/Long;", "rateLimitTotal", "getRateLimitTotal", "", "T", "Ldev/kord/rest/request/RequestBuilder;", "reason", "clock", "Lkotlinx/datetime/Clock;", "errorString", "(Lio/ktor/client/statement/HttpResponse;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "globalSuspensionPoint", "logString", "Ldev/kord/rest/request/Request;", "body", "rest"})
public final class HttpUtilsKt {
    @NotNull
    private static final String rateLimitGlobalHeader = "X-RateLimit-Global";
    @NotNull
    private static final String retryAfterHeader = "Retry-After";
    @NotNull
    private static final String rateLimitRemainingHeader = "X-RateLimit-Remaining";
    @NotNull
    private static final String resetTimeHeader = "X-RateLimit-Reset";
    @NotNull
    private static final String bucketRateLimitKey = "X-RateLimit-Bucket";
    @NotNull
    private static final String rateLimit = "X-RateLimit-Limit";
    @NotNull
    private static final String rateLimitResetAfter = "X-RateLimit-Reset-After";
    @NotNull
    private static final String auditLogReason = "X-Audit-Log-Reason";

    public static final <T> void auditLogReason(@NotNull RequestBuilder<T> $this$auditLogReason, @Nullable String reason2) {
        block0: {
            Intrinsics.checkNotNullParameter($this$auditLogReason, "<this>");
            String string2 = reason2;
            if (string2 == null) break block0;
            String it = string2;
            boolean bl = false;
            $this$auditLogReason.urlEncodedHeader(auditLogReason, reason2);
        }
    }

    @NotNull
    public static final Instant getChannelResetPoint(@NotNull HttpResponse $this$channelResetPoint) {
        Intrinsics.checkNotNullParameter($this$channelResetPoint, "<this>");
        String string2 = $this$channelResetPoint.getHeaders().get(resetTimeHeader);
        if (string2 == null) {
            return Clock.System.INSTANCE.now();
        }
        double unixSeconds = Double.parseDouble(string2);
        return Instant.Companion.fromEpochMilliseconds((long)(unixSeconds * (double)1000));
    }

    @NotNull
    public static final Instant channelResetPoint(@NotNull HttpResponse $this$channelResetPoint, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter($this$channelResetPoint, "<this>");
        Intrinsics.checkNotNullParameter(clock, "clock");
        String string2 = $this$channelResetPoint.getHeaders().get(rateLimitResetAfter);
        if (string2 == null) {
            return clock.now();
        }
        double seconds = Double.parseDouble(string2);
        return clock.now().plus-LRDsOJo(DurationKt.toDuration(seconds, DurationUnit.SECONDS));
    }

    public static final boolean isRateLimit(@NotNull HttpResponse $this$isRateLimit) {
        Intrinsics.checkNotNullParameter($this$isRateLimit, "<this>");
        return $this$isRateLimit.getStatus().getValue() == 429;
    }

    public static final boolean isError(@NotNull HttpResponse $this$isError) {
        Intrinsics.checkNotNullParameter($this$isError, "<this>");
        int n = $this$isError.getStatus().getValue();
        return 400 <= n ? n < 600 : false;
    }

    public static final boolean isErrorWithRateLimit(@NotNull HttpResponse $this$isErrorWithRateLimit) {
        Intrinsics.checkNotNullParameter($this$isErrorWithRateLimit, "<this>");
        return $this$isErrorWithRateLimit.getStatus().getValue() == 403 || $this$isErrorWithRateLimit.getStatus().getValue() == 401;
    }

    public static final boolean isGlobalRateLimit(@NotNull HttpResponse $this$isGlobalRateLimit) {
        Intrinsics.checkNotNullParameter($this$isGlobalRateLimit, "<this>");
        return $this$isGlobalRateLimit.getHeaders().get(rateLimitGlobalHeader) != null;
    }

    @Nullable
    public static final Long getRateLimitTotal(@NotNull HttpResponse $this$rateLimitTotal) {
        Intrinsics.checkNotNullParameter($this$rateLimitTotal, "<this>");
        String string2 = $this$rateLimitTotal.getHeaders().get(rateLimit);
        return string2 != null ? StringsKt.toLongOrNull(string2) : null;
    }

    @Nullable
    public static final Long getRateLimitRemaining(@NotNull HttpResponse $this$rateLimitRemaining) {
        Intrinsics.checkNotNullParameter($this$rateLimitRemaining, "<this>");
        String string2 = $this$rateLimitRemaining.getHeaders().get(rateLimitRemainingHeader);
        return string2 != null ? StringsKt.toLongOrNull(string2) : null;
    }

    public static final boolean isChannelRateLimit(@NotNull HttpResponse $this$isChannelRateLimit) {
        boolean bl;
        Intrinsics.checkNotNullParameter($this$isChannelRateLimit, "<this>");
        String string2 = $this$isChannelRateLimit.getHeaders().get(rateLimitRemainingHeader);
        if (string2 != null) {
            Integer n = StringsKt.toIntOrNull(string2);
            bl = n != null && n == 0;
        } else {
            bl = false;
        }
        return bl;
    }

    @Nullable
    public static final String getBucket(@NotNull HttpResponse $this$bucket) {
        String string2;
        Intrinsics.checkNotNullParameter($this$bucket, "<this>");
        String string3 = $this$bucket.getHeaders().get(bucketRateLimitKey);
        if (string3 != null) {
            String it = string3;
            boolean bl = false;
            string2 = BucketKey.constructor-impl(it);
        } else {
            string2 = null;
        }
        return string2;
    }

    public static final long globalSuspensionPoint(@NotNull HttpResponse $this$globalSuspensionPoint, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter($this$globalSuspensionPoint, "<this>");
        Intrinsics.checkNotNullParameter(clock, "clock");
        String string2 = $this$globalSuspensionPoint.getHeaders().get(retryAfterHeader);
        if (string2 == null) {
            return clock.now().toEpochMilliseconds();
        }
        long secondsWait = Long.parseLong(string2);
        return secondsWait * (long)1000 + clock.now().toEpochMilliseconds();
    }

    @NotNull
    public static final String logString(@NotNull HttpResponse $this$logString, @NotNull String body2) {
        Intrinsics.checkNotNullParameter($this$logString, "<this>");
        Intrinsics.checkNotNullParameter(body2, "body");
        return "[RESPONSE]:" + $this$logString.getStatus().getValue() + ':' + $this$logString.getCall().getRequest().getMethod().getValue() + ':' + $this$logString.getCall().getRequest().getUrl() + " body:" + body2;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public static final Object errorString(@NotNull HttpResponse var0, @NotNull Continuation<? super String> var1_1) {
        if (!(var1_1 instanceof errorString.1)) ** GOTO lbl-1000
        var5_2 = var1_1;
        if ((var5_2.label & -2147483648) != 0) {
            var5_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl((Continuation<? super errorString.1>)var1_1){
                Object L$0;
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return HttpUtilsKt.errorString(null, this);
                }
            };
        }
        $result = $continuation.result;
        var6_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure($result);
                $continuation.L$0 = $this$errorString;
                $continuation.label = 1;
                v0 = ReadersKt.readBytes($this$errorString, $continuation);
                if (v0 == var6_4) {
                    return var6_4;
                }
                ** GOTO lbl22
            }
            case 1: {
                $this$errorString = (HttpResponse)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v0 = $result;
lbl22:
                // 2 sources

                var3_5 = (byte[])v0;
                message = new String(var3_5, Charsets.UTF_8);
                return HttpUtilsKt.logString($this$errorString, message);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @NotNull
    public static final String logString(@NotNull Request<?, ?> $this$logString, @NotNull String body2) {
        Intrinsics.checkNotNullParameter($this$logString, "<this>");
        Intrinsics.checkNotNullParameter(body2, "body");
        String method = $this$logString.getRoute().getMethod().getValue();
        String path = $this$logString.getRoute().getPath();
        String params2 = CollectionsKt.joinToString$default($this$logString.getRouteParams().entrySet(), ",", "[", "]", 0, null, logString.params.1.INSTANCE, 24, null);
        return "[REQUEST]:" + method + ':' + path + " params:" + params2 + " body:" + body2;
    }
}

