/*
 * Decompiled with CFR 0.152.
 */
package dev.kord.gateway.retry;

import dev.kord.gateway.retry.LinearRetryKt;
import dev.kord.gateway.retry.Retry;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.time.Duration;
import kotlinx.coroutines.DelayKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\u0018\u00002\u00020\u0014B\"\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u0013\u0010\u000b\u001a\u00020\bH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u000b\u0010\fR\u001d\u0010\u0002\u001a\u00020\u00018\u0002X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0006\n\u0004\b\u0002\u0010\rR\u0014\u0010\u0011\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u001d\u0010\u0003\u001a\u00020\u00018\u0002X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\rR\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0012\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u0013"}, d2={"Ldev/kord/gateway/retry/LinearRetry;", "Lkotlin/time/Duration;", "firstBackoff", "maxBackoff", "", "maxTries", "<init>", "(JJILkotlin/jvm/internal/DefaultConstructorMarker;)V", "", "reset", "()V", "retry", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "J", "", "getHasNext", "()Z", "hasNext", "I", "gateway", "Ldev/kord/gateway/retry/Retry;"})
public final class LinearRetry
implements Retry {
    private final long firstBackoff;
    private final long maxBackoff;
    private final int maxTries;
    @NotNull
    volatile /* synthetic */ int tries;
    static final /* synthetic */ AtomicIntegerFieldUpdater tries$FU;

    private LinearRetry(long firstBackoff, long maxBackoff, int maxTries) {
        this.firstBackoff = firstBackoff;
        this.maxBackoff = maxBackoff;
        this.maxTries = maxTries;
        if (!Duration.isPositive-impl(this.firstBackoff)) {
            boolean $i$a$-require-LinearRetry$52 = false;
            String $i$a$-require-LinearRetry$52 = "firstBackoff needs to be positive but was " + Duration.getInWholeMilliseconds-impl(this.firstBackoff) + " ms";
            throw new IllegalArgumentException($i$a$-require-LinearRetry$52.toString());
        }
        if (!Duration.isPositive-impl(this.maxBackoff)) {
            boolean $i$a$-require-LinearRetry$62 = false;
            String $i$a$-require-LinearRetry$62 = "maxBackoff needs to be positive but was " + Duration.getInWholeMilliseconds-impl(this.maxBackoff) + " ms";
            throw new IllegalArgumentException($i$a$-require-LinearRetry$62.toString());
        }
        if (!Duration.isPositive-impl(Duration.minus-LRDsOJo(this.maxBackoff, this.firstBackoff))) {
            boolean $i$a$-require-LinearRetry$72 = false;
            String $i$a$-require-LinearRetry$72 = "maxBackoff " + Duration.getInWholeMilliseconds-impl(this.maxBackoff) + " ms needs to be bigger than firstBackoff " + Duration.getInWholeMilliseconds-impl(this.firstBackoff) + " ms";
            throw new IllegalArgumentException($i$a$-require-LinearRetry$72.toString());
        }
        if (!(this.maxTries > 1)) {
            boolean bl = false;
            String string2 = "maxTries needs to be greater than 1 but was " + this.maxTries;
            throw new IllegalArgumentException(string2.toString());
        }
        this.tries = 0;
    }

    @Override
    public boolean getHasNext() {
        return this.tries < this.maxTries;
    }

    @Override
    public void reset() {
        int upd$iv;
        int cur$iv;
        LinearRetry $this$update$iv = this;
        boolean $i$f$update = false;
        do {
            int it = cur$iv = $this$update$iv.tries;
            boolean bl = false;
        } while (!tries$FU.compareAndSet($this$update$iv, cur$iv, upd$iv = 0));
    }

    @Override
    @Nullable
    public Object retry(@NotNull Continuation<? super Unit> $completion) {
        double ratio;
        if (!this.getHasNext()) {
            String string2 = "max retries exceeded";
            throw new IllegalStateException(string2.toString());
        }
        double d = ratio = (double)tries$FU.getAndIncrement(this) / (double)(this.maxTries - 1);
        long retryProgress = Duration.times-UwyO8pc(Duration.minus-LRDsOJo(this.maxBackoff, this.firstBackoff), d);
        long diff = Duration.plus-LRDsOJo(this.firstBackoff, retryProgress);
        LinearRetryKt.access$getLinearRetryLogger$p().trace((Function0<? extends Object>)new Function0<Object>(this, diff){
            final /* synthetic */ LinearRetry this$0;
            final /* synthetic */ long $diff;
            {
                this.this$0 = $receiver;
                this.$diff = $diff;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "retry attempt " + this.this$0.tries + ", delaying for " + Duration.toString-impl(this.$diff);
            }
        });
        Object object = DelayKt.delay-VtjQ1oo(diff, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public /* synthetic */ LinearRetry(long firstBackoff, long maxBackoff, int maxTries, DefaultConstructorMarker $constructor_marker) {
        this(firstBackoff, maxBackoff, maxTries);
    }

    static {
        tries$FU = AtomicIntegerFieldUpdater.newUpdater(LinearRetry.class, "tries");
    }
}

