/*
 * Decompiled with CFR 0.152.
 */
package dev.kord.core.live;

import dev.kord.common.annotation.KordPreview;
import dev.kord.common.entity.Snowflake;
import dev.kord.common.entity.optional.Optional;
import dev.kord.common.entity.optional.OptionalKt;
import dev.kord.core.cache.data.MessageData;
import dev.kord.core.cache.data.ReactionData;
import dev.kord.core.entity.KordEntity;
import dev.kord.core.entity.Message;
import dev.kord.core.entity.ReactionEmoji;
import dev.kord.core.event.Event;
import dev.kord.core.event.channel.ChannelDeleteEvent;
import dev.kord.core.event.guild.GuildDeleteEvent;
import dev.kord.core.event.interaction.InteractionCreateEvent;
import dev.kord.core.event.interaction.MessageCommandInteractionCreateEvent;
import dev.kord.core.event.message.MessageBulkDeleteEvent;
import dev.kord.core.event.message.MessageCreateEvent;
import dev.kord.core.event.message.MessageDeleteEvent;
import dev.kord.core.event.message.MessageUpdateEvent;
import dev.kord.core.event.message.ReactionAddEvent;
import dev.kord.core.event.message.ReactionRemoveAllEvent;
import dev.kord.core.event.message.ReactionRemoveEvent;
import dev.kord.core.live.AbstractLiveKordEntity;
import dev.kord.core.live.exception.LiveCancellationException;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.JobKt;
import kotlinx.coroutines.SupervisorKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@KordPreview
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0017H\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0014H\u0014R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001a"}, d2={"Ldev/kord/core/live/LiveMessage;", "Ldev/kord/core/live/AbstractLiveKordEntity;", "Ldev/kord/core/entity/KordEntity;", "message", "Ldev/kord/core/entity/Message;", "guildId", "Ldev/kord/common/entity/Snowflake;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "(Ldev/kord/core/entity/Message;Ldev/kord/common/entity/Snowflake;Lkotlinx/coroutines/CoroutineScope;)V", "getGuildId", "()Ldev/kord/common/entity/Snowflake;", "id", "getId", "<set-?>", "getMessage", "()Ldev/kord/core/entity/Message;", "filter", "", "event", "Ldev/kord/core/event/Event;", "process", "", "Ldev/kord/core/event/message/ReactionAddEvent;", "Ldev/kord/core/event/message/ReactionRemoveEvent;", "update", "core"})
public final class LiveMessage
extends AbstractLiveKordEntity
implements KordEntity {
    @Nullable
    private final Snowflake guildId;
    @NotNull
    private Message message;

    public LiveMessage(@NotNull Message message2, @Nullable Snowflake guildId, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter(message2, "message");
        Intrinsics.checkNotNullParameter(coroutineScope, "coroutineScope");
        super(message2.getKord(), coroutineScope);
        this.guildId = guildId;
        this.message = message2;
    }

    public /* synthetic */ LiveMessage(Message message2, Snowflake snowflake, CoroutineScope coroutineScope, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            coroutineScope = CoroutineScopeKt.plus(message2.getKord(), SupervisorKt.SupervisorJob(JobKt.getJob(message2.getKord().getCoroutineContext())));
        }
        this(message2, snowflake, coroutineScope);
    }

    @Nullable
    public final Snowflake getGuildId() {
        return this.guildId;
    }

    @Override
    @NotNull
    public Snowflake getId() {
        return this.message.getId();
    }

    @NotNull
    public final Message getMessage() {
        return this.message;
    }

    @Override
    protected boolean filter(@NotNull Event event) {
        boolean bl;
        Intrinsics.checkNotNullParameter(event, "event");
        Event event2 = event;
        if (event2 instanceof ReactionAddEvent) {
            bl = Intrinsics.areEqual(((ReactionAddEvent)event).getMessageId(), this.message.getId());
        } else if (event2 instanceof ReactionRemoveEvent) {
            bl = Intrinsics.areEqual(((ReactionRemoveEvent)event).getMessageId(), this.message.getId());
        } else if (event2 instanceof ReactionRemoveAllEvent) {
            bl = Intrinsics.areEqual(((ReactionRemoveAllEvent)event).getMessageId(), this.message.getId());
        } else if (event2 instanceof MessageCreateEvent) {
            bl = Intrinsics.areEqual(((MessageCreateEvent)event).getMessage().getId(), this.message.getId());
        } else if (event2 instanceof MessageUpdateEvent) {
            bl = Intrinsics.areEqual(((MessageUpdateEvent)event).getMessageId(), this.message.getId());
        } else if (event2 instanceof MessageDeleteEvent) {
            bl = Intrinsics.areEqual(((MessageDeleteEvent)event).getMessageId(), this.message.getId());
        } else if (event2 instanceof MessageBulkDeleteEvent) {
            bl = ((MessageBulkDeleteEvent)event).getMessageIds().contains(this.message.getId());
        } else if (event2 instanceof ChannelDeleteEvent) {
            bl = Intrinsics.areEqual(((ChannelDeleteEvent)event).getChannel().getId(), this.message.getChannelId());
        } else if (event2 instanceof GuildDeleteEvent) {
            bl = Intrinsics.areEqual(((GuildDeleteEvent)event).getGuildId(), this.guildId);
        } else if (event2 instanceof MessageCommandInteractionCreateEvent) {
            bl = ((MessageCommandInteractionCreateEvent)event).getInteraction().getMessages().keySet().contains(this.message.getId());
        } else if (event2 instanceof InteractionCreateEvent) {
            MessageData messageData = ((InteractionCreateEvent)event).getInteraction().getData().getMessage().getValue();
            bl = Intrinsics.areEqual(messageData != null ? messageData.getId() : null, this.message.getId());
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    protected void update(@NotNull Event event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Event event2 = event;
        if (event2 instanceof ReactionAddEvent) {
            this.process((ReactionAddEvent)event);
        } else if (event2 instanceof ReactionRemoveEvent) {
            this.process((ReactionRemoveEvent)event);
        } else if (event2 instanceof ReactionRemoveAllEvent) {
            this.message = new Message(MessageData.copy$default(this.message.getData(), null, null, null, null, null, null, null, false, false, null, null, null, null, null, Optional.Missing.Companion.invoke(), null, false, null, null, null, null, null, null, null, null, null, null, null, 0xFFFBFFF, null), this.getKord(), null, 4, null);
        } else if (event2 instanceof MessageUpdateEvent) {
            this.message = new Message(this.message.getData().plus(((MessageUpdateEvent)event).getNew()), this.getKord(), null, 4, null);
        } else if (event2 instanceof MessageDeleteEvent ? true : event2 instanceof MessageBulkDeleteEvent) {
            this.shutDown(new LiveCancellationException(event, "The message is deleted"));
        } else if (event2 instanceof ChannelDeleteEvent) {
            this.shutDown(new LiveCancellationException(event, "The channel is deleted"));
        } else if (event2 instanceof GuildDeleteEvent) {
            this.shutDown(new LiveCancellationException(event, "The guild is deleted"));
        } else if (!(event2 instanceof MessageCommandInteractionCreateEvent) && !(event2 instanceof InteractionCreateEvent)) {
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void process(ReactionAddEvent event) {
        List<ReactionData> list;
        Object v0;
        boolean animated;
        ReactionEmoji $this$process_u24lambda_u241;
        block3: {
            void $this$firstOrNull$iv;
            $this$process_u24lambda_u241 = event.getEmoji();
            boolean bl = false;
            animated = $this$process_u24lambda_u241 instanceof ReactionEmoji.Custom && ((ReactionEmoji.Custom)$this$process_u24lambda_u241).isAnimated();
            Iterable iterable = OptionalKt.orEmpty(this.message.getData().getReactions());
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ReactionData it = (ReactionData)element$iv;
                boolean bl2 = false;
                if (!(Intrinsics.areEqual(it.getEmojiName(), $this$process_u24lambda_u241.getName()) && Intrinsics.areEqual(it.getEmojiId(), this.getId()))) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        ReactionData present = v0;
        if (present == null) {
            list = CollectionsKt.plus((Collection)OptionalKt.orEmpty(this.message.getData().getReactions()), new ReactionData(1, Intrinsics.areEqual(event.getUserId(), this.getKord().getSelfId()), this.getId(), $this$process_u24lambda_u241.getName(), animated));
        } else {
            ReactionData updated = ReactionData.copy$default(present, present.getCount() + 1, false, null, null, false, 30, null);
            list = CollectionsKt.plus((Collection)CollectionsKt.minus((Iterable)OptionalKt.orEmpty(this.message.getData().getReactions()), present), updated);
        }
        List<ReactionData> reactions2 = list;
        this.message = new Message(MessageData.copy$default(this.message.getData(), null, null, null, null, null, null, null, false, false, null, null, null, null, null, new Optional.Value<List<ReactionData>>(reactions2), null, false, null, null, null, null, null, null, null, null, null, null, null, 0xFFFBFFF, null), this.getKord(), null, 4, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void process(ReactionRemoveEvent event) {
        List<ReactionData> list;
        Object v0;
        block3: {
            void $this$firstOrNull$iv;
            ReactionEmoji $this$process_u24lambda_u243 = event.getEmoji();
            boolean bl = false;
            Iterable iterable = OptionalKt.orEmpty(this.message.getData().getReactions());
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ReactionData it = (ReactionData)element$iv;
                boolean bl2 = false;
                if (!(Intrinsics.areEqual(it.getEmojiName(), $this$process_u24lambda_u243.getName()) && Intrinsics.areEqual(it.getEmojiId(), this.getId()))) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        ReactionData present = v0;
        if (present == null) {
            list = OptionalKt.orEmpty(this.message.getData().getReactions());
        } else {
            ReactionData updated = ReactionData.copy$default(present, present.getCount() - 1, false, null, null, false, 30, null);
            list = CollectionsKt.plus((Collection)CollectionsKt.minus((Iterable)OptionalKt.orEmpty(this.message.getData().getReactions()), present), updated);
        }
        List<ReactionData> reactions2 = list;
        this.message = new Message(MessageData.copy$default(this.message.getData(), null, null, null, null, null, null, null, false, false, null, null, null, null, null, new Optional.Value<List<ReactionData>>(reactions2), null, false, null, null, null, null, null, null, null, null, null, null, null, 0xFFFBFFF, null), this.getKord(), null, 4, null);
    }
}

