/*
 * Decompiled with CFR 0.152.
 */
package dev.kord.core.exception;

import dev.kord.common.entity.Snowflake;
import dev.kord.core.entity.application.ApplicationCommand;
import dev.kord.core.entity.channel.Channel;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.ULong;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0004\u0018\u0000 \n2\u00060\u0001j\u0002`\u0002:\u0001\nB\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u0017\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\t\u00a8\u0006\u000b"}, d2={"Ldev/kord/core/exception/EntityNotFoundException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "message", "", "(Ljava/lang/String;)V", "cause", "", "(Ljava/lang/Throwable;)V", "(Ljava/lang/String;Ljava/lang/Throwable;)V", "Companion", "core"})
public final class EntityNotFoundException
extends Exception {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public EntityNotFoundException(@NotNull String message2) {
        Intrinsics.checkNotNullParameter(message2, "message");
        super(message2);
    }

    public EntityNotFoundException(@NotNull Throwable cause) {
        Intrinsics.checkNotNullParameter(cause, "cause");
        super(cause);
    }

    public EntityNotFoundException(@NotNull String message2, @NotNull Throwable cause) {
        Intrinsics.checkNotNullParameter(message2, "message");
        Intrinsics.checkNotNullParameter(cause, "cause");
        super(message2, cause);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u001c\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u0004\"\n\b\u0000\u0010\u0005\u0018\u0001*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0086\bJ\u0011\u0010\t\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0086\bJ\u0019\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\bH\u0086\bJ\u0019\u0010\r\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\bH\u0086\bJ\u001d\u0010\u000f\u001a\u00020\u0004\"\n\b\u0000\u0010\u0005\u0018\u0001*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\bH\u0086\bJ\u0019\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\bH\u0086\bJ\u0019\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\bH\u0081\bJ\u0019\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\bH\u0086\bJ!\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\bH\u0081\bJ\u0011\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\bH\u0086\bJ\u0011\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\bH\u0086\bJ\u0011\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u0016H\u0086\bJ\u0011\u0010 \u001a\u00020\u00042\u0006\u0010!\u001a\u00020\u0016H\u0086\bJ\u0019\u0010\"\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\bH\u0086\bJ\u0019\u0010#\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\bH\u0086\bJ\u0019\u0010$\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010%\u001a\u00020\bH\u0086\bJ\t\u0010&\u001a\u00020\u0004H\u0086\bJ\u0011\u0010'\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\bH\u0086\bJ\u0011\u0010(\u001a\u00020\u00042\u0006\u0010)\u001a\u00020\bH\u0086\bJ\u0011\u0010*\u001a\u00020\u00042\u0006\u0010!\u001a\u00020\u0016H\u0086\bJ\u0011\u0010+\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\bH\u0086\bJ-\u0010,\u001a\u00020\u00042\u0006\u0010-\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\b2\n\b\u0002\u0010.\u001a\u0004\u0018\u00010\bH\u0086\bJ\u0011\u0010/\u001a\u00020\u00042\u0006\u0010-\u001a\u00020\bH\u0086\bJ\u0011\u00100\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\bH\u0086\bJ\u0011\u00101\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\bH\u0086\b\u00a8\u00062"}, d2={"Ldev/kord/core/exception/EntityNotFoundException$Companion;", "", "()V", "applicationCommandNotFound", "", "T", "Ldev/kord/core/entity/application/ApplicationCommand;", "commandId", "Ldev/kord/common/entity/Snowflake;", "applicationCommandPermissionsNotFound", "autoModerationRuleNotFound", "guildId", "ruleId", "banNotFound", "userId", "channelNotFound", "Ldev/kord/core/entity/channel/Channel;", "channelId", "emojiNotFound", "emojiId", "entityNotFound", "entityType", "", "id", "followupMessageNotFound", "token", "messageId", "guildEntityNotFound", "guildNotFound", "guildScheduledEventNotFound", "eventId", "interactionNotFound", "inviteNotFound", "code", "memberNotFound", "messageNotFound", "roleNotFound", "roleId", "selfNotFound", "stageInstanceNotFound", "stickerNotFound", "stickerId", "templateNotFound", "userNotFound", "webhookMessageNotFound", "webhookId", "threadId", "webhookNotFound", "welcomeScreenNotFound", "widgetNotFound", "core"})
    public static final class Companion {
        private Companion() {
        }

        @PublishedApi
        @NotNull
        public final Void entityNotFound(@NotNull String entityType2, @NotNull Snowflake id) {
            Intrinsics.checkNotNullParameter(entityType2, "entityType");
            Intrinsics.checkNotNullParameter(id, "id");
            boolean $i$f$entityNotFound = false;
            throw new EntityNotFoundException(entityType2 + " with id " + id + " was not found.");
        }

        @PublishedApi
        @NotNull
        public final Void guildEntityNotFound(@NotNull String entityType2, @NotNull Snowflake guildId, @NotNull Snowflake id) {
            Intrinsics.checkNotNullParameter(entityType2, "entityType");
            Intrinsics.checkNotNullParameter(guildId, "guildId");
            Intrinsics.checkNotNullParameter(id, "id");
            boolean $i$f$guildEntityNotFound = false;
            throw new EntityNotFoundException(entityType2 + " with id " + id + " in guild " + guildId + " was not found.");
        }

        @NotNull
        public final Void guildNotFound(@NotNull Snowflake guildId) {
            Intrinsics.checkNotNullParameter(guildId, "guildId");
            boolean $i$f$guildNotFound = false;
            Companion companion = this;
            String entityType$iv = "Guild";
            boolean $i$f$entityNotFound = false;
            throw new EntityNotFoundException(entityType$iv + " with id " + guildId + " was not found.");
        }

        public final /* synthetic */ <T extends Channel> Void channelNotFound(Snowflake channelId2) {
            Intrinsics.checkNotNullParameter(channelId2, "channelId");
            boolean $i$f$channelNotFound = false;
            Companion companion = this;
            Intrinsics.reifiedOperationMarker(4, "T");
            String string2 = Reflection.getOrCreateKotlinClass(Channel.class).getSimpleName();
            Intrinsics.checkNotNull(string2);
            String entityType$iv = string2;
            boolean $i$f$entityNotFound = false;
            throw new EntityNotFoundException(entityType$iv + " with id " + channelId2 + " was not found.");
        }

        @NotNull
        public final Void memberNotFound(@NotNull Snowflake guildId, @NotNull Snowflake userId) {
            Intrinsics.checkNotNullParameter(guildId, "guildId");
            Intrinsics.checkNotNullParameter(userId, "userId");
            boolean $i$f$memberNotFound = false;
            Companion companion = this;
            String entityType$iv = "Member";
            boolean $i$f$guildEntityNotFound = false;
            throw new EntityNotFoundException(entityType$iv + " with id " + userId + " in guild " + guildId + " was not found.");
        }

        @NotNull
        public final Void messageNotFound(@NotNull Snowflake channelId2, @NotNull Snowflake messageId) {
            Intrinsics.checkNotNullParameter(channelId2, "channelId");
            Intrinsics.checkNotNullParameter(messageId, "messageId");
            boolean $i$f$messageNotFound = false;
            throw new EntityNotFoundException("Message with id " + messageId + " in channel " + channelId2 + " was not found.");
        }

        @NotNull
        public final Void userNotFound(@NotNull Snowflake userId) {
            Intrinsics.checkNotNullParameter(userId, "userId");
            boolean $i$f$userNotFound = false;
            Companion companion = this;
            String entityType$iv = "User";
            boolean $i$f$entityNotFound = false;
            throw new EntityNotFoundException(entityType$iv + " with id " + userId + " was not found.");
        }

        @NotNull
        public final Void selfNotFound() {
            boolean $i$f$selfNotFound = false;
            throw new EntityNotFoundException("Self user was not found.");
        }

        @NotNull
        public final Void roleNotFound(@NotNull Snowflake guildId, @NotNull Snowflake roleId) {
            Intrinsics.checkNotNullParameter(guildId, "guildId");
            Intrinsics.checkNotNullParameter(roleId, "roleId");
            boolean $i$f$roleNotFound = false;
            Companion companion = this;
            String entityType$iv = "Role";
            boolean $i$f$guildEntityNotFound = false;
            throw new EntityNotFoundException(entityType$iv + " with id " + roleId + " in guild " + guildId + " was not found.");
        }

        @NotNull
        public final Void banNotFound(@NotNull Snowflake guildId, @NotNull Snowflake userId) {
            Intrinsics.checkNotNullParameter(guildId, "guildId");
            Intrinsics.checkNotNullParameter(userId, "userId");
            boolean $i$f$banNotFound = false;
            Companion companion = this;
            String entityType$iv = "Ban";
            boolean $i$f$guildEntityNotFound = false;
            throw new EntityNotFoundException(entityType$iv + " with id " + userId + " in guild " + guildId + " was not found.");
        }

        @NotNull
        public final Void emojiNotFound(@NotNull Snowflake guildId, @NotNull Snowflake emojiId) {
            Intrinsics.checkNotNullParameter(guildId, "guildId");
            Intrinsics.checkNotNullParameter(emojiId, "emojiId");
            boolean $i$f$emojiNotFound = false;
            Companion companion = this;
            String entityType$iv = "GuildEmoji";
            boolean $i$f$guildEntityNotFound = false;
            throw new EntityNotFoundException(entityType$iv + " with id " + emojiId + " in guild " + guildId + " was not found.");
        }

        @NotNull
        public final Void webhookNotFound(@NotNull Snowflake webhookId) {
            Intrinsics.checkNotNullParameter(webhookId, "webhookId");
            boolean $i$f$webhookNotFound = false;
            Companion companion = this;
            String entityType$iv = "Webhook";
            boolean $i$f$entityNotFound = false;
            throw new EntityNotFoundException(entityType$iv + " with id " + webhookId + " was not found.");
        }

        @NotNull
        public final Void webhookMessageNotFound(@NotNull Snowflake webhookId, @NotNull String token2, @NotNull Snowflake messageId, @Nullable Snowflake threadId) {
            Intrinsics.checkNotNullParameter(webhookId, "webhookId");
            Intrinsics.checkNotNullParameter(token2, "token");
            Intrinsics.checkNotNullParameter(messageId, "messageId");
            boolean $i$f$webhookMessageNotFound = false;
            throw new EntityNotFoundException("Message with id " + messageId + ' ' + (threadId != null ? "in thread " + threadId + ' ' : "") + "from webhook " + webhookId + " with token " + token2 + " was not found.");
        }

        public static /* synthetic */ Void webhookMessageNotFound$default(Companion $this, Snowflake webhookId, String token2, Snowflake messageId, Snowflake threadId, int n, Object object) {
            if ((n & 8) != 0) {
                threadId = null;
            }
            Intrinsics.checkNotNullParameter(webhookId, "webhookId");
            Intrinsics.checkNotNullParameter(token2, "token");
            Intrinsics.checkNotNullParameter(messageId, "messageId");
            boolean $i$f$webhookMessageNotFound = false;
            throw new EntityNotFoundException("Message with id " + messageId + ' ' + (threadId != null ? "in thread " + threadId + ' ' : "") + "from webhook " + webhookId + " with token " + token2 + " was not found.");
        }

        @NotNull
        public final Void inviteNotFound(@NotNull String code) {
            Intrinsics.checkNotNullParameter(code, "code");
            boolean $i$f$inviteNotFound = false;
            throw new EntityNotFoundException("Invite with code " + code + " was not found.");
        }

        @NotNull
        public final Void widgetNotFound(@NotNull Snowflake id) {
            Intrinsics.checkNotNullParameter(id, "id");
            boolean $i$f$widgetNotFound = false;
            throw new EntityNotFoundException("Widget for guild " + ULong.toString-impl(id.getValue-s-VKNKU()) + " was not found.");
        }

        @NotNull
        public final Void templateNotFound(@NotNull String code) {
            Intrinsics.checkNotNullParameter(code, "code");
            boolean $i$f$templateNotFound = false;
            throw new EntityNotFoundException("Template " + code + " was not found.");
        }

        @NotNull
        public final Void welcomeScreenNotFound(@NotNull Snowflake guildId) {
            Intrinsics.checkNotNullParameter(guildId, "guildId");
            boolean $i$f$welcomeScreenNotFound = false;
            throw new EntityNotFoundException("Welcome screen for guild " + guildId + " was not found.");
        }

        @NotNull
        public final Void stageInstanceNotFound(@NotNull Snowflake channelId2) {
            Intrinsics.checkNotNullParameter(channelId2, "channelId");
            boolean $i$f$stageInstanceNotFound = false;
            throw new EntityNotFoundException("Stage instance for channel " + channelId2 + " was not found.");
        }

        @NotNull
        public final Void stickerNotFound(@NotNull Snowflake stickerId) {
            Intrinsics.checkNotNullParameter(stickerId, "stickerId");
            boolean $i$f$stickerNotFound = false;
            Companion companion = this;
            String entityType$iv = "Sticker";
            boolean $i$f$entityNotFound = false;
            throw new EntityNotFoundException(entityType$iv + " with id " + stickerId + " was not found.");
        }

        @NotNull
        public final Void applicationCommandPermissionsNotFound(@NotNull Snowflake commandId) {
            Intrinsics.checkNotNullParameter(commandId, "commandId");
            boolean $i$f$applicationCommandPermissionsNotFound = false;
            Companion companion = this;
            String entityType$iv = "ApplicationCommand";
            boolean $i$f$entityNotFound = false;
            throw new EntityNotFoundException(entityType$iv + " with id " + commandId + " was not found.");
        }

        @NotNull
        public final Void guildScheduledEventNotFound(@NotNull Snowflake eventId) {
            Intrinsics.checkNotNullParameter(eventId, "eventId");
            boolean $i$f$guildScheduledEventNotFound = false;
            Companion companion = this;
            String entityType$iv = "GuildScheduledEvent";
            boolean $i$f$entityNotFound = false;
            throw new EntityNotFoundException(entityType$iv + " with id " + eventId + " was not found.");
        }

        public final /* synthetic */ <T extends ApplicationCommand> Void applicationCommandNotFound(Snowflake commandId) {
            Intrinsics.checkNotNullParameter(commandId, "commandId");
            boolean $i$f$applicationCommandNotFound = false;
            Companion companion = this;
            Intrinsics.reifiedOperationMarker(4, "T");
            String string2 = Reflection.getOrCreateKotlinClass(ApplicationCommand.class).getSimpleName();
            Intrinsics.checkNotNull(string2);
            String entityType$iv = string2;
            boolean $i$f$entityNotFound = false;
            throw new EntityNotFoundException(entityType$iv + " with id " + commandId + " was not found.");
        }

        @NotNull
        public final Void interactionNotFound(@NotNull String token2) {
            Intrinsics.checkNotNullParameter(token2, "token");
            boolean $i$f$interactionNotFound = false;
            throw new EntityNotFoundException("Initial interaction response for interaction with token " + token2 + " was not found.");
        }

        @NotNull
        public final Void followupMessageNotFound(@NotNull String token2, @NotNull Snowflake messageId) {
            Intrinsics.checkNotNullParameter(token2, "token");
            Intrinsics.checkNotNullParameter(messageId, "messageId");
            boolean $i$f$followupMessageNotFound = false;
            throw new EntityNotFoundException("Followup message with id " + messageId + " for interaction with token " + token2 + " was not found.");
        }

        @NotNull
        public final Void autoModerationRuleNotFound(@NotNull Snowflake guildId, @NotNull Snowflake ruleId) {
            Intrinsics.checkNotNullParameter(guildId, "guildId");
            Intrinsics.checkNotNullParameter(ruleId, "ruleId");
            boolean $i$f$autoModerationRuleNotFound = false;
            Companion companion = this;
            String entityType$iv = "Auto Moderation Rule";
            boolean $i$f$guildEntityNotFound = false;
            throw new EntityNotFoundException(entityType$iv + " with id " + ruleId + " in guild " + guildId + " was not found.");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

