/*
 * Decompiled with CFR 0.152.
 */
package dev.kord.core.event.guild;

import dev.kord.common.entity.Snowflake;
import dev.kord.common.entity.optional.OptionalKt;
import dev.kord.core.Kord;
import dev.kord.core.behavior.GuildBehavior;
import dev.kord.core.behavior.GuildBehaviorKt;
import dev.kord.core.cache.data.MemberData;
import dev.kord.core.cache.data.MembersChunkData;
import dev.kord.core.cache.data.PresenceData;
import dev.kord.core.cache.data.UserData;
import dev.kord.core.entity.Guild;
import dev.kord.core.entity.Member;
import dev.kord.core.entity.Presence;
import dev.kord.core.entity.Strategizable;
import dev.kord.core.event.Event;
import dev.kord.core.supplier.EntitySupplier;
import dev.kord.core.supplier.EntitySupplyStrategy;
import dev.kord.gateway.Gateway;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B1\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0011\u0010\u0019\u001a\u000204H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00105J\u0013\u00106\u001a\u0004\u0018\u000104H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00105J\b\u00107\u001a\u00020)H\u0016J\u0014\u00108\u001a\u00020\u00002\n\u00109\u001a\u0006\u0012\u0002\b\u00030:H\u0016R\u0011\u0010\u000e\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010R\u0016\u0010\t\u001a\u0004\u0018\u00010\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0017\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001c0 8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0017\u0010%\u001a\b\u0012\u0004\u0012\u00020&0 8F\u00a2\u0006\u0006\u001a\u0004\b'\u0010\"R\u0013\u0010(\u001a\u0004\u0018\u00010)8F\u00a2\u0006\u0006\u001a\u0004\b*\u0010+R\u0017\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-8F\u00a2\u0006\u0006\u001a\u0004\b/\u00100R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u0010\u0010R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006;"}, d2={"Ldev/kord/core/event/guild/MembersChunkEvent;", "Ldev/kord/core/event/Event;", "Ldev/kord/core/entity/Strategizable;", "data", "Ldev/kord/core/cache/data/MembersChunkData;", "kord", "Ldev/kord/core/Kord;", "shard", "", "customContext", "", "supplier", "Ldev/kord/core/supplier/EntitySupplier;", "(Ldev/kord/core/cache/data/MembersChunkData;Ldev/kord/core/Kord;ILjava/lang/Object;Ldev/kord/core/supplier/EntitySupplier;)V", "chunkCount", "getChunkCount", "()I", "chunkIndex", "getChunkIndex", "getCustomContext", "()Ljava/lang/Object;", "getData", "()Ldev/kord/core/cache/data/MembersChunkData;", "guild", "Ldev/kord/core/behavior/GuildBehavior;", "getGuild", "()Ldev/kord/core/behavior/GuildBehavior;", "guildId", "Ldev/kord/common/entity/Snowflake;", "getGuildId", "()Ldev/kord/common/entity/Snowflake;", "invalidIds", "", "getInvalidIds", "()Ljava/util/Set;", "getKord", "()Ldev/kord/core/Kord;", "members", "Ldev/kord/core/entity/Member;", "getMembers", "nonce", "", "getNonce", "()Ljava/lang/String;", "presences", "", "Ldev/kord/core/entity/Presence;", "getPresences", "()Ljava/util/List;", "getShard", "getSupplier", "()Ldev/kord/core/supplier/EntitySupplier;", "Ldev/kord/core/entity/Guild;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getGuildOrNull", "toString", "withStrategy", "strategy", "Ldev/kord/core/supplier/EntitySupplyStrategy;", "core"})
public final class MembersChunkEvent
implements Event,
Strategizable {
    @NotNull
    private final MembersChunkData data;
    @NotNull
    private final Kord kord;
    private final int shard;
    @Nullable
    private final Object customContext;
    @NotNull
    private final EntitySupplier supplier;

    public MembersChunkEvent(@NotNull MembersChunkData data2, @NotNull Kord kord, int shard, @Nullable Object customContext, @NotNull EntitySupplier supplier) {
        Intrinsics.checkNotNullParameter(data2, "data");
        Intrinsics.checkNotNullParameter(kord, "kord");
        Intrinsics.checkNotNullParameter(supplier, "supplier");
        this.data = data2;
        this.kord = kord;
        this.shard = shard;
        this.customContext = customContext;
        this.supplier = supplier;
    }

    public /* synthetic */ MembersChunkEvent(MembersChunkData membersChunkData, Kord kord, int n, Object object, EntitySupplier entitySupplier, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x10) != 0) {
            entitySupplier = kord.getDefaultSupplier();
        }
        this(membersChunkData, kord, n, object, entitySupplier);
    }

    @NotNull
    public final MembersChunkData getData() {
        return this.data;
    }

    @Override
    @NotNull
    public Kord getKord() {
        return this.kord;
    }

    @Override
    public int getShard() {
        return this.shard;
    }

    @Override
    @Nullable
    public Object getCustomContext() {
        return this.customContext;
    }

    @Override
    @NotNull
    public EntitySupplier getSupplier() {
        return this.supplier;
    }

    @NotNull
    public final Snowflake getGuildId() {
        return this.data.getGuildId();
    }

    @NotNull
    public final GuildBehavior getGuild() {
        return GuildBehaviorKt.GuildBehavior$default(this.getGuildId(), this.getKord(), null, 4, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<Member> getMembers() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = CollectionsKt.zip((Iterable)this.data.getMembers(), (Iterable)this.data.getUsers());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            MemberData member = (MemberData)pair.component1();
            UserData user2 = (UserData)pair.component2();
            collection.add(new Member(member, user2, this.getKord(), null, 8, null));
        }
        return CollectionsKt.toSet((List)destination$iv$iv);
    }

    public final int getChunkIndex() {
        return this.data.getChunkIndex();
    }

    public final int getChunkCount() {
        return this.data.getChunkCount();
    }

    @NotNull
    public final Set<Snowflake> getInvalidIds() {
        return OptionalKt.orEmpty(this.data.getNotFound());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Presence> getPresences() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = OptionalKt.orEmpty(this.data.getPresences());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PresenceData presenceData = (PresenceData)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Presence((PresenceData)it, this.getKord(), null, 4, null));
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public final String getNonce() {
        return this.data.getNonce().getValue();
    }

    @Nullable
    public final Object getGuild(@NotNull Continuation<? super Guild> $completion) {
        return this.getSupplier().getGuild(this.getGuildId(), $completion);
    }

    @Nullable
    public final Object getGuildOrNull(@NotNull Continuation<? super Guild> $completion) {
        return this.getSupplier().getGuildOrNull(this.getGuildId(), $completion);
    }

    @Override
    @NotNull
    public MembersChunkEvent withStrategy(@NotNull EntitySupplyStrategy<?> strategy) {
        Intrinsics.checkNotNullParameter(strategy, "strategy");
        return new MembersChunkEvent(this.data, this.getKord(), this.getShard(), this.getCustomContext(), (EntitySupplier)strategy.supply(this.getKord()));
    }

    @NotNull
    public String toString() {
        return "MemberChunksEvent(guildId=" + this.getGuildId() + ", members=" + this.getMembers() + ", kord=" + this.getKord() + ", shard=" + this.getShard() + ", supplier=" + this.getSupplier() + ')';
    }

    @Override
    @NotNull
    public Gateway getGateway() {
        return Event.DefaultImpls.getGateway(this);
    }
}

