/*
 * Decompiled with CFR 0.152.
 */
package dev.kord.core.entity.interaction;

import dev.kord.common.entity.CommandArgument;
import dev.kord.common.entity.Snowflake;
import dev.kord.core.entity.Attachment;
import dev.kord.core.entity.Member;
import dev.kord.core.entity.Role;
import dev.kord.core.entity.Strategizable;
import dev.kord.core.entity.User;
import dev.kord.core.entity.channel.ResolvedChannel;
import dev.kord.core.entity.interaction.AttachmentOptionValue;
import dev.kord.core.entity.interaction.BooleanOptionValue;
import dev.kord.core.entity.interaction.ChannelOptionValue;
import dev.kord.core.entity.interaction.IntegerOptionValue;
import dev.kord.core.entity.interaction.MemberOptionValue;
import dev.kord.core.entity.interaction.MentionableOptionValue;
import dev.kord.core.entity.interaction.NumberOptionValue;
import dev.kord.core.entity.interaction.OptionValue;
import dev.kord.core.entity.interaction.ResolvedObjects;
import dev.kord.core.entity.interaction.RoleOptionValue;
import dev.kord.core.entity.interaction.StringOptionValue;
import dev.kord.core.entity.interaction.UserOptionValue;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0000\u001a\u0006\u0012\u0002\b\u00030\u00012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a8\u0006\u0006"}, d2={"OptionValue", "Ldev/kord/core/entity/interaction/OptionValue;", "value", "Ldev/kord/common/entity/CommandArgument;", "resolvedObjects", "Ldev/kord/core/entity/interaction/ResolvedObjects;", "core"})
public final class OptionValueKt {
    @NotNull
    public static final OptionValue<?> OptionValue(@NotNull CommandArgument<?> value2, @Nullable ResolvedObjects resolvedObjects) {
        OptionValue optionValue;
        Intrinsics.checkNotNullParameter(value2, "value");
        boolean focused = value2.getFocused().orElse(false);
        CommandArgument<?> commandArgument = value2;
        if (commandArgument instanceof CommandArgument.NumberArgument) {
            optionValue = new NumberOptionValue(((CommandArgument.NumberArgument)value2).getValue(), focused);
        } else if (commandArgument instanceof CommandArgument.BooleanArgument) {
            optionValue = new BooleanOptionValue(((CommandArgument.BooleanArgument)value2).getValue(), focused);
        } else if (commandArgument instanceof CommandArgument.IntegerArgument) {
            optionValue = new IntegerOptionValue(((CommandArgument.IntegerArgument)value2).getValue(), focused);
        } else if (commandArgument instanceof CommandArgument.StringArgument ? true : commandArgument instanceof CommandArgument.AutoCompleteArgument) {
            Object obj = value2.getValue();
            Intrinsics.checkNotNull(obj, "null cannot be cast to non-null type kotlin.String");
            optionValue = new StringOptionValue((String)obj, focused);
        } else if (commandArgument instanceof CommandArgument.ChannelArgument) {
            ResolvedObjects resolvedObjects2 = resolvedObjects;
            Map<Snowflake, ResolvedChannel> map2 = resolvedObjects2 != null ? resolvedObjects2.getChannels() : null;
            if (map2 == null) {
                map2 = MapsKt.emptyMap();
            }
            ResolvedChannel channel2 = map2.get(((CommandArgument.ChannelArgument)value2).getValue());
            optionValue = new ChannelOptionValue(((CommandArgument.ChannelArgument)value2).getValue(), focused, channel2);
        } else if (commandArgument instanceof CommandArgument.MentionableArgument) {
            ResolvedObjects resolvedObjects3 = resolvedObjects;
            Map<Snowflake, ResolvedChannel> map3 = resolvedObjects3 != null ? resolvedObjects3.getChannels() : null;
            if (map3 == null) {
                map3 = MapsKt.emptyMap();
            }
            ResolvedChannel channel3 = map3.get(((CommandArgument.MentionableArgument)value2).getValue());
            ResolvedObjects resolvedObjects4 = resolvedObjects;
            Map<Snowflake, User> map4 = resolvedObjects4 != null ? resolvedObjects4.getUsers() : null;
            if (map4 == null) {
                map4 = MapsKt.emptyMap();
            }
            User user2 = map4.get(((CommandArgument.MentionableArgument)value2).getValue());
            ResolvedObjects resolvedObjects5 = resolvedObjects;
            Map<Snowflake, Member> map5 = resolvedObjects5 != null ? resolvedObjects5.getMembers() : null;
            if (map5 == null) {
                map5 = MapsKt.emptyMap();
            }
            Member member = map5.get(((CommandArgument.MentionableArgument)value2).getValue());
            ResolvedObjects resolvedObjects6 = resolvedObjects;
            Map<Snowflake, Role> map6 = resolvedObjects6 != null ? resolvedObjects6.getRoles() : null;
            if (map6 == null) {
                map6 = MapsKt.emptyMap();
            }
            Role role2 = map6.get(((CommandArgument.MentionableArgument)value2).getValue());
            Strategizable strategizable = channel3;
            if (strategizable == null && (strategizable = member) == null && (strategizable = user2) == null) {
                strategizable = role2;
            }
            ResolvedChannel entity = strategizable;
            optionValue = new MentionableOptionValue(((CommandArgument.MentionableArgument)value2).getValue(), focused, entity);
        } else if (commandArgument instanceof CommandArgument.RoleArgument) {
            ResolvedObjects resolvedObjects7 = resolvedObjects;
            Map<Snowflake, Role> map7 = resolvedObjects7 != null ? resolvedObjects7.getRoles() : null;
            if (map7 == null) {
                map7 = MapsKt.emptyMap();
            }
            Role role3 = map7.get(((CommandArgument.RoleArgument)value2).getValue());
            optionValue = new RoleOptionValue(((CommandArgument.RoleArgument)value2).getValue(), focused, role3);
        } else if (commandArgument instanceof CommandArgument.UserArgument) {
            Member member;
            ResolvedObjects resolvedObjects8 = resolvedObjects;
            Map<Snowflake, Member> map8 = resolvedObjects8 != null ? resolvedObjects8.getMembers() : null;
            if (map8 == null) {
                map8 = MapsKt.emptyMap();
            }
            if ((member = map8.get(((CommandArgument.UserArgument)value2).getValue())) != null) {
                return new MemberOptionValue(((CommandArgument.UserArgument)value2).getValue(), focused, member);
            }
            ResolvedObjects resolvedObjects9 = resolvedObjects;
            Map<Snowflake, User> map9 = resolvedObjects9 != null ? resolvedObjects9.getUsers() : null;
            if (map9 == null) {
                map9 = MapsKt.emptyMap();
            }
            User user3 = map9.get(((CommandArgument.UserArgument)value2).getValue());
            optionValue = new UserOptionValue(((CommandArgument.UserArgument)value2).getValue(), focused, user3);
        } else if (commandArgument instanceof CommandArgument.AttachmentArgument) {
            ResolvedObjects resolvedObjects10 = resolvedObjects;
            Map<Snowflake, Attachment> map10 = resolvedObjects10 != null ? resolvedObjects10.getAttachments() : null;
            if (map10 == null) {
                map10 = MapsKt.emptyMap();
            }
            Attachment attachment2 = map10.get(((CommandArgument.AttachmentArgument)value2).getValue());
            optionValue = new AttachmentOptionValue(((CommandArgument.AttachmentArgument)value2).getValue(), focused, attachment2);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return optionValue;
    }
}

