/*
 * Decompiled with CFR 0.152.
 */
package dev.kord.core.entity.interaction;

import dev.kord.common.Locale;
import dev.kord.common.entity.InteractionType;
import dev.kord.common.entity.Permissions;
import dev.kord.common.entity.Snowflake;
import dev.kord.core.behavior.GuildBehavior;
import dev.kord.core.behavior.channel.GuildMessageChannelBehavior;
import dev.kord.core.behavior.interaction.GuildInteractionBehavior;
import dev.kord.core.cache.data.MemberData;
import dev.kord.core.cache.data.UserData;
import dev.kord.core.entity.Entity;
import dev.kord.core.entity.Guild;
import dev.kord.core.entity.Member;
import dev.kord.core.entity.channel.GuildMessageChannel;
import dev.kord.core.entity.interaction.Interaction;
import dev.kord.core.supplier.EntitySupplyStrategy;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u00012\u00020\u0002J\u0014\u0010\u0011\u001a\u00020\u00002\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0013H&R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0006R\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u0082\u0001\u0004\u0014\u0015\u0016\u0017\u00a8\u0006\u0018"}, d2={"Ldev/kord/core/entity/interaction/GuildInteraction;", "Ldev/kord/core/entity/interaction/Interaction;", "Ldev/kord/core/behavior/interaction/GuildInteractionBehavior;", "appPermissions", "Ldev/kord/common/entity/Permissions;", "getAppPermissions", "()Ldev/kord/common/entity/Permissions;", "guildId", "Ldev/kord/common/entity/Snowflake;", "getGuildId", "()Ldev/kord/common/entity/Snowflake;", "permissions", "getPermissions", "user", "Ldev/kord/core/entity/Member;", "getUser", "()Ldev/kord/core/entity/Member;", "withStrategy", "strategy", "Ldev/kord/core/supplier/EntitySupplyStrategy;", "Ldev/kord/core/entity/interaction/GuildApplicationCommandInteraction;", "Ldev/kord/core/entity/interaction/GuildAutoCompleteInteraction;", "Ldev/kord/core/entity/interaction/GuildComponentInteraction;", "Ldev/kord/core/entity/interaction/GuildModalSubmitInteraction;", "core"})
public interface GuildInteraction
extends Interaction,
GuildInteractionBehavior {
    @Override
    @NotNull
    public Snowflake getGuildId();

    @NotNull
    public Permissions getPermissions();

    @Override
    @NotNull
    public Member getUser();

    @NotNull
    public Permissions getAppPermissions();

    @Override
    @NotNull
    public GuildInteraction withStrategy(@NotNull EntitySupplyStrategy<?> var1);

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        @NotNull
        public static Snowflake getGuildId(@NotNull GuildInteraction $this) {
            Snowflake snowflake = $this.getData().getGuildId().getValue();
            Intrinsics.checkNotNull(snowflake);
            return snowflake;
        }

        @NotNull
        public static Permissions getPermissions(@NotNull GuildInteraction $this) {
            Permissions permissions2 = $this.getData().getPermissions().getValue();
            Intrinsics.checkNotNull(permissions2);
            return permissions2;
        }

        @NotNull
        public static Member getUser(@NotNull GuildInteraction $this) {
            MemberData memberData2 = $this.getData().getMember().getValue();
            Intrinsics.checkNotNull(memberData2);
            UserData userData2 = $this.getData().getUser().getValue();
            Intrinsics.checkNotNull(userData2);
            return new Member(memberData2, userData2, $this.getKord(), null, 8, null);
        }

        @NotNull
        public static Permissions getAppPermissions(@NotNull GuildInteraction $this) {
            Permissions permissions2 = $this.getData().getAppPermissions().getValue();
            Intrinsics.checkNotNull(permissions2);
            return permissions2;
        }

        @NotNull
        public static Snowflake getId(@NotNull GuildInteraction $this) {
            return Interaction.DefaultImpls.getId($this);
        }

        @NotNull
        public static Snowflake getApplicationId(@NotNull GuildInteraction $this) {
            return Interaction.DefaultImpls.getApplicationId($this);
        }

        @NotNull
        public static Snowflake getChannelId(@NotNull GuildInteraction $this) {
            return Interaction.DefaultImpls.getChannelId($this);
        }

        @NotNull
        public static String getToken(@NotNull GuildInteraction $this) {
            return Interaction.DefaultImpls.getToken($this);
        }

        @NotNull
        public static InteractionType getType(@NotNull GuildInteraction $this) {
            return Interaction.DefaultImpls.getType($this);
        }

        @Nullable
        public static Locale getLocale(@NotNull GuildInteraction $this) {
            return Interaction.DefaultImpls.getLocale($this);
        }

        @Nullable
        public static Locale getGuildLocale(@NotNull GuildInteraction $this) {
            return Interaction.DefaultImpls.getGuildLocale($this);
        }

        public static int getVersion(@NotNull GuildInteraction $this) {
            return Interaction.DefaultImpls.getVersion($this);
        }

        @NotNull
        public static GuildMessageChannelBehavior getChannel(@NotNull GuildInteraction $this) {
            return GuildInteractionBehavior.DefaultImpls.getChannel($this);
        }

        @Nullable
        public static Object getChannelOrNull(@NotNull GuildInteraction $this, @NotNull Continuation<? super GuildMessageChannel> $completion) {
            return GuildInteractionBehavior.DefaultImpls.getChannelOrNull($this, $completion);
        }

        @Nullable
        public static Object getChannel(@NotNull GuildInteraction $this, @NotNull Continuation<? super GuildMessageChannel> $completion) {
            return GuildInteractionBehavior.DefaultImpls.getChannel($this, $completion);
        }

        public static int compareTo(@NotNull GuildInteraction $this, @NotNull Entity other) {
            Intrinsics.checkNotNullParameter(other, "other");
            return Interaction.DefaultImpls.compareTo($this, other);
        }

        @NotNull
        public static GuildBehavior getGuild(@NotNull GuildInteraction $this) {
            return GuildInteractionBehavior.DefaultImpls.getGuild($this);
        }

        @Nullable
        public static Object getGuildOrNull(@NotNull GuildInteraction $this, @NotNull Continuation<? super Guild> $completion) {
            return GuildInteractionBehavior.DefaultImpls.getGuildOrNull($this, $completion);
        }

        @Nullable
        public static Object getGuild(@NotNull GuildInteraction $this, @NotNull Continuation<? super Guild> $completion) {
            return GuildInteractionBehavior.DefaultImpls.getGuild($this, $completion);
        }
    }
}

