/*
 * Decompiled with CFR 0.152.
 */
package dev.kord.core.entity.interaction;

import dev.kord.common.entity.ComponentType;
import dev.kord.core.Kord;
import dev.kord.core.cache.data.InteractionData;
import dev.kord.core.entity.interaction.ButtonInteraction;
import dev.kord.core.entity.interaction.ComponentInteraction;
import dev.kord.core.entity.interaction.GlobalButtonInteraction;
import dev.kord.core.entity.interaction.GlobalSelectMenuInteraction;
import dev.kord.core.entity.interaction.GuildButtonInteraction;
import dev.kord.core.entity.interaction.GuildSelectMenuInteraction;
import dev.kord.core.entity.interaction.SelectMenuInteraction;
import dev.kord.core.supplier.EntitySupplier;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"ComponentInteraction", "Ldev/kord/core/entity/interaction/ComponentInteraction;", "data", "Ldev/kord/core/cache/data/InteractionData;", "kord", "Ldev/kord/core/Kord;", "supplier", "Ldev/kord/core/supplier/EntitySupplier;", "core"})
public final class ComponentInteractionKt {
    @NotNull
    public static final ComponentInteraction ComponentInteraction(@NotNull InteractionData data2, @NotNull Kord kord, @NotNull EntitySupplier supplier) {
        ComponentInteraction componentInteraction;
        Intrinsics.checkNotNullParameter(data2, "data");
        Intrinsics.checkNotNullParameter(kord, "kord");
        Intrinsics.checkNotNullParameter(supplier, "supplier");
        boolean inGuild = data2.getGuildId().getValue() != null;
        ComponentType type = data2.getData().getComponentType().getValue();
        if (Intrinsics.areEqual(type, ComponentType.Button.INSTANCE)) {
            componentInteraction = inGuild ? (ButtonInteraction)new GuildButtonInteraction(data2, kord, supplier) : (ButtonInteraction)new GlobalButtonInteraction(data2, kord, supplier);
        } else if (Intrinsics.areEqual(type, ComponentType.SelectMenu.INSTANCE)) {
            componentInteraction = inGuild ? (SelectMenuInteraction)new GuildSelectMenuInteraction(data2, kord, supplier) : (SelectMenuInteraction)new GlobalSelectMenuInteraction(data2, kord, supplier);
        } else {
            if (Intrinsics.areEqual(type, ComponentType.TextInput.INSTANCE)) {
                throw new IllegalStateException("Text inputs can't have interactions".toString());
            }
            if (Intrinsics.areEqual(type, ComponentType.ActionRow.INSTANCE)) {
                throw new IllegalStateException("Action rows can't have interactions".toString());
            }
            if (type instanceof ComponentType.Unknown) {
                throw new IllegalStateException(("Unknown component type: " + ((ComponentType.Unknown)type).getValue()).toString());
            }
            if (type == null) {
                throw new IllegalStateException("Component type was null".toString());
            }
            throw new NoWhenBranchMatchedException();
        }
        return componentInteraction;
    }

    public static /* synthetic */ ComponentInteraction ComponentInteraction$default(InteractionData interactionData, Kord kord, EntitySupplier entitySupplier, int n, Object object) {
        if ((n & 4) != 0) {
            entitySupplier = kord.getDefaultSupplier();
        }
        return ComponentInteractionKt.ComponentInteraction(interactionData, kord, entitySupplier);
    }
}

