/*
 * Decompiled with CFR 0.152.
 */
package dev.kord.core.entity.interaction;

import dev.kord.common.entity.ApplicationCommandType;
import dev.kord.core.Kord;
import dev.kord.core.cache.data.InteractionData;
import dev.kord.core.entity.interaction.GlobalApplicationCommandInteraction;
import dev.kord.core.entity.interaction.GlobalChatInputCommandInteraction;
import dev.kord.core.entity.interaction.GlobalMessageCommandInteraction;
import dev.kord.core.entity.interaction.GlobalUserCommandInteraction;
import dev.kord.core.entity.interaction.GuildApplicationCommandInteraction;
import dev.kord.core.entity.interaction.GuildChatInputCommandInteraction;
import dev.kord.core.entity.interaction.GuildMessageCommandInteraction;
import dev.kord.core.entity.interaction.GuildUserCommandInteraction;
import dev.kord.core.supplier.EntitySupplier;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u001a \u0010\b\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\n"}, d2={"GlobalApplicationCommandInteraction", "Ldev/kord/core/entity/interaction/GlobalApplicationCommandInteraction;", "data", "Ldev/kord/core/cache/data/InteractionData;", "kord", "Ldev/kord/core/Kord;", "supplier", "Ldev/kord/core/supplier/EntitySupplier;", "GuildApplicationCommandInteraction", "Ldev/kord/core/entity/interaction/GuildApplicationCommandInteraction;", "core"})
public final class ApplicationCommandInteractionKt {
    @NotNull
    public static final GlobalApplicationCommandInteraction GlobalApplicationCommandInteraction(@NotNull InteractionData data2, @NotNull Kord kord, @NotNull EntitySupplier supplier) {
        GlobalApplicationCommandInteraction globalApplicationCommandInteraction;
        Intrinsics.checkNotNullParameter(data2, "data");
        Intrinsics.checkNotNullParameter(kord, "kord");
        Intrinsics.checkNotNullParameter(supplier, "supplier");
        ApplicationCommandType type = data2.getData().getType().getValue();
        if (Intrinsics.areEqual(type, ApplicationCommandType.ChatInput.INSTANCE)) {
            globalApplicationCommandInteraction = new GlobalChatInputCommandInteraction(data2, kord, supplier);
        } else if (Intrinsics.areEqual(type, ApplicationCommandType.User.INSTANCE)) {
            globalApplicationCommandInteraction = new GlobalUserCommandInteraction(data2, kord, supplier);
        } else if (Intrinsics.areEqual(type, ApplicationCommandType.Message.INSTANCE)) {
            globalApplicationCommandInteraction = new GlobalMessageCommandInteraction(data2, kord, supplier);
        } else {
            if (type instanceof ApplicationCommandType.Unknown) {
                throw new IllegalStateException(("Unknown application command type " + ((ApplicationCommandType.Unknown)type).getValue()).toString());
            }
            if (type == null) {
                throw new IllegalStateException("No application command type was provided".toString());
            }
            throw new NoWhenBranchMatchedException();
        }
        return globalApplicationCommandInteraction;
    }

    public static /* synthetic */ GlobalApplicationCommandInteraction GlobalApplicationCommandInteraction$default(InteractionData interactionData, Kord kord, EntitySupplier entitySupplier, int n, Object object) {
        if ((n & 4) != 0) {
            entitySupplier = kord.getDefaultSupplier();
        }
        return ApplicationCommandInteractionKt.GlobalApplicationCommandInteraction(interactionData, kord, entitySupplier);
    }

    @NotNull
    public static final GuildApplicationCommandInteraction GuildApplicationCommandInteraction(@NotNull InteractionData data2, @NotNull Kord kord, @NotNull EntitySupplier supplier) {
        GuildApplicationCommandInteraction guildApplicationCommandInteraction;
        Intrinsics.checkNotNullParameter(data2, "data");
        Intrinsics.checkNotNullParameter(kord, "kord");
        Intrinsics.checkNotNullParameter(supplier, "supplier");
        ApplicationCommandType type = data2.getData().getType().getValue();
        if (Intrinsics.areEqual(type, ApplicationCommandType.ChatInput.INSTANCE)) {
            guildApplicationCommandInteraction = new GuildChatInputCommandInteraction(data2, kord, supplier);
        } else if (Intrinsics.areEqual(type, ApplicationCommandType.User.INSTANCE)) {
            guildApplicationCommandInteraction = new GuildUserCommandInteraction(data2, kord, supplier);
        } else if (Intrinsics.areEqual(type, ApplicationCommandType.Message.INSTANCE)) {
            guildApplicationCommandInteraction = new GuildMessageCommandInteraction(data2, kord, supplier);
        } else {
            if (type instanceof ApplicationCommandType.Unknown) {
                throw new IllegalStateException(("Unknown application command type " + ((ApplicationCommandType.Unknown)type).getValue()).toString());
            }
            if (type == null) {
                throw new IllegalStateException("No application command type was provided".toString());
            }
            throw new NoWhenBranchMatchedException();
        }
        return guildApplicationCommandInteraction;
    }

    public static /* synthetic */ GuildApplicationCommandInteraction GuildApplicationCommandInteraction$default(InteractionData interactionData, Kord kord, EntitySupplier entitySupplier, int n, Object object) {
        if ((n & 4) != 0) {
            entitySupplier = kord.getDefaultSupplier();
        }
        return ApplicationCommandInteractionKt.GuildApplicationCommandInteraction(interactionData, kord, entitySupplier);
    }
}

