/*
 * Decompiled with CFR 0.152.
 */
package dev.kord.core.entity.component;

import dev.kord.common.entity.ComponentType;
import dev.kord.common.entity.TextInputStyle;
import dev.kord.common.entity.optional.OptionalIntKt;
import dev.kord.core.cache.data.TextInputComponentData;
import dev.kord.core.entity.component.Component;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010#\u001a\u00020\u0006H\u0016R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\bR\u0013\u0010\r\u001a\u0004\u0018\u00010\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0011\u001a\u0004\u0018\u00010\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010R\u0013\u0010\u0013\u001a\u0004\u0018\u00010\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\bR\u0011\u0010\u0015\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u001e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0013\u0010!\u001a\u0004\u0018\u00010\u00068F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\b\u00a8\u0006$"}, d2={"Ldev/kord/core/entity/component/TextInputComponent;", "Ldev/kord/core/entity/component/Component;", "data", "Ldev/kord/core/cache/data/TextInputComponentData;", "(Ldev/kord/core/cache/data/TextInputComponentData;)V", "customId", "", "getCustomId", "()Ljava/lang/String;", "getData", "()Ldev/kord/core/cache/data/TextInputComponentData;", "label", "getLabel", "maxLength", "", "getMaxLength", "()Ljava/lang/Integer;", "minLength", "getMinLength", "placeholder", "getPlaceholder", "required", "", "getRequired", "()Z", "style", "Ldev/kord/common/entity/TextInputStyle;", "getStyle", "()Ldev/kord/common/entity/TextInputStyle;", "type", "Ldev/kord/common/entity/ComponentType$TextInput;", "getType", "()Ldev/kord/common/entity/ComponentType$TextInput;", "value", "getValue", "toString", "core"})
public final class TextInputComponent
implements Component {
    @NotNull
    private final TextInputComponentData data;

    public TextInputComponent(@NotNull TextInputComponentData data2) {
        Intrinsics.checkNotNullParameter(data2, "data");
        this.data = data2;
    }

    @Override
    @NotNull
    public TextInputComponentData getData() {
        return this.data;
    }

    @Override
    @NotNull
    public ComponentType.TextInput getType() {
        return ComponentType.TextInput.INSTANCE;
    }

    @NotNull
    public final TextInputStyle getStyle() {
        TextInputStyle textInputStyle = this.getData().getStyle().getValue();
        Intrinsics.checkNotNull(textInputStyle);
        return textInputStyle;
    }

    @NotNull
    public final String getLabel() {
        String string2 = this.getData().getLabel().getValue();
        Intrinsics.checkNotNull(string2);
        return string2;
    }

    @NotNull
    public final String getCustomId() {
        String string2 = this.getData().getCustomId().getValue();
        Intrinsics.checkNotNull(string2);
        return string2;
    }

    @Nullable
    public final Integer getMinLength() {
        return OptionalIntKt.getValue(this.getData().getMinLength());
    }

    @Nullable
    public final Integer getMaxLength() {
        return OptionalIntKt.getValue(this.getData().getMaxLength());
    }

    public final boolean getRequired() {
        return this.getData().getRequired().orElse(true);
    }

    @Nullable
    public final String getValue() {
        return this.getData().getValue().getValue();
    }

    @Nullable
    public final String getPlaceholder() {
        return this.getData().getPlaceholder().getValue();
    }

    @NotNull
    public String toString() {
        return "TextInputComponent(data=" + this.getData() + ')';
    }
}

