/*
 * Decompiled with CFR 0.152.
 */
package dev.kord.core.entity.channel;

import dev.kord.common.entity.ChannelType;
import dev.kord.common.entity.Permissions;
import dev.kord.common.entity.Snowflake;
import dev.kord.common.entity.optional.OptionalIntKt;
import dev.kord.core.Kord;
import dev.kord.core.behavior.GuildBehavior;
import dev.kord.core.behavior.channel.CategoryBehavior;
import dev.kord.core.behavior.channel.ChannelBehavior;
import dev.kord.core.behavior.channel.GuildChannelBehavior;
import dev.kord.core.behavior.channel.StageChannelBehavior;
import dev.kord.core.cache.data.ChannelData;
import dev.kord.core.entity.Entity;
import dev.kord.core.entity.Guild;
import dev.kord.core.entity.InviteWithMetadata;
import dev.kord.core.entity.PermissionOverwrite;
import dev.kord.core.entity.PermissionOverwriteEntity;
import dev.kord.core.entity.StageInstance;
import dev.kord.core.entity.VoiceState;
import dev.kord.core.entity.channel.CategorizableChannel;
import dev.kord.core.supplier.EntitySupplier;
import dev.kord.core.supplier.EntitySupplyStrategy;
import java.util.Objects;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0011\u0010\u0016\u001a\u00020\u0000H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0017J\u0011\u0010\u0018\u001a\u00020\u0000H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0017J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0096\u0002J\b\u0010\u001d\u001a\u00020\u000bH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\u0014\u0010 \u001a\u00020\u00002\n\u0010!\u001a\u0006\u0012\u0002\b\u00030\"H\u0016R\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\r\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006#"}, d2={"Ldev/kord/core/entity/channel/StageChannel;", "Ldev/kord/core/entity/channel/CategorizableChannel;", "Ldev/kord/core/behavior/channel/StageChannelBehavior;", "data", "Ldev/kord/core/cache/data/ChannelData;", "kord", "Ldev/kord/core/Kord;", "supplier", "Ldev/kord/core/supplier/EntitySupplier;", "(Ldev/kord/core/cache/data/ChannelData;Ldev/kord/core/Kord;Ldev/kord/core/supplier/EntitySupplier;)V", "bitrate", "", "getBitrate", "()I", "getData", "()Ldev/kord/core/cache/data/ChannelData;", "getKord", "()Ldev/kord/core/Kord;", "getSupplier", "()Ldev/kord/core/supplier/EntitySupplier;", "userLimit", "getUserLimit", "asChannel", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "asChannelOrNull", "equals", "", "other", "", "hashCode", "toString", "", "withStrategy", "strategy", "Ldev/kord/core/supplier/EntitySupplyStrategy;", "core"})
public final class StageChannel
implements CategorizableChannel,
StageChannelBehavior {
    @NotNull
    private final ChannelData data;
    @NotNull
    private final Kord kord;
    @NotNull
    private final EntitySupplier supplier;

    public StageChannel(@NotNull ChannelData data2, @NotNull Kord kord, @NotNull EntitySupplier supplier) {
        Intrinsics.checkNotNullParameter(data2, "data");
        Intrinsics.checkNotNullParameter(kord, "kord");
        Intrinsics.checkNotNullParameter(supplier, "supplier");
        this.data = data2;
        this.kord = kord;
        this.supplier = supplier;
    }

    public /* synthetic */ StageChannel(ChannelData channelData, Kord kord, EntitySupplier entitySupplier, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            entitySupplier = kord.getDefaultSupplier();
        }
        this(channelData, kord, entitySupplier);
    }

    @Override
    @NotNull
    public ChannelData getData() {
        return this.data;
    }

    @Override
    @NotNull
    public Kord getKord() {
        return this.kord;
    }

    @Override
    @NotNull
    public EntitySupplier getSupplier() {
        return this.supplier;
    }

    public final int getBitrate() {
        return OptionalIntKt.getOrThrow(this.getData().getBitrate());
    }

    public final int getUserLimit() {
        return OptionalIntKt.getOrThrow(this.getData().getUserLimit());
    }

    @Override
    @NotNull
    public StageChannel withStrategy(@NotNull EntitySupplyStrategy<?> strategy) {
        Intrinsics.checkNotNullParameter(strategy, "strategy");
        return new StageChannel(this.getData(), this.getKord(), (EntitySupplier)strategy.supply(this.getKord()));
    }

    @Nullable
    public Object asChannel(@NotNull Continuation<? super StageChannel> $completion) {
        return this;
    }

    @Nullable
    public Object asChannelOrNull(@NotNull Continuation<? super StageChannel> $completion) {
        return this;
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.getId(), this.getGuildId()};
        return Objects.hash(objectArray);
    }

    public boolean equals(@Nullable Object other) {
        Object object = other;
        return object instanceof GuildChannelBehavior ? Intrinsics.areEqual(((GuildChannelBehavior)other).getId(), this.getId()) && Intrinsics.areEqual(((GuildChannelBehavior)other).getGuildId(), this.getGuildId()) : (object instanceof ChannelBehavior ? Intrinsics.areEqual(((ChannelBehavior)other).getId(), this.getId()) : false);
    }

    @NotNull
    public String toString() {
        return "StageChannel(data=" + this.getData() + ", kord=" + this.getKord() + ", supplier=" + this.getSupplier() + ')';
    }

    @Override
    @Nullable
    public Snowflake getCategoryId() {
        return CategorizableChannel.DefaultImpls.getCategoryId(this);
    }

    @Override
    @Nullable
    public CategoryBehavior getCategory() {
        return CategorizableChannel.DefaultImpls.getCategory(this);
    }

    @Override
    @NotNull
    public Snowflake getGuildId() {
        return CategorizableChannel.DefaultImpls.getGuildId(this);
    }

    @Override
    public int getRawPosition() {
        return CategorizableChannel.DefaultImpls.getRawPosition(this);
    }

    @Override
    @NotNull
    public Set<PermissionOverwriteEntity> getPermissionOverwrites() {
        return CategorizableChannel.DefaultImpls.getPermissionOverwrites(this);
    }

    @Override
    @Nullable
    public Object getEffectivePermissions(@NotNull Snowflake memberId, @NotNull Continuation<? super Permissions> $completion) {
        return CategorizableChannel.DefaultImpls.getEffectivePermissions(this, memberId, $completion);
    }

    @Override
    @Nullable
    public PermissionOverwriteEntity getPermissionOverwritesForMember(@NotNull Snowflake memberId) {
        return CategorizableChannel.DefaultImpls.getPermissionOverwritesForMember(this, memberId);
    }

    @Override
    @Nullable
    public PermissionOverwriteEntity getPermissionOverwritesForRole(@NotNull Snowflake roleId) {
        return CategorizableChannel.DefaultImpls.getPermissionOverwritesForRole(this, roleId);
    }

    @Override
    @NotNull
    public String getName() {
        return CategorizableChannel.DefaultImpls.getName(this);
    }

    @Override
    @NotNull
    public Snowflake getId() {
        return CategorizableChannel.DefaultImpls.getId(this);
    }

    @Override
    @NotNull
    public ChannelType getType() {
        return CategorizableChannel.DefaultImpls.getType(this);
    }

    @Override
    @NotNull
    public String getMention() {
        return CategorizableChannel.DefaultImpls.getMention(this);
    }

    @Override
    @Nullable
    public Object fetchChannel(@NotNull Continuation<? super CategorizableChannel> $completion) {
        return CategorizableChannel.DefaultImpls.fetchChannel(this, $completion);
    }

    @Override
    @Nullable
    public Object fetchChannelOrNull(@NotNull Continuation<? super CategorizableChannel> $completion) {
        return CategorizableChannel.DefaultImpls.fetchChannelOrNull(this, $completion);
    }

    @Override
    @Nullable
    public Object delete(@Nullable String reason2, @NotNull Continuation<? super Unit> $completion) {
        return CategorizableChannel.DefaultImpls.delete(this, reason2, $completion);
    }

    @Override
    public int compareTo(@NotNull Entity other) {
        return CategorizableChannel.DefaultImpls.compareTo(this, other);
    }

    @Override
    @NotNull
    public GuildBehavior getGuild() {
        return CategorizableChannel.DefaultImpls.getGuild(this);
    }

    @Override
    @Nullable
    public Object getGuild(@NotNull Continuation<? super Guild> $completion) {
        return CategorizableChannel.DefaultImpls.getGuild(this, $completion);
    }

    @Override
    @Nullable
    public Object getGuildOrNull(@NotNull Continuation<? super Guild> $completion) {
        return CategorizableChannel.DefaultImpls.getGuildOrNull(this, $completion);
    }

    @Override
    @Nullable
    public Object addOverwrite(@NotNull PermissionOverwrite overwrite, @Nullable String reason2, @NotNull Continuation<? super Unit> $completion) {
        return CategorizableChannel.DefaultImpls.addOverwrite(this, overwrite, reason2, $completion);
    }

    @Override
    @Nullable
    public Object getPosition(@NotNull Continuation<? super Integer> $completion) {
        return CategorizableChannel.DefaultImpls.getPosition(this, $completion);
    }

    @Override
    @NotNull
    public Flow<InviteWithMetadata> getInvites() {
        return CategorizableChannel.DefaultImpls.getInvites(this);
    }

    @Override
    @Nullable
    public Object getStageInstanceOrNull(@NotNull Continuation<? super StageInstance> $completion) {
        return StageChannelBehavior.DefaultImpls.getStageInstanceOrNull(this, $completion);
    }

    @Override
    @Nullable
    public Object getStageInstance(@NotNull Continuation<? super StageInstance> $completion) {
        return StageChannelBehavior.DefaultImpls.getStageInstance(this, $completion);
    }

    @Override
    @NotNull
    public Flow<VoiceState> getVoiceStates() {
        return StageChannelBehavior.DefaultImpls.getVoiceStates(this);
    }
}

