/*
 * Decompiled with CFR 0.152.
 */
package dev.kord.core.entity.channel;

import dev.kord.common.entity.ChannelType;
import dev.kord.common.entity.Snowflake;
import dev.kord.common.entity.optional.OptionalSnowflakeKt;
import dev.kord.core.behavior.MessageBehavior;
import dev.kord.core.behavior.MessageBehaviorKt;
import dev.kord.core.behavior.channel.MessageChannelBehavior;
import dev.kord.core.entity.Entity;
import dev.kord.core.entity.Message;
import dev.kord.core.entity.channel.Channel;
import dev.kord.core.supplier.EntitySupplyStrategy;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.TimeMark;
import kotlinx.coroutines.flow.Flow;
import kotlinx.datetime.Instant;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u00012\u00020\u0002J\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u000fH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0010J\u0014\u0010\u0011\u001a\u00020\u00002\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0013H&R\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0016\u0010\u000b\u001a\u0004\u0018\u00010\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0014"}, d2={"Ldev/kord/core/entity/channel/MessageChannel;", "Ldev/kord/core/entity/channel/Channel;", "Ldev/kord/core/behavior/channel/MessageChannelBehavior;", "lastMessage", "Ldev/kord/core/behavior/MessageBehavior;", "getLastMessage", "()Ldev/kord/core/behavior/MessageBehavior;", "lastMessageId", "Ldev/kord/common/entity/Snowflake;", "getLastMessageId", "()Ldev/kord/common/entity/Snowflake;", "lastPinTimestamp", "Lkotlinx/datetime/Instant;", "getLastPinTimestamp", "()Lkotlinx/datetime/Instant;", "Ldev/kord/core/entity/Message;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "withStrategy", "strategy", "Ldev/kord/core/supplier/EntitySupplyStrategy;", "core"})
public interface MessageChannel
extends Channel,
MessageChannelBehavior {
    @Nullable
    public Snowflake getLastMessageId();

    @Nullable
    public MessageBehavior getLastMessage();

    @Nullable
    public Instant getLastPinTimestamp();

    @Nullable
    public Object getLastMessage(@NotNull Continuation<? super Message> var1);

    @Override
    @NotNull
    public MessageChannel withStrategy(@NotNull EntitySupplyStrategy<?> var1);

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        @Nullable
        public static Snowflake getLastMessageId(@NotNull MessageChannel $this) {
            return OptionalSnowflakeKt.getValue($this.getData().getLastMessageId());
        }

        @Nullable
        public static MessageBehavior getLastMessage(@NotNull MessageChannel $this) {
            MessageBehavior messageBehavior;
            Snowflake snowflake = $this.getLastMessageId();
            if (snowflake != null) {
                Snowflake it = snowflake;
                boolean bl = false;
                messageBehavior = MessageBehaviorKt.MessageBehavior$default($this.getId(), it, $this.getKord(), null, 8, null);
            } else {
                messageBehavior = null;
            }
            return messageBehavior;
        }

        @Nullable
        public static Instant getLastPinTimestamp(@NotNull MessageChannel $this) {
            return $this.getData().getLastPinTimestamp().getValue();
        }

        @Nullable
        public static Object getLastMessage(@NotNull MessageChannel $this, @NotNull Continuation<? super Message> $completion) {
            Snowflake snowflake = $this.getLastMessageId();
            if (snowflake == null) {
                return null;
            }
            Snowflake messageId = snowflake;
            return $this.getSupplier().getMessageOrNull($this.getId(), messageId, $completion);
        }

        @NotNull
        public static Snowflake getId(@NotNull MessageChannel $this) {
            return Channel.DefaultImpls.getId($this);
        }

        @NotNull
        public static ChannelType getType(@NotNull MessageChannel $this) {
            return Channel.DefaultImpls.getType($this);
        }

        @NotNull
        public static String getMention(@NotNull MessageChannel $this) {
            return Channel.DefaultImpls.getMention($this);
        }

        @Nullable
        public static Object asChannel(@NotNull MessageChannel $this, @NotNull Continuation<? super MessageChannel> $completion) {
            return MessageChannelBehavior.DefaultImpls.asChannel($this, $completion);
        }

        @Nullable
        public static Object asChannelOrNull(@NotNull MessageChannel $this, @NotNull Continuation<? super MessageChannel> $completion) {
            return MessageChannelBehavior.DefaultImpls.asChannelOrNull($this, $completion);
        }

        @Nullable
        public static Object fetchChannel(@NotNull MessageChannel $this, @NotNull Continuation<? super MessageChannel> $completion) {
            return MessageChannelBehavior.DefaultImpls.fetchChannel($this, $completion);
        }

        @Nullable
        public static Object fetchChannelOrNull(@NotNull MessageChannel $this, @NotNull Continuation<? super MessageChannel> $completion) {
            return MessageChannelBehavior.DefaultImpls.fetchChannelOrNull($this, $completion);
        }

        @Nullable
        public static Object delete(@NotNull MessageChannel $this, @Nullable String reason2, @NotNull Continuation<? super Unit> $completion) {
            Object object = Channel.DefaultImpls.delete($this, reason2, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }

        public static int compareTo(@NotNull MessageChannel $this, @NotNull Entity other) {
            Intrinsics.checkNotNullParameter(other, "other");
            return Channel.DefaultImpls.compareTo($this, other);
        }

        @NotNull
        public static Flow<Message> getMessages(@NotNull MessageChannel $this) {
            return MessageChannelBehavior.DefaultImpls.getMessages($this);
        }

        @NotNull
        public static Flow<Message> getPinnedMessages(@NotNull MessageChannel $this) {
            return MessageChannelBehavior.DefaultImpls.getPinnedMessages($this);
        }

        @Nullable
        public static Object createMessage(@NotNull MessageChannel $this, @NotNull String content2, @NotNull Continuation<? super Message> $completion) {
            return MessageChannelBehavior.DefaultImpls.createMessage($this, content2, $completion);
        }

        @Nullable
        public static Object deleteMessage(@NotNull MessageChannel $this, @NotNull Snowflake id, @Nullable String reason2, @NotNull Continuation<? super Unit> $completion) {
            Object object = MessageChannelBehavior.DefaultImpls.deleteMessage($this, id, reason2, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }

        @NotNull
        public static Flow<Message> getMessagesBefore(@NotNull MessageChannel $this, @NotNull Snowflake messageId, @Nullable Integer limit2) {
            Intrinsics.checkNotNullParameter(messageId, "messageId");
            return MessageChannelBehavior.DefaultImpls.getMessagesBefore($this, messageId, limit2);
        }

        @NotNull
        public static Flow<Message> getMessagesAfter(@NotNull MessageChannel $this, @NotNull Snowflake messageId, @Nullable Integer limit2) {
            Intrinsics.checkNotNullParameter(messageId, "messageId");
            return MessageChannelBehavior.DefaultImpls.getMessagesAfter($this, messageId, limit2);
        }

        @NotNull
        public static Flow<Message> getMessagesAround(@NotNull MessageChannel $this, @NotNull Snowflake messageId, int limit2) {
            Intrinsics.checkNotNullParameter(messageId, "messageId");
            return MessageChannelBehavior.DefaultImpls.getMessagesAround($this, messageId, limit2);
        }

        @Nullable
        public static Object getMessage(@NotNull MessageChannel $this, @NotNull Snowflake messageId, @NotNull Continuation<? super Message> $completion) {
            return MessageChannelBehavior.DefaultImpls.getMessage($this, messageId, $completion);
        }

        @Nullable
        public static Object getMessageOrNull(@NotNull MessageChannel $this, @NotNull Snowflake messageId, @NotNull Continuation<? super Message> $completion) {
            return MessageChannelBehavior.DefaultImpls.getMessageOrNull($this, messageId, $completion);
        }

        @Nullable
        public static Object type(@NotNull MessageChannel $this, @NotNull Continuation<? super Unit> $completion) {
            Object object = MessageChannelBehavior.DefaultImpls.type($this, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }

        @Nullable
        public static Object typeUntil(@NotNull MessageChannel $this, @NotNull TimeMark mark, @NotNull Continuation<? super Unit> $completion) {
            Object object = MessageChannelBehavior.DefaultImpls.typeUntil((MessageChannelBehavior)$this, mark, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }

        @Nullable
        public static Object typeUntil(@NotNull MessageChannel $this, @NotNull Instant instant, @NotNull Continuation<? super Unit> $completion) {
            Object object = MessageChannelBehavior.DefaultImpls.typeUntil((MessageChannelBehavior)$this, instant, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
    }
}

