/*
 * Decompiled with CFR 0.152.
 */
package dev.kord.core.entity.channel;

import dev.kord.common.entity.ChannelType;
import dev.kord.common.entity.Permissions;
import dev.kord.common.entity.Snowflake;
import dev.kord.common.entity.optional.OptionalSnowflakeKt;
import dev.kord.core.Kord;
import dev.kord.core.behavior.GuildBehavior;
import dev.kord.core.behavior.channel.CategorizableChannelBehavior;
import dev.kord.core.behavior.channel.CategoryBehavior;
import dev.kord.core.behavior.channel.CategoryBehaviorKt;
import dev.kord.core.entity.Entity;
import dev.kord.core.entity.Guild;
import dev.kord.core.entity.InviteWithMetadata;
import dev.kord.core.entity.PermissionOverwrite;
import dev.kord.core.entity.PermissionOverwriteEntity;
import dev.kord.core.entity.channel.TopGuildChannel;
import dev.kord.core.supplier.EntitySupplyStrategy;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u00012\u00020\u0002J\u0014\u0010\u000b\u001a\u00020\u00002\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rH&R\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000e"}, d2={"Ldev/kord/core/entity/channel/CategorizableChannel;", "Ldev/kord/core/entity/channel/TopGuildChannel;", "Ldev/kord/core/behavior/channel/CategorizableChannelBehavior;", "category", "Ldev/kord/core/behavior/channel/CategoryBehavior;", "getCategory", "()Ldev/kord/core/behavior/channel/CategoryBehavior;", "categoryId", "Ldev/kord/common/entity/Snowflake;", "getCategoryId", "()Ldev/kord/common/entity/Snowflake;", "withStrategy", "strategy", "Ldev/kord/core/supplier/EntitySupplyStrategy;", "core"})
public interface CategorizableChannel
extends TopGuildChannel,
CategorizableChannelBehavior {
    @Nullable
    public Snowflake getCategoryId();

    @Nullable
    public CategoryBehavior getCategory();

    @Override
    @NotNull
    public CategorizableChannel withStrategy(@NotNull EntitySupplyStrategy<?> var1);

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        @Nullable
        public static Snowflake getCategoryId(@NotNull CategorizableChannel $this) {
            return OptionalSnowflakeKt.getValue($this.getData().getParentId());
        }

        @Nullable
        public static CategoryBehavior getCategory(@NotNull CategorizableChannel $this) {
            CategoryBehavior categoryBehavior;
            Snowflake categoryId = $this.getCategoryId();
            if (categoryId != null) {
                Snowflake snowflake = $this.getGuildId();
                Kord kord = $this.getKord();
                categoryBehavior = CategoryBehaviorKt.CategoryBehavior$default(snowflake, categoryId, kord, null, 8, null);
            } else {
                categoryBehavior = null;
            }
            return categoryBehavior;
        }

        @NotNull
        public static Snowflake getGuildId(@NotNull CategorizableChannel $this) {
            return TopGuildChannel.DefaultImpls.getGuildId($this);
        }

        public static int getRawPosition(@NotNull CategorizableChannel $this) {
            return TopGuildChannel.DefaultImpls.getRawPosition($this);
        }

        @NotNull
        public static Set<PermissionOverwriteEntity> getPermissionOverwrites(@NotNull CategorizableChannel $this) {
            return TopGuildChannel.DefaultImpls.getPermissionOverwrites($this);
        }

        @Nullable
        public static Object getEffectivePermissions(@NotNull CategorizableChannel $this, @NotNull Snowflake memberId, @NotNull Continuation<? super Permissions> $completion) {
            return TopGuildChannel.DefaultImpls.getEffectivePermissions($this, memberId, $completion);
        }

        @Nullable
        public static PermissionOverwriteEntity getPermissionOverwritesForMember(@NotNull CategorizableChannel $this, @NotNull Snowflake memberId) {
            Intrinsics.checkNotNullParameter(memberId, "memberId");
            return TopGuildChannel.DefaultImpls.getPermissionOverwritesForMember($this, memberId);
        }

        @Nullable
        public static PermissionOverwriteEntity getPermissionOverwritesForRole(@NotNull CategorizableChannel $this, @NotNull Snowflake roleId) {
            Intrinsics.checkNotNullParameter(roleId, "roleId");
            return TopGuildChannel.DefaultImpls.getPermissionOverwritesForRole($this, roleId);
        }

        @NotNull
        public static String getName(@NotNull CategorizableChannel $this) {
            return TopGuildChannel.DefaultImpls.getName($this);
        }

        @NotNull
        public static Snowflake getId(@NotNull CategorizableChannel $this) {
            return TopGuildChannel.DefaultImpls.getId($this);
        }

        @NotNull
        public static ChannelType getType(@NotNull CategorizableChannel $this) {
            return TopGuildChannel.DefaultImpls.getType($this);
        }

        @NotNull
        public static String getMention(@NotNull CategorizableChannel $this) {
            return TopGuildChannel.DefaultImpls.getMention($this);
        }

        @Nullable
        public static Object asChannel(@NotNull CategorizableChannel $this, @NotNull Continuation<? super CategorizableChannel> $completion) {
            return CategorizableChannelBehavior.DefaultImpls.asChannel($this, $completion);
        }

        @Nullable
        public static Object asChannelOrNull(@NotNull CategorizableChannel $this, @NotNull Continuation<? super CategorizableChannel> $completion) {
            return CategorizableChannelBehavior.DefaultImpls.asChannelOrNull($this, $completion);
        }

        @Nullable
        public static Object fetchChannel(@NotNull CategorizableChannel $this, @NotNull Continuation<? super CategorizableChannel> $completion) {
            return CategorizableChannelBehavior.DefaultImpls.fetchChannel($this, $completion);
        }

        @Nullable
        public static Object fetchChannelOrNull(@NotNull CategorizableChannel $this, @NotNull Continuation<? super CategorizableChannel> $completion) {
            return CategorizableChannelBehavior.DefaultImpls.fetchChannelOrNull($this, $completion);
        }

        @Nullable
        public static Object delete(@NotNull CategorizableChannel $this, @Nullable String reason2, @NotNull Continuation<? super Unit> $completion) {
            Object object = TopGuildChannel.DefaultImpls.delete($this, reason2, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }

        public static int compareTo(@NotNull CategorizableChannel $this, @NotNull Entity other) {
            Intrinsics.checkNotNullParameter(other, "other");
            return TopGuildChannel.DefaultImpls.compareTo($this, other);
        }

        @NotNull
        public static GuildBehavior getGuild(@NotNull CategorizableChannel $this) {
            return TopGuildChannel.DefaultImpls.getGuild($this);
        }

        @Nullable
        public static Object getGuild(@NotNull CategorizableChannel $this, @NotNull Continuation<? super Guild> $completion) {
            return TopGuildChannel.DefaultImpls.getGuild($this, $completion);
        }

        @Nullable
        public static Object getGuildOrNull(@NotNull CategorizableChannel $this, @NotNull Continuation<? super Guild> $completion) {
            return TopGuildChannel.DefaultImpls.getGuildOrNull($this, $completion);
        }

        @Nullable
        public static Object addOverwrite(@NotNull CategorizableChannel $this, @NotNull PermissionOverwrite overwrite, @Nullable String reason2, @NotNull Continuation<? super Unit> $completion) {
            Object object = TopGuildChannel.DefaultImpls.addOverwrite($this, overwrite, reason2, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }

        @Nullable
        public static Object getPosition(@NotNull CategorizableChannel $this, @NotNull Continuation<? super Integer> $completion) {
            return TopGuildChannel.DefaultImpls.getPosition($this, $completion);
        }

        @NotNull
        public static Flow<InviteWithMetadata> getInvites(@NotNull CategorizableChannel $this) {
            return CategorizableChannelBehavior.DefaultImpls.getInvites($this);
        }
    }
}

