/*
 * Decompiled with CFR 0.152.
 */
package dev.kord.core.entity.automoderation;

import dev.kord.common.entity.AutoModerationRuleTriggerType;
import dev.kord.core.Kord;
import dev.kord.core.cache.data.AutoModerationRuleData;
import dev.kord.core.entity.automoderation.AutoModerationRule;
import dev.kord.core.entity.automoderation.KeywordAutoModerationRule;
import dev.kord.core.entity.automoderation.KeywordPresetAutoModerationRule;
import dev.kord.core.entity.automoderation.MentionSpamAutoModerationRule;
import dev.kord.core.entity.automoderation.SpamAutoModerationRule;
import dev.kord.core.entity.automoderation.UnknownAutoModerationRule;
import dev.kord.core.supplier.EntitySupplier;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.PublishedApi;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\"\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u0001\u00a8\u0006\b"}, d2={"AutoModerationRule", "Ldev/kord/core/entity/automoderation/AutoModerationRule;", "data", "Ldev/kord/core/cache/data/AutoModerationRuleData;", "kord", "Ldev/kord/core/Kord;", "supplier", "Ldev/kord/core/supplier/EntitySupplier;", "core"})
public final class AutoModerationRuleKt {
    @PublishedApi
    @NotNull
    public static final AutoModerationRule AutoModerationRule(@NotNull AutoModerationRuleData data2, @NotNull Kord kord, @NotNull EntitySupplier supplier) {
        AutoModerationRule autoModerationRule;
        Intrinsics.checkNotNullParameter(data2, "data");
        Intrinsics.checkNotNullParameter(kord, "kord");
        Intrinsics.checkNotNullParameter(supplier, "supplier");
        AutoModerationRuleTriggerType autoModerationRuleTriggerType = data2.getTriggerType();
        if (Intrinsics.areEqual(autoModerationRuleTriggerType, AutoModerationRuleTriggerType.Keyword.INSTANCE)) {
            autoModerationRule = new KeywordAutoModerationRule(data2, kord, supplier);
        } else if (Intrinsics.areEqual(autoModerationRuleTriggerType, AutoModerationRuleTriggerType.Spam.INSTANCE)) {
            autoModerationRule = new SpamAutoModerationRule(data2, kord, supplier);
        } else if (Intrinsics.areEqual(autoModerationRuleTriggerType, AutoModerationRuleTriggerType.KeywordPreset.INSTANCE)) {
            autoModerationRule = new KeywordPresetAutoModerationRule(data2, kord, supplier);
        } else if (Intrinsics.areEqual(autoModerationRuleTriggerType, AutoModerationRuleTriggerType.MentionSpam.INSTANCE)) {
            autoModerationRule = new MentionSpamAutoModerationRule(data2, kord, supplier);
        } else if (autoModerationRuleTriggerType instanceof AutoModerationRuleTriggerType.Unknown) {
            autoModerationRule = new UnknownAutoModerationRule(data2, kord, supplier);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return autoModerationRule;
    }

    public static /* synthetic */ AutoModerationRule AutoModerationRule$default(AutoModerationRuleData autoModerationRuleData, Kord kord, EntitySupplier entitySupplier, int n, Object object) {
        if ((n & 4) != 0) {
            entitySupplier = kord.getDefaultSupplier();
        }
        return AutoModerationRuleKt.AutoModerationRule(autoModerationRuleData, kord, entitySupplier);
    }
}

