/*
 * Decompiled with CFR 0.152.
 */
package dev.kord.core.entity.application;

import dev.kord.common.entity.ApplicationCommandType;
import dev.kord.core.cache.data.ApplicationCommandData;
import dev.kord.core.entity.application.GlobalApplicationCommand;
import dev.kord.core.entity.application.GlobalChatInputCommand;
import dev.kord.core.entity.application.GlobalMessageCommand;
import dev.kord.core.entity.application.GlobalUserCommand;
import dev.kord.core.entity.application.GuildApplicationCommand;
import dev.kord.core.entity.application.GuildChatInputCommand;
import dev.kord.core.entity.application.GuildMessageCommand;
import dev.kord.core.entity.application.GuildUserCommand;
import dev.kord.core.entity.application.UnknownGlobalApplicationCommand;
import dev.kord.core.entity.application.UnknownGuildApplicationCommand;
import dev.kord.rest.service.InteractionService;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\b"}, d2={"GlobalApplicationCommand", "Ldev/kord/core/entity/application/GlobalApplicationCommand;", "data", "Ldev/kord/core/cache/data/ApplicationCommandData;", "service", "Ldev/kord/rest/service/InteractionService;", "GuildApplicationCommand", "Ldev/kord/core/entity/application/GuildApplicationCommand;", "core"})
public final class ApplicationCommandKt {
    @NotNull
    public static final GlobalApplicationCommand GlobalApplicationCommand(@NotNull ApplicationCommandData data2, @NotNull InteractionService service) {
        GlobalApplicationCommand globalApplicationCommand;
        Intrinsics.checkNotNullParameter(data2, "data");
        Intrinsics.checkNotNullParameter(service, "service");
        ApplicationCommandType applicationCommandType = data2.getType().getValue();
        if (Intrinsics.areEqual(applicationCommandType, ApplicationCommandType.ChatInput.INSTANCE)) {
            globalApplicationCommand = new GlobalChatInputCommand(data2, service);
        } else if (Intrinsics.areEqual(applicationCommandType, ApplicationCommandType.Message.INSTANCE)) {
            globalApplicationCommand = new GlobalMessageCommand(data2, service);
        } else if (Intrinsics.areEqual(applicationCommandType, ApplicationCommandType.User.INSTANCE)) {
            globalApplicationCommand = new GlobalUserCommand(data2, service);
        } else if (applicationCommandType instanceof ApplicationCommandType.Unknown) {
            globalApplicationCommand = new UnknownGlobalApplicationCommand(data2, service);
        } else {
            if (applicationCommandType == null) {
                throw new IllegalStateException("The type value is missing, can't determine the type".toString());
            }
            throw new NoWhenBranchMatchedException();
        }
        return globalApplicationCommand;
    }

    @NotNull
    public static final GuildApplicationCommand GuildApplicationCommand(@NotNull ApplicationCommandData data2, @NotNull InteractionService service) {
        GuildApplicationCommand guildApplicationCommand;
        Intrinsics.checkNotNullParameter(data2, "data");
        Intrinsics.checkNotNullParameter(service, "service");
        ApplicationCommandType applicationCommandType = data2.getType().getValue();
        if (Intrinsics.areEqual(applicationCommandType, ApplicationCommandType.ChatInput.INSTANCE)) {
            guildApplicationCommand = new GuildChatInputCommand(data2, service);
        } else if (Intrinsics.areEqual(applicationCommandType, ApplicationCommandType.Message.INSTANCE)) {
            guildApplicationCommand = new GuildMessageCommand(data2, service);
        } else if (Intrinsics.areEqual(applicationCommandType, ApplicationCommandType.User.INSTANCE)) {
            guildApplicationCommand = new GuildUserCommand(data2, service);
        } else if (applicationCommandType instanceof ApplicationCommandType.Unknown) {
            guildApplicationCommand = new UnknownGuildApplicationCommand(data2, service);
        } else {
            if (applicationCommandType == null) {
                throw new IllegalStateException("The type value is missing, can't determine the type".toString());
            }
            throw new NoWhenBranchMatchedException();
        }
        return guildApplicationCommand;
    }
}

