/*
 * Decompiled with CFR 0.152.
 */
package dev.kord.core.entity;

import dev.kord.common.Color;
import dev.kord.common.entity.Snowflake;
import dev.kord.common.entity.UserFlags;
import dev.kord.core.Kord;
import dev.kord.core.KordObject;
import dev.kord.core.behavior.UserBehavior;
import dev.kord.core.cache.data.UserData;
import dev.kord.core.entity.Entity;
import dev.kord.core.entity.Icon;
import dev.kord.core.entity.Member;
import dev.kord.core.entity.channel.DmChannel;
import dev.kord.core.supplier.EntitySupplier;
import dev.kord.core.supplier.EntitySupplyStrategy;
import dev.kord.rest.Image;
import kotlin.Metadata;
import kotlin.ULong;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001:\u0001;B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0011\u0010,\u001a\u00020\u0000H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010-J\u0011\u0010.\u001a\u00020\u0000H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010-J\u0013\u0010/\u001a\u00020\u001e2\b\u00100\u001a\u0004\u0018\u000101H\u0096\u0002J\u0010\u00102\u001a\u0004\u0018\u00010\u00162\u0006\u00103\u001a\u000204J\b\u00105\u001a\u000206H\u0016J\b\u00107\u001a\u00020\u0016H\u0016J\u0014\u00108\u001a\u00020\u00002\n\u00109\u001a\u0006\u0012\u0002\b\u00030:H\u0016R\u0013\u0010\t\u001a\u0004\u0018\u00010\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\r\u001a\u0004\u0018\u00010\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0010R\u0011\u0010\u0015\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u001e8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0013\u0010\"\u001a\u0004\u0018\u00010#8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0011\u0010(\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u0018R\u0011\u0010*\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b+\u0010\u0018\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006<"}, d2={"Ldev/kord/core/entity/User;", "Ldev/kord/core/behavior/UserBehavior;", "data", "Ldev/kord/core/cache/data/UserData;", "kord", "Ldev/kord/core/Kord;", "supplier", "Ldev/kord/core/supplier/EntitySupplier;", "(Ldev/kord/core/cache/data/UserData;Ldev/kord/core/Kord;Ldev/kord/core/supplier/EntitySupplier;)V", "accentColor", "Ldev/kord/common/Color;", "getAccentColor", "()Ldev/kord/common/Color;", "avatar", "Ldev/kord/core/entity/Icon;", "getAvatar", "()Ldev/kord/core/entity/Icon;", "getData", "()Ldev/kord/core/cache/data/UserData;", "defaultAvatar", "getDefaultAvatar", "discriminator", "", "getDiscriminator", "()Ljava/lang/String;", "id", "Ldev/kord/common/entity/Snowflake;", "getId", "()Ldev/kord/common/entity/Snowflake;", "isBot", "", "()Z", "getKord", "()Ldev/kord/core/Kord;", "publicFlags", "Ldev/kord/common/entity/UserFlags;", "getPublicFlags", "()Ldev/kord/common/entity/UserFlags;", "getSupplier", "()Ldev/kord/core/supplier/EntitySupplier;", "tag", "getTag", "username", "getUsername", "asUser", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "asUserOrNull", "equals", "other", "", "getBannerUrl", "format", "Ldev/kord/rest/Image$Format;", "hashCode", "", "toString", "withStrategy", "strategy", "Ldev/kord/core/supplier/EntitySupplyStrategy;", "Avatar", "core"})
public class User
implements UserBehavior {
    @NotNull
    private final UserData data;
    @NotNull
    private final Kord kord;
    @NotNull
    private final EntitySupplier supplier;

    public User(@NotNull UserData data2, @NotNull Kord kord, @NotNull EntitySupplier supplier) {
        Intrinsics.checkNotNullParameter(data2, "data");
        Intrinsics.checkNotNullParameter(kord, "kord");
        Intrinsics.checkNotNullParameter(supplier, "supplier");
        this.data = data2;
        this.kord = kord;
        this.supplier = supplier;
    }

    public /* synthetic */ User(UserData userData2, Kord kord, EntitySupplier entitySupplier, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            entitySupplier = kord.getDefaultSupplier();
        }
        this(userData2, kord, entitySupplier);
    }

    @NotNull
    public final UserData getData() {
        return this.data;
    }

    @Override
    @NotNull
    public Kord getKord() {
        return this.kord;
    }

    @Override
    @NotNull
    public EntitySupplier getSupplier() {
        return this.supplier;
    }

    @Override
    @NotNull
    public Snowflake getId() {
        return this.data.getId();
    }

    @Nullable
    public final Icon getAvatar() {
        Icon.UserAvatar userAvatar;
        String string2 = this.data.getAvatar();
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            userAvatar = new Icon.UserAvatar(this.data.getId(), it, this.getKord());
        } else {
            userAvatar = null;
        }
        return userAvatar;
    }

    @NotNull
    public final Icon getDefaultAvatar() {
        return new Icon.DefaultUserAvatar(Integer.parseInt(this.data.getDiscriminator()), this.getKord());
    }

    @NotNull
    public final String getUsername() {
        return this.data.getUsername();
    }

    @NotNull
    public final String getDiscriminator() {
        return this.data.getDiscriminator();
    }

    @Override
    @Nullable
    public Object asUser(@NotNull Continuation<? super User> $completion) {
        return this;
    }

    @Override
    @Nullable
    public Object asUserOrNull(@NotNull Continuation<? super User> $completion) {
        return this;
    }

    @Nullable
    public final UserFlags getPublicFlags() {
        return this.data.getPublicFlags().getValue();
    }

    @NotNull
    public final String getTag() {
        return this.getUsername() + '#' + this.getDiscriminator();
    }

    public final boolean isBot() {
        return this.data.getBot().getDiscordBoolean();
    }

    @Nullable
    public final Color getAccentColor() {
        Color color2;
        Integer n = this.data.getAccentColor();
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl = false;
            color2 = new Color(it);
        } else {
            color2 = null;
        }
        return color2;
    }

    @Nullable
    public final String getBannerUrl(@NotNull Image.Format format) {
        String string2;
        Intrinsics.checkNotNullParameter(format, "format");
        String string3 = this.data.getBanner();
        if (string3 != null) {
            String it = string3;
            boolean bl = false;
            string2 = "https://cdn.discordapp.com/banners/" + this.getId() + '/' + it + '.' + format.getExtension();
        } else {
            string2 = null;
        }
        return string2;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof UserBehavior ? Intrinsics.areEqual(((UserBehavior)other).getId(), this.getId()) : false;
    }

    @Override
    @NotNull
    public User withStrategy(@NotNull EntitySupplyStrategy<?> strategy) {
        Intrinsics.checkNotNullParameter(strategy, "strategy");
        return new User(this.data, this.getKord(), (EntitySupplier)strategy.supply(this.getKord()));
    }

    @NotNull
    public String toString() {
        return "User(data=" + this.data + ", kord=" + this.getKord() + ", supplier=" + this.getSupplier() + ')';
    }

    @Override
    @NotNull
    public String getMention() {
        return UserBehavior.DefaultImpls.getMention(this);
    }

    @Override
    @Nullable
    public Object asMember(@NotNull Snowflake guildId, @NotNull Continuation<? super Member> $completion) {
        return UserBehavior.DefaultImpls.asMember(this, guildId, $completion);
    }

    @Override
    @Nullable
    public Object asMemberOrNull(@NotNull Snowflake guildId, @NotNull Continuation<? super Member> $completion) {
        return UserBehavior.DefaultImpls.asMemberOrNull(this, guildId, $completion);
    }

    @Override
    @Nullable
    public Object fetchMember(@NotNull Snowflake guildId, @NotNull Continuation<? super Member> $completion) {
        return UserBehavior.DefaultImpls.fetchMember(this, guildId, $completion);
    }

    @Override
    @Nullable
    public Object fetchMemberOrNull(@NotNull Snowflake guildId, @NotNull Continuation<? super Member> $completion) {
        return UserBehavior.DefaultImpls.fetchMemberOrNull(this, guildId, $completion);
    }

    @Override
    @Nullable
    public Object fetchUser(@NotNull Continuation<? super User> $completion) {
        return UserBehavior.DefaultImpls.fetchUser(this, $completion);
    }

    @Override
    @Nullable
    public Object fetchUserOrNull(@NotNull Continuation<? super User> $completion) {
        return UserBehavior.DefaultImpls.fetchUserOrNull(this, $completion);
    }

    @Override
    @Nullable
    public Object getDmChannel(@NotNull Continuation<? super DmChannel> $completion) {
        return UserBehavior.DefaultImpls.getDmChannel(this, $completion);
    }

    @Override
    @Nullable
    public Object getDmChannelOrNull(@NotNull Continuation<? super DmChannel> $completion) {
        return UserBehavior.DefaultImpls.getDmChannelOrNull(this, $completion);
    }

    @Override
    public int compareTo(@NotNull Entity other) {
        return UserBehavior.DefaultImpls.compareTo(this, other);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u000e2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u00d6\u0003J\u0011\u0010\u001f\u001a\u00020 H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010!J\u0011\u0010\"\u001a\u00020 H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010!J\u001b\u0010\"\u001a\u0004\u0018\u00010 2\u0006\u0010#\u001a\u00020\u0014H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010$J#\u0010\"\u001a\u0004\u0018\u00010 2\u0006\u0010#\u001a\u00020\u00142\u0006\u0010%\u001a\u00020&H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010'J\u0019\u0010\"\u001a\u00020 2\u0006\u0010%\u001a\u00020&H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010(J\u0010\u0010\u0018\u001a\u0004\u0018\u00010\n2\u0006\u0010#\u001a\u00020\u0014J\u0018\u0010\u0018\u001a\u0004\u0018\u00010\n2\u0006\u0010#\u001a\u00020\u00142\u0006\u0010%\u001a\u00020&J\u000e\u0010\u0018\u001a\u00020\n2\u0006\u0010%\u001a\u00020&J\t\u0010)\u001a\u00020*H\u00d6\u0001J\b\u0010+\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\f\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006,"}, d2={"Ldev/kord/core/entity/User$Avatar;", "Ldev/kord/core/KordObject;", "data", "Ldev/kord/core/cache/data/UserData;", "kord", "Ldev/kord/core/Kord;", "(Ldev/kord/core/cache/data/UserData;Ldev/kord/core/Kord;)V", "getData", "()Ldev/kord/core/cache/data/UserData;", "defaultUrl", "", "getDefaultUrl", "()Ljava/lang/String;", "isAnimated", "", "()Z", "isCustom", "getKord", "()Ldev/kord/core/Kord;", "supportedFormat", "Ldev/kord/rest/Image$Format;", "getSupportedFormat", "()Ldev/kord/rest/Image$Format;", "url", "getUrl", "component1", "component2", "copy", "equals", "other", "", "getDefaultImage", "Ldev/kord/rest/Image;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getImage", "format", "(Ldev/kord/rest/Image$Format;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "size", "Ldev/kord/rest/Image$Size;", "(Ldev/kord/rest/Image$Format;Ldev/kord/rest/Image$Size;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "(Ldev/kord/rest/Image$Size;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "hashCode", "", "toString", "core"})
    public static final class Avatar
    implements KordObject {
        @NotNull
        private final UserData data;
        @NotNull
        private final Kord kord;

        public Avatar(@NotNull UserData data2, @NotNull Kord kord) {
            Intrinsics.checkNotNullParameter(data2, "data");
            Intrinsics.checkNotNullParameter(kord, "kord");
            this.data = data2;
            this.kord = kord;
        }

        @NotNull
        public final UserData getData() {
            return this.data;
        }

        @Override
        @NotNull
        public Kord getKord() {
            return this.kord;
        }

        @NotNull
        public final String getDefaultUrl() {
            return "https://cdn.discordapp.com/embed/avatars/" + Integer.parseInt(this.data.getDiscriminator()) % 5 + ".png";
        }

        public final boolean isCustom() {
            return this.data.getAvatar() != null;
        }

        public final boolean isAnimated() {
            String string2 = this.data.getAvatar();
            return string2 != null ? StringsKt.startsWith$default(string2, "a_", false, 2, null) : false;
        }

        @NotNull
        public final Image.Format getSupportedFormat() {
            return this.isAnimated() ? (Image.Format)Image.Format.GIF.INSTANCE : (Image.Format)Image.Format.PNG.INSTANCE;
        }

        @NotNull
        public final String getUrl() {
            String string2 = this.getUrl(this.getSupportedFormat());
            if (string2 == null) {
                string2 = this.getDefaultUrl();
            }
            return string2;
        }

        @Nullable
        public final String getUrl(@NotNull Image.Format format) {
            Intrinsics.checkNotNullParameter(format, "format");
            String string2 = this.data.getAvatar();
            if (string2 == null) {
                return this.getDefaultUrl();
            }
            String hash = string2;
            if (!this.isAnimated() && Intrinsics.areEqual(format, Image.Format.GIF.INSTANCE)) {
                return null;
            }
            return "https://cdn.discordapp.com/avatars/" + ULong.toString-impl(this.data.getId().getValue-s-VKNKU()) + '/' + hash + '.' + format.getExtension();
        }

        @NotNull
        public final String getUrl(@NotNull Image.Size size2) {
            Intrinsics.checkNotNullParameter((Object)size2, "size");
            String string2 = this.getUrl(this.getSupportedFormat(), size2);
            Intrinsics.checkNotNull(string2);
            return string2;
        }

        @Nullable
        public final String getUrl(@NotNull Image.Format format, @NotNull Image.Size size2) {
            Intrinsics.checkNotNullParameter(format, "format");
            Intrinsics.checkNotNullParameter((Object)size2, "size");
            String string2 = this.data.getAvatar();
            if (string2 == null) {
                return this.getDefaultUrl();
            }
            String hash = string2;
            if (!this.isAnimated() && Intrinsics.areEqual(format, Image.Format.GIF.INSTANCE)) {
                return null;
            }
            return "https://cdn.discordapp.com/avatars/" + ULong.toString-impl(this.data.getId().getValue-s-VKNKU()) + '/' + hash + '.' + format.getExtension() + "?size=" + size2.getMaxRes();
        }

        @Nullable
        public final Object getDefaultImage(@NotNull Continuation<? super Image> $completion) {
            return Image.Companion.fromUrl(this.getKord().getResources().getHttpClient(), this.getDefaultUrl(), $completion);
        }

        @Nullable
        public final Object getImage(@NotNull Continuation<? super Image> $completion) {
            return Image.Companion.fromUrl(this.getKord().getResources().getHttpClient(), this.getUrl(), $completion);
        }

        @Nullable
        public final Object getImage(@NotNull Image.Format format, @NotNull Continuation<? super Image> $completion) {
            String string2 = this.getUrl(format);
            if (string2 == null) {
                return null;
            }
            String url2 = string2;
            return Image.Companion.fromUrl(this.getKord().getResources().getHttpClient(), url2, $completion);
        }

        @Nullable
        public final Object getImage(@NotNull Image.Size size2, @NotNull Continuation<? super Image> $completion) {
            return Image.Companion.fromUrl(this.getKord().getResources().getHttpClient(), this.getUrl(size2), $completion);
        }

        @Nullable
        public final Object getImage(@NotNull Image.Format format, @NotNull Image.Size size2, @NotNull Continuation<? super Image> $completion) {
            String string2 = this.getUrl(format, size2);
            if (string2 == null) {
                return null;
            }
            String url2 = string2;
            return Image.Companion.fromUrl(this.getKord().getResources().getHttpClient(), url2, $completion);
        }

        @NotNull
        public String toString() {
            return "Avatar(data=" + this.data + ", kord=" + this.getKord() + ')';
        }

        @NotNull
        public final UserData component1() {
            return this.data;
        }

        @NotNull
        public final Kord component2() {
            return this.getKord();
        }

        @NotNull
        public final Avatar copy(@NotNull UserData data2, @NotNull Kord kord) {
            Intrinsics.checkNotNullParameter(data2, "data");
            Intrinsics.checkNotNullParameter(kord, "kord");
            return new Avatar(data2, kord);
        }

        public static /* synthetic */ Avatar copy$default(Avatar avatar2, UserData userData2, Kord kord, int n, Object object) {
            if ((n & 1) != 0) {
                userData2 = avatar2.data;
            }
            if ((n & 2) != 0) {
                kord = avatar2.getKord();
            }
            return avatar2.copy(userData2, kord);
        }

        public int hashCode() {
            int result2 = this.data.hashCode();
            result2 = result2 * 31 + this.getKord().hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Avatar)) {
                return false;
            }
            Avatar avatar2 = (Avatar)other;
            if (!Intrinsics.areEqual(this.data, avatar2.data)) {
                return false;
            }
            return Intrinsics.areEqual(this.getKord(), avatar2.getKord());
        }
    }
}

