/*
 * Decompiled with CFR 0.152.
 */
package dev.kord.core.entity;

import dev.kord.common.Color;
import dev.kord.common.entity.Permissions;
import dev.kord.common.entity.Snowflake;
import dev.kord.common.entity.optional.Optional;
import dev.kord.core.Kord;
import dev.kord.core.behavior.GuildBehavior;
import dev.kord.core.behavior.RoleBehavior;
import dev.kord.core.cache.data.RoleData;
import dev.kord.core.cache.data.RoleTagsData;
import dev.kord.core.entity.Entity;
import dev.kord.core.entity.Icon;
import dev.kord.core.entity.RoleTags;
import dev.kord.core.supplier.EntitySupplier;
import dev.kord.core.supplier.EntitySupplyStrategy;
import java.util.Comparator;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0011\u00107\u001a\u00020\u0000H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00108J\u0011\u00109\u001a\u00020\u0000H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00108J\u0011\u0010:\u001a\u00020,2\u0006\u0010;\u001a\u00020<H\u0096\u0002J\t\u0010=\u001a\u00020\u0003H\u00c6\u0003J\t\u0010>\u001a\u00020\u0005H\u00c6\u0003J\t\u0010?\u001a\u00020\u0007H\u00c6\u0003J'\u0010@\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010A\u001a\u00020\u00142\b\u0010;\u001a\u0004\u0018\u00010BH\u0096\u0002J\b\u0010C\u001a\u00020,H\u0016J\b\u0010D\u001a\u00020$H\u0016J\u0014\u0010E\u001a\u00020\u00002\n\u0010F\u001a\u0006\u0012\u0002\b\u00030GH\u0016R\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0013\u0010\u0017\u001a\u0004\u0018\u00010\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0012R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u001f\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0016R\u0011\u0010!\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0016R\u0011\u0010#\u001a\u00020$8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u0011\u0010'\u001a\u00020(8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u0011\u0010+\u001a\u00020,8F\u00a2\u0006\u0006\u001a\u0004\b-\u0010.R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\u0013\u00101\u001a\u0004\u0018\u0001028F\u00a2\u0006\u0006\u001a\u0004\b3\u00104R\u0013\u00105\u001a\u0004\u0018\u00010$\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u0010&\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006H"}, d2={"Ldev/kord/core/entity/Role;", "Ldev/kord/core/behavior/RoleBehavior;", "data", "Ldev/kord/core/cache/data/RoleData;", "kord", "Ldev/kord/core/Kord;", "supplier", "Ldev/kord/core/supplier/EntitySupplier;", "(Ldev/kord/core/cache/data/RoleData;Ldev/kord/core/Kord;Ldev/kord/core/supplier/EntitySupplier;)V", "color", "Ldev/kord/common/Color;", "getColor", "()Ldev/kord/common/Color;", "getData", "()Ldev/kord/core/cache/data/RoleData;", "guildId", "Ldev/kord/common/entity/Snowflake;", "getGuildId", "()Ldev/kord/common/entity/Snowflake;", "hoisted", "", "getHoisted", "()Z", "icon", "Ldev/kord/core/entity/Icon;", "getIcon", "()Ldev/kord/core/entity/Icon;", "id", "getId", "getKord", "()Ldev/kord/core/Kord;", "managed", "getManaged", "mentionable", "getMentionable", "name", "", "getName", "()Ljava/lang/String;", "permissions", "Ldev/kord/common/entity/Permissions;", "getPermissions", "()Ldev/kord/common/entity/Permissions;", "rawPosition", "", "getRawPosition", "()I", "getSupplier", "()Ldev/kord/core/supplier/EntitySupplier;", "tags", "Ldev/kord/core/entity/RoleTags;", "getTags", "()Ldev/kord/core/entity/RoleTags;", "unicodeEmoji", "getUnicodeEmoji", "asRole", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "asRoleOrNull", "compareTo", "other", "Ldev/kord/core/entity/Entity;", "component1", "component2", "component3", "copy", "equals", "", "hashCode", "toString", "withStrategy", "strategy", "Ldev/kord/core/supplier/EntitySupplyStrategy;", "core"})
public final class Role
implements RoleBehavior {
    @NotNull
    private final RoleData data;
    @NotNull
    private final Kord kord;
    @NotNull
    private final EntitySupplier supplier;
    @Nullable
    private final String unicodeEmoji;

    public Role(@NotNull RoleData data2, @NotNull Kord kord, @NotNull EntitySupplier supplier) {
        Intrinsics.checkNotNullParameter(data2, "data");
        Intrinsics.checkNotNullParameter(kord, "kord");
        Intrinsics.checkNotNullParameter(supplier, "supplier");
        this.data = data2;
        this.kord = kord;
        this.supplier = supplier;
        this.unicodeEmoji = this.data.getUnicodeEmoji().getValue();
    }

    public /* synthetic */ Role(RoleData roleData, Kord kord, EntitySupplier entitySupplier, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            entitySupplier = kord.getDefaultSupplier();
        }
        this(roleData, kord, entitySupplier);
    }

    @NotNull
    public final RoleData getData() {
        return this.data;
    }

    @Override
    @NotNull
    public Kord getKord() {
        return this.kord;
    }

    @Override
    @NotNull
    public EntitySupplier getSupplier() {
        return this.supplier;
    }

    @Override
    @NotNull
    public Snowflake getId() {
        return this.data.getId();
    }

    @Override
    @NotNull
    public Snowflake getGuildId() {
        return this.data.getGuildId();
    }

    @NotNull
    public final Color getColor() {
        return new Color(this.data.getColor());
    }

    public final boolean getHoisted() {
        return this.data.getHoisted();
    }

    @Nullable
    public final Icon getIcon() {
        Icon.RoleIcon roleIcon;
        String string2 = this.data.getIcon().getValue();
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            roleIcon = new Icon.RoleIcon(this.data.getId(), it, this.getKord());
        } else {
            roleIcon = null;
        }
        return roleIcon;
    }

    @Nullable
    public final String getUnicodeEmoji() {
        return this.unicodeEmoji;
    }

    public final boolean getManaged() {
        return this.data.getManaged();
    }

    public final boolean getMentionable() {
        return this.data.getMentionable();
    }

    @NotNull
    public final String getName() {
        return this.data.getName();
    }

    @NotNull
    public final Permissions getPermissions() {
        return this.data.getPermissions();
    }

    public final int getRawPosition() {
        return this.data.getPosition();
    }

    @Override
    @Nullable
    public Object asRole(@NotNull Continuation<? super Role> $completion) {
        return this;
    }

    @Override
    @Nullable
    public Object asRoleOrNull(@NotNull Continuation<? super Role> $completion) {
        return this;
    }

    @Nullable
    public final RoleTags getTags() {
        RoleTags roleTags;
        Optional<RoleTagsData> $this$unwrap$iv = this.data.getTags();
        boolean $i$f$unwrap = false;
        Optional<RoleTagsData> optional = $this$unwrap$iv;
        if (optional instanceof Optional.Missing ? true : optional instanceof Optional.Null) {
            roleTags = null;
        } else if (optional instanceof Optional.Value) {
            RoleTagsData it = (RoleTagsData)((Optional.Value)$this$unwrap$iv).getValue();
            boolean bl = false;
            roleTags = new RoleTags(it, this.getGuildId(), this.getKord(), null, 8, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return roleTags;
    }

    @Override
    public int compareTo(@NotNull Entity other) {
        int n;
        Intrinsics.checkNotNullParameter(other, "other");
        if (other instanceof Role) {
            Comparator comparator = new Comparator(){

                public final int compare(T a, T b) {
                    Role it = (Role)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getRawPosition());
                    it = (Role)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues(comparable2, it.getRawPosition());
                }
            };
            n = ((Comparator)new Comparator(comparator){
                final /* synthetic */ Comparator $this_thenBy;
                {
                    this.$this_thenBy = $receiver;
                }

                public final int compare(T a, T b) {
                    int n;
                    int previousCompare = this.$this_thenBy.compare(a, b);
                    if (previousCompare != 0) {
                        n = previousCompare;
                    } else {
                        Role it = (Role)a;
                        boolean bl = false;
                        Comparable comparable = it.getGuildId();
                        it = (Role)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        n = ComparisonsKt.compareValues(comparable2, (Comparable)it.getGuildId());
                    }
                    return n;
                }
            }).compare(this, other);
        } else {
            n = RoleBehavior.DefaultImpls.compareTo(this, other);
        }
        return n;
    }

    @Override
    @NotNull
    public Role withStrategy(@NotNull EntitySupplyStrategy<?> strategy) {
        Intrinsics.checkNotNullParameter(strategy, "strategy");
        return new Role(this.data, this.getKord(), (EntitySupplier)strategy.supply(this.getKord()));
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.getId(), this.getGuildId()};
        return Objects.hash(objectArray);
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof RoleBehavior ? Intrinsics.areEqual(((RoleBehavior)other).getId(), this.getId()) && Intrinsics.areEqual(((RoleBehavior)other).getGuildId(), this.getGuildId()) : false;
    }

    @NotNull
    public String toString() {
        return "Role(data=" + this.data + ", kord=" + this.getKord() + ", supplier=" + this.getSupplier() + ')';
    }

    @Override
    @NotNull
    public GuildBehavior getGuild() {
        return RoleBehavior.DefaultImpls.getGuild(this);
    }

    @Override
    @NotNull
    public String getMention() {
        return RoleBehavior.DefaultImpls.getMention(this);
    }

    @Override
    @Nullable
    public Object fetchRole(@NotNull Continuation<? super Role> $completion) {
        return RoleBehavior.DefaultImpls.fetchRole(this, $completion);
    }

    @Override
    @Nullable
    public Object fetchRoleOrNull(@NotNull Continuation<? super Role> $completion) {
        return RoleBehavior.DefaultImpls.fetchRoleOrNull(this, $completion);
    }

    @Override
    @Nullable
    public Object changePosition(int position2, @NotNull Continuation<? super Flow<Role>> $completion) {
        return RoleBehavior.DefaultImpls.changePosition(this, position2, $completion);
    }

    @Override
    @Nullable
    public Object getPosition(@NotNull Continuation<? super Integer> $completion) {
        return RoleBehavior.DefaultImpls.getPosition(this, $completion);
    }

    @Override
    @Nullable
    public Object delete(@Nullable String reason2, @NotNull Continuation<? super Unit> $completion) {
        return RoleBehavior.DefaultImpls.delete(this, reason2, $completion);
    }

    @NotNull
    public final RoleData component1() {
        return this.data;
    }

    @NotNull
    public final Kord component2() {
        return this.getKord();
    }

    @NotNull
    public final EntitySupplier component3() {
        return this.getSupplier();
    }

    @NotNull
    public final Role copy(@NotNull RoleData data2, @NotNull Kord kord, @NotNull EntitySupplier supplier) {
        Intrinsics.checkNotNullParameter(data2, "data");
        Intrinsics.checkNotNullParameter(kord, "kord");
        Intrinsics.checkNotNullParameter(supplier, "supplier");
        return new Role(data2, kord, supplier);
    }

    public static /* synthetic */ Role copy$default(Role role2, RoleData roleData, Kord kord, EntitySupplier entitySupplier, int n, Object object) {
        if ((n & 1) != 0) {
            roleData = role2.data;
        }
        if ((n & 2) != 0) {
            kord = role2.getKord();
        }
        if ((n & 4) != 0) {
            entitySupplier = role2.getSupplier();
        }
        return role2.copy(roleData, kord, entitySupplier);
    }
}

