/*
 * Decompiled with CFR 0.152.
 */
package dev.kord.core.entity;

import dev.kord.common.entity.Snowflake;
import dev.kord.core.Kord;
import dev.kord.core.KordObject;
import dev.kord.core.cache.data.ReactionData;
import dev.kord.core.entity.ReactionEmoji;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u001c\u001a\u00020\u001dH\u0016R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0011\u001a\u0004\u0018\u00010\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0017R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0017\u00a8\u0006\u001e"}, d2={"Ldev/kord/core/entity/Reaction;", "Ldev/kord/core/KordObject;", "data", "Ldev/kord/core/cache/data/ReactionData;", "kord", "Ldev/kord/core/Kord;", "(Ldev/kord/core/cache/data/ReactionData;Ldev/kord/core/Kord;)V", "count", "", "getCount", "()I", "getData", "()Ldev/kord/core/cache/data/ReactionData;", "emoji", "Ldev/kord/core/entity/ReactionEmoji;", "getEmoji", "()Ldev/kord/core/entity/ReactionEmoji;", "id", "Ldev/kord/common/entity/Snowflake;", "getId", "()Ldev/kord/common/entity/Snowflake;", "isAnimated", "", "()Z", "getKord", "()Ldev/kord/core/Kord;", "selfReacted", "getSelfReacted", "toString", "", "core"})
public final class Reaction
implements KordObject {
    @NotNull
    private final ReactionData data;
    @NotNull
    private final Kord kord;

    public Reaction(@NotNull ReactionData data2, @NotNull Kord kord) {
        Intrinsics.checkNotNullParameter(data2, "data");
        Intrinsics.checkNotNullParameter(kord, "kord");
        this.data = data2;
        this.kord = kord;
    }

    @NotNull
    public final ReactionData getData() {
        return this.data;
    }

    @Override
    @NotNull
    public Kord getKord() {
        return this.kord;
    }

    @Nullable
    public final Snowflake getId() {
        return this.data.getEmojiId();
    }

    public final int getCount() {
        return this.data.getCount();
    }

    public final boolean getSelfReacted() {
        return this.data.getMe();
    }

    @NotNull
    public final ReactionEmoji getEmoji() {
        ReactionEmoji reactionEmoji;
        if (this.data.getEmojiId() == null) {
            String string2 = this.data.getEmojiName();
            Intrinsics.checkNotNull(string2);
            reactionEmoji = new ReactionEmoji.Unicode(string2);
        } else {
            Snowflake snowflake = this.data.getEmojiId();
            String string3 = this.data.getEmojiName();
            if (string3 == null) {
                string3 = "";
            }
            reactionEmoji = new ReactionEmoji.Custom(snowflake, string3, this.data.getEmojiAnimated());
        }
        return reactionEmoji;
    }

    public final boolean isAnimated() {
        return this.data.getEmojiAnimated();
    }

    @NotNull
    public String toString() {
        return "Reaction(data=" + this.data + ", kord=" + this.getKord() + ')';
    }
}

