/*
 * Decompiled with CFR 0.152.
 */
package dev.kord.core.entity;

import dev.kord.common.entity.Snowflake;
import dev.kord.common.entity.optional.OptionalIntKt;
import dev.kord.core.Kord;
import dev.kord.core.cache.data.AttachmentData;
import dev.kord.core.entity.Entity;
import dev.kord.core.entity.KordEntity;
import dev.kord.rest.Image;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0013\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010)\u001a\u00020\u0003H\u00c6\u0003J\t\u0010*\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010+\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010,\u001a\u00020\u001a2\b\u0010-\u001a\u0004\u0018\u00010.H\u0096\u0002J\b\u0010/\u001a\u00020\u0012H\u0016J\b\u00100\u001a\u00020\bH\u0016R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\r\u001a\u0004\u0018\u00010\b8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\nR\u0011\u0010\u000f\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\nR\u0013\u0010\u0011\u001a\u0004\u0018\u00010\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001bR\u0011\u0010\u001d\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010 \u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\nR\u0011\u0010\"\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0011\u0010%\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b&\u0010\nR\u0013\u0010'\u001a\u0004\u0018\u00010\u00128F\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u0014\u00a8\u00061"}, d2={"Ldev/kord/core/entity/Attachment;", "Ldev/kord/core/entity/KordEntity;", "data", "Ldev/kord/core/cache/data/AttachmentData;", "kord", "Ldev/kord/core/Kord;", "(Ldev/kord/core/cache/data/AttachmentData;Ldev/kord/core/Kord;)V", "contentType", "", "getContentType", "()Ljava/lang/String;", "getData", "()Ldev/kord/core/cache/data/AttachmentData;", "description", "getDescription", "filename", "getFilename", "height", "", "getHeight", "()Ljava/lang/Integer;", "id", "Ldev/kord/common/entity/Snowflake;", "getId", "()Ldev/kord/common/entity/Snowflake;", "isEphemeral", "", "()Z", "isImage", "isSpoiler", "getKord", "()Ldev/kord/core/Kord;", "proxyUrl", "getProxyUrl", "size", "getSize", "()I", "url", "getUrl", "width", "getWidth", "component1", "component2", "copy", "equals", "other", "", "hashCode", "toString", "core"})
public final class Attachment
implements KordEntity {
    @NotNull
    private final AttachmentData data;
    @NotNull
    private final Kord kord;

    public Attachment(@NotNull AttachmentData data2, @NotNull Kord kord) {
        Intrinsics.checkNotNullParameter(data2, "data");
        Intrinsics.checkNotNullParameter(kord, "kord");
        this.data = data2;
        this.kord = kord;
    }

    @NotNull
    public final AttachmentData getData() {
        return this.data;
    }

    @Override
    @NotNull
    public Kord getKord() {
        return this.kord;
    }

    @Override
    @NotNull
    public Snowflake getId() {
        return this.data.getId();
    }

    @NotNull
    public final String getFilename() {
        return this.data.getFilename();
    }

    @Nullable
    public final String getDescription() {
        return this.data.getDescription().getValue();
    }

    @Nullable
    public final String getContentType() {
        return this.data.getContentType().getValue();
    }

    public final int getSize() {
        return this.data.getSize();
    }

    @NotNull
    public final String getUrl() {
        return this.data.getUrl();
    }

    @NotNull
    public final String getProxyUrl() {
        return this.data.getProxyUrl();
    }

    @Nullable
    public final Integer getHeight() {
        return OptionalIntKt.getValue(this.data.getHeight());
    }

    @Nullable
    public final Integer getWidth() {
        return OptionalIntKt.getValue(this.data.getWidth());
    }

    public final boolean isSpoiler() {
        return StringsKt.startsWith$default(this.getFilename(), "SPOILER_", false, 2, null);
    }

    public final boolean isEphemeral() {
        return this.data.getEphemeral().getDiscordBoolean();
    }

    public final boolean isImage() {
        return Image.Format.Companion.isSupported(this.getFilename());
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.getId()};
        return Objects.hash(objectArray);
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof Attachment ? Intrinsics.areEqual(((Attachment)other).getId(), this.getId()) : false;
    }

    @NotNull
    public String toString() {
        return "Attachment(data=" + this.data + ", kord=" + this.getKord() + ')';
    }

    @Override
    public int compareTo(@NotNull Entity other) {
        return KordEntity.DefaultImpls.compareTo(this, other);
    }

    @NotNull
    public final AttachmentData component1() {
        return this.data;
    }

    @NotNull
    public final Kord component2() {
        return this.getKord();
    }

    @NotNull
    public final Attachment copy(@NotNull AttachmentData data2, @NotNull Kord kord) {
        Intrinsics.checkNotNullParameter(data2, "data");
        Intrinsics.checkNotNullParameter(kord, "kord");
        return new Attachment(data2, kord);
    }

    public static /* synthetic */ Attachment copy$default(Attachment attachment2, AttachmentData attachmentData, Kord kord, int n, Object object) {
        if ((n & 1) != 0) {
            attachmentData = attachment2.data;
        }
        if ((n & 2) != 0) {
            kord = attachment2.getKord();
        }
        return attachment2.copy(attachmentData, kord);
    }
}

