/*
 * Decompiled with CFR 0.152.
 */
package dev.kord.common;

import dev.kord.common.DiscordBitSet;
import dev.kord.common.DiscordBitSetSerializer;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Serializable(with=DiscordBitSetSerializer.class)
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0016\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\t\b\u0007\u0018\u0000 &2\u00020\u0001:\u0001&B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0000J\u0011\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u0000H\u0086\u0002J\u0013\u0010\u001a\u001a\u00020\r2\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u0011\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u0010H\u0086\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0010H\u0002J\b\u0010 \u001a\u00020\u0010H\u0016J\u0011\u0010!\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\"\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0000H\u0086\u0002J\u000e\u0010#\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0000J\u0019\u0010$\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\rH\u0086\u0002J\b\u0010%\u001a\u00020\u0006H\u0016R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\u0002\u001a\u00020\u0003X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\u0004R\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\b\u00a8\u0006'"}, d2={"Ldev/kord/common/DiscordBitSet;", "", "data", "", "([J)V", "binary", "", "getBinary", "()Ljava/lang/String;", "getData$common", "()[J", "setData$common", "isEmpty", "", "()Z", "size", "", "getSize", "()I", "value", "getValue", "add", "", "another", "contains", "other", "equals", "get", "index", "getOrZero", "", "i", "hashCode", "minus", "plus", "remove", "set", "toString", "Companion", "common"})
public final class DiscordBitSet {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private long[] data;

    public DiscordBitSet(@NotNull long[] data2) {
        Intrinsics.checkNotNullParameter(data2, "data");
        this.data = data2;
    }

    @NotNull
    public final long[] getData$common() {
        return this.data;
    }

    public final void setData$common(@NotNull long[] lArray) {
        Intrinsics.checkNotNullParameter(lArray, "<set-?>");
        this.data = lArray;
    }

    public final boolean isEmpty() {
        boolean bl;
        block1: {
            long[] $this$all$iv = this.data;
            boolean $i$f$all = false;
            int n = $this$all$iv.length;
            for (int i = 0; i < n; ++i) {
                long element$iv;
                long it = element$iv = $this$all$iv[i];
                boolean bl2 = false;
                if (it == 0L) continue;
                bl = false;
                break block1;
            }
            bl = true;
        }
        return bl;
    }

    @NotNull
    public final String getValue() {
        ByteBuffer buffer = ByteBuffer.allocate(this.data.length * 8);
        buffer.asLongBuffer().put(ArraysKt.reversedArray(this.data));
        String string2 = new BigInteger(buffer.array()).toString();
        Intrinsics.checkNotNullExpressionValue(string2, "BigInteger(buffer.array()).toString()");
        return string2;
    }

    public final int getSize() {
        return this.data.length * 8;
    }

    @NotNull
    public final String getBinary() {
        return StringsKt.padEnd(((Object)StringsKt.reversed((CharSequence)ArraysKt.joinToString$default(this.data, (CharSequence)"", null, null, 0, null, (Function1)binary.1.INSTANCE, 30, null))).toString(), 8, '0');
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof DiscordBitSet)) {
            return false;
        }
        int n = Math.max(this.data.length, ((DiscordBitSet)other).data.length);
        for (int i = 0; i < n; ++i) {
            if (this.getOrZero(i) == this.getOrZero(i)) continue;
            return false;
        }
        return true;
    }

    private final long getOrZero(int i) {
        Long l = ArraysKt.getOrNull(this.data, i);
        return l != null ? l : 0L;
    }

    public final boolean get(int index) {
        if (!(0 <= index ? index < this.getSize() : false)) {
            return false;
        }
        int indexOfWidth = index / 8;
        int bitIndex = index % 8;
        return (this.data[indexOfWidth] & 1L << bitIndex) != 0L;
    }

    public final boolean contains(@NotNull DiscordBitSet other) {
        Intrinsics.checkNotNullParameter(other, "other");
        if (other.getSize() > this.getSize()) {
            return false;
        }
        int n = other.data.length;
        for (int i = 0; i < n; ++i) {
            if ((this.data[i] & other.data[i]) == other.data[i]) continue;
            return false;
        }
        return true;
    }

    public final void set(int index, boolean value2) {
        if (!(0 <= index ? index < this.getSize() : false)) {
            Intrinsics.checkNotNullExpressionValue(Arrays.copyOf(this.data, (63 + index) / 8), "copyOf(this, newSize)");
        }
        int indexOfWidth = index / 8;
        int bitIndex = index % 8;
        long bit = value2 ? 1L : 0L;
        this.data[index] = this.data[indexOfWidth] | bit << bitIndex;
    }

    @NotNull
    public final DiscordBitSet plus(@NotNull DiscordBitSet another) {
        Intrinsics.checkNotNullParameter(another, "another");
        long[] dist = new long[this.data.length];
        ArraysKt.copyInto$default(this.data, dist, 0, 0, 0, 14, null);
        DiscordBitSet copy2 = new DiscordBitSet(dist);
        copy2.add(another);
        return copy2;
    }

    @NotNull
    public final DiscordBitSet minus(@NotNull DiscordBitSet another) {
        Intrinsics.checkNotNullParameter(another, "another");
        long[] dist = new long[this.data.length];
        ArraysKt.copyInto$default(this.data, dist, 0, 0, 0, 14, null);
        DiscordBitSet copy2 = new DiscordBitSet(dist);
        copy2.remove(another);
        return copy2;
    }

    public final void add(@NotNull DiscordBitSet another) {
        Intrinsics.checkNotNullParameter(another, "another");
        if (another.data.length > this.data.length) {
            long[] lArray = Arrays.copyOf(this.data, another.data.length);
            Intrinsics.checkNotNullExpressionValue(lArray, "copyOf(this, newSize)");
            this.data = lArray;
        }
        int n = another.data.length;
        for (int i = 0; i < n; ++i) {
            this.data[i] = this.data[i] | another.data[i];
        }
    }

    public final void remove(@NotNull DiscordBitSet another) {
        Intrinsics.checkNotNullParameter(another, "another");
        int n = Math.min(this.data.length, another.data.length);
        for (int i = 0; i < n; ++i) {
            this.data[i] = this.data[i] ^ this.data[i] & another.data[i];
        }
    }

    public int hashCode() {
        int result2 = Arrays.hashCode(this.data);
        result2 = 31 * result2 + this.getSize();
        return result2;
    }

    @NotNull
    public String toString() {
        return "DiscordBitSet(" + this.getBinary() + ')';
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u00c6\u0001\u00a8\u0006\u0006"}, d2={"Ldev/kord/common/DiscordBitSet$Companion;", "", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Ldev/kord/common/DiscordBitSet;", "common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KSerializer<DiscordBitSet> serializer() {
            return DiscordBitSetSerializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

