/*
 * Decompiled with CFR 0.152.
 */
package dev.kord.common;

import dev.kord.common.ColorKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.descriptors.PrimitiveKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialDescriptorsKt;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.encoding.Encoder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Serializable(with=Serializer.class)
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00142\u00020\u0001:\u0002\u0014\u0015B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006B\r\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bJ\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0011\u001a\u00020\u0003H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u0011\u0010\u0005\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0002\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\u0016"}, d2={"Ldev/kord/common/Color;", "", "red", "", "green", "blue", "(III)V", "rgb", "(I)V", "getBlue", "()I", "getGreen", "getRed", "getRgb", "equals", "", "other", "hashCode", "toString", "", "Companion", "Serializer", "common"})
public final class Color {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int rgb;
    private static final int MIN_COLOR = 0;
    private static final int MAX_COLOR = 0xFFFFFF;

    public Color(int rgb) {
        this.rgb = rgb & 0xFFFFFF;
        int n = this.rgb;
        if (!(0 <= n ? n < 0x1000000 : false)) {
            boolean bl = false;
            String string2 = "RGB should be in range of 0..16777215 but was " + this.rgb;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    public Color(int red, int green, int blue) {
        this(ColorKt.access$rgb(red, green, blue));
    }

    public final int getRgb() {
        return this.rgb;
    }

    public final int getRed() {
        return this.rgb >> 16 & 0xFF;
    }

    public final int getGreen() {
        return this.rgb >> 8 & 0xFF;
    }

    public final int getBlue() {
        return this.rgb >> 0 & 0xFF;
    }

    @NotNull
    public String toString() {
        return "Color(red=" + this.getRed() + ",green=" + this.getGreen() + ",blue=" + this.getBlue() + ')';
    }

    public int hashCode() {
        return Integer.hashCode(this.rgb);
    }

    public boolean equals(@Nullable Object other) {
        Color color2 = other instanceof Color ? (Color)other : null;
        if (color2 == null) {
            return false;
        }
        Color color3 = color2;
        return color3.rgb == this.rgb;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0001R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Ldev/kord/common/Color$Companion;", "", "()V", "MAX_COLOR", "", "MIN_COLOR", "serializer", "Lkotlinx/serialization/KSerializer;", "Ldev/kord/common/Color;", "common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KSerializer<Color> serializer() {
            return Serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Ldev/kord/common/Color$Serializer;", "Lkotlinx/serialization/KSerializer;", "Ldev/kord/common/Color;", "()V", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "getDescriptor", "()Lkotlinx/serialization/descriptors/SerialDescriptor;", "deserialize", "decoder", "Lkotlinx/serialization/encoding/Decoder;", "serialize", "", "encoder", "Lkotlinx/serialization/encoding/Encoder;", "value", "common"})
    public static final class Serializer
    implements KSerializer<Color> {
        @NotNull
        public static final Serializer INSTANCE = new Serializer();

        private Serializer() {
        }

        @Override
        @NotNull
        public SerialDescriptor getDescriptor() {
            return SerialDescriptorsKt.PrimitiveSerialDescriptor("Kord.color", PrimitiveKind.INT.INSTANCE);
        }

        @Override
        @NotNull
        public Color deserialize(@NotNull Decoder decoder) {
            Intrinsics.checkNotNullParameter(decoder, "decoder");
            return new Color(decoder.decodeInt());
        }

        @Override
        public void serialize(@NotNull Encoder encoder2, @NotNull Color value2) {
            Intrinsics.checkNotNullParameter(encoder2, "encoder");
            Intrinsics.checkNotNullParameter(value2, "value");
            encoder2.encodeInt(value2.getRgb());
        }
    }
}

