/*
 * Decompiled with CFR 0.152.
 */
package dev.bloedarend.plugin.utils.conversion;

import dev.bloedarend.plugin.utils.conversion.PrimitiveConversions;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ListConversions {
    @NotNull
    public static Optional<List<String>> toStringList(@Nullable List<?> value2) {
        return ListConversions.construct(value2, o -> Optional.ofNullable(o.toString()));
    }

    @NotNull
    public static Optional<List<Integer>> toIntList(@Nullable List<?> value2) {
        return ListConversions.construct(value2, PrimitiveConversions::toInt);
    }

    @NotNull
    public static Optional<List<BigInteger>> toBigIntList(@Nullable List<?> value2) {
        return ListConversions.construct(value2, PrimitiveConversions::toBigInt);
    }

    @NotNull
    public static Optional<List<Byte>> toByteList(@Nullable List<?> value2) {
        return ListConversions.construct(value2, PrimitiveConversions::toByte);
    }

    @NotNull
    public static Optional<List<Long>> toLongList(@Nullable List<?> value2) {
        return ListConversions.construct(value2, PrimitiveConversions::toLong);
    }

    @NotNull
    public static Optional<List<Double>> toDoubleList(@Nullable List<?> value2) {
        return ListConversions.construct(value2, PrimitiveConversions::toDouble);
    }

    @NotNull
    public static Optional<List<Float>> toFloatList(@Nullable List<?> value2) {
        return ListConversions.construct(value2, PrimitiveConversions::toFloat);
    }

    @NotNull
    public static Optional<List<Short>> toShortList(@Nullable List<?> value2) {
        return ListConversions.construct(value2, PrimitiveConversions::toShort);
    }

    @NotNull
    public static Optional<List<Map<?, ?>>> toMapList(@Nullable List<?> value2) {
        return ListConversions.construct(value2, o -> o instanceof Map ? Optional.of((Map)o) : Optional.empty());
    }

    @NotNull
    private static <T> Optional<List<T>> construct(@Nullable List<?> value2, @NotNull Function<Object, Optional<T>> mapper) {
        if (value2 == null) {
            return Optional.empty();
        }
        ArrayList list = new ArrayList();
        for (Object element : value2) {
            if (element == null) continue;
            mapper.apply(element).ifPresent(list::add);
        }
        return Optional.of(list);
    }
}

