/*
 * Decompiled with CFR 0.152.
 */
package dev.bloedarend.plugin.updater.operators;

import dev.bloedarend.plugin.block.Block;
import dev.bloedarend.plugin.block.implementation.Section;
import dev.bloedarend.plugin.route.Route;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Relocator {
    private static final Relocator INSTANCE = new Relocator();

    public static void apply(@NotNull Section section, @NotNull Map<Route, Route> relocations) {
        while (relocations.size() > 0) {
            INSTANCE.apply(section, relocations, relocations.keySet().iterator().next());
        }
    }

    private void apply(@NotNull Section section, @NotNull Map<Route, Route> relocations, @Nullable Route from2) {
        if (from2 == null || !relocations.containsKey(from2)) {
            return;
        }
        Optional<Section> parent = section.getParent(from2);
        if (!parent.isPresent()) {
            relocations.remove(from2);
            return;
        }
        Object lastKey = from2.get(from2.length() - 1);
        Block block2 = (Block)((Map)parent.get().getStoredValue()).get(lastKey);
        if (block2 == null) {
            relocations.remove(from2);
            return;
        }
        Route to = relocations.get(from2);
        relocations.remove(from2);
        ((Map)parent.get().getStoredValue()).remove(lastKey);
        this.removeParents(parent.get());
        this.apply(section, relocations, to);
        section.set(to, (Object)block2);
    }

    private void removeParents(@NotNull Section section) {
        if (section.isEmpty(false) && !section.isRoot()) {
            ((Map)section.getParent().getStoredValue()).remove(section.getName());
            this.removeParents(section.getParent());
        }
    }
}

