/*
 * Decompiled with CFR 0.152.
 */
package dev.bloedarend.plugin.settings.updater;

import dev.bloedarend.plugin.block.Block;
import dev.bloedarend.plugin.block.implementation.Section;
import dev.bloedarend.plugin.route.Route;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ValueMapper {
    @Nullable
    default public Object map(@NotNull Section section, @NotNull Route key) {
        return this.map(section.getBlock(key));
    }

    @Nullable
    default public Object map(@NotNull Block<?> block2) {
        return this.map(block2.getStoredValue());
    }

    @Nullable
    default public Object map(@Nullable Object value2) {
        return value2;
    }

    public static ValueMapper section(final BiFunction<Section, Route, Object> mapper) {
        return new ValueMapper(){

            @Override
            public Object map(@NotNull Section section, @NotNull Route key) {
                return mapper.apply(section, key);
            }
        };
    }

    public static ValueMapper block(final Function<Block<?>, Object> mapper) {
        return new ValueMapper(){

            @Override
            public Object map(@NotNull Block<?> block2) {
                return mapper.apply(block2);
            }
        };
    }

    public static ValueMapper value(final Function<Object, Object> mapper) {
        return new ValueMapper(){

            @Override
            public Object map(@Nullable Object value2) {
                return mapper.apply(value2);
            }
        };
    }
}

