/*
 * Decompiled with CFR 0.152.
 */
package dev.bloedarend.plugin.libs.org.snakeyaml.engine.v2.tokens;

import dev.bloedarend.plugin.libs.org.snakeyaml.engine.v2.exceptions.Mark;
import dev.bloedarend.plugin.libs.org.snakeyaml.engine.v2.exceptions.YamlEngineException;
import dev.bloedarend.plugin.libs.org.snakeyaml.engine.v2.tokens.Token;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class DirectiveToken<T>
extends Token {
    private final String name;
    private final Optional<List<T>> value;
    public static final String YAML_DIRECTIVE = "YAML";
    public static final String TAG_DIRECTIVE = "TAG";

    public DirectiveToken(String name2, Optional<List<T>> value2, Optional<Mark> startMark, Optional<Mark> endMark) {
        super(startMark, endMark);
        Objects.requireNonNull(name2);
        this.name = name2;
        Objects.requireNonNull(value2);
        if (value2.isPresent() && value2.get().size() != 2) {
            throw new YamlEngineException("Two strings/integers must be provided instead of " + value2.get().size());
        }
        this.value = value2;
    }

    public String getName() {
        return this.name;
    }

    public Optional<List<T>> getValue() {
        return this.value;
    }

    @Override
    public Token.ID getTokenId() {
        return Token.ID.Directive;
    }
}

