/*
 * Decompiled with CFR 0.152.
 */
package dev.bloedarend.plugin.libs.org.snakeyaml.engine.v2.representer;

import dev.bloedarend.plugin.libs.org.snakeyaml.engine.v2.api.DumpSettings;
import dev.bloedarend.plugin.libs.org.snakeyaml.engine.v2.api.RepresentToNode;
import dev.bloedarend.plugin.libs.org.snakeyaml.engine.v2.common.FlowStyle;
import dev.bloedarend.plugin.libs.org.snakeyaml.engine.v2.common.NonPrintableStyle;
import dev.bloedarend.plugin.libs.org.snakeyaml.engine.v2.common.ScalarStyle;
import dev.bloedarend.plugin.libs.org.snakeyaml.engine.v2.exceptions.YamlEngineException;
import dev.bloedarend.plugin.libs.org.snakeyaml.engine.v2.nodes.Node;
import dev.bloedarend.plugin.libs.org.snakeyaml.engine.v2.nodes.Tag;
import dev.bloedarend.plugin.libs.org.snakeyaml.engine.v2.representer.BaseRepresenter;
import dev.bloedarend.plugin.libs.org.snakeyaml.engine.v2.scanner.StreamReader;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;

public class StandardRepresenter
extends BaseRepresenter {
    protected Map<Class<? extends Object>, Tag> classTags;
    protected DumpSettings settings;
    public static final Pattern MULTILINE_PATTERN = Pattern.compile("\n|\u0085|\u2028|\u2029");

    public StandardRepresenter(DumpSettings settings) {
        this.defaultFlowStyle = settings.getDefaultFlowStyle();
        this.defaultScalarStyle = settings.getDefaultScalarStyle();
        this.nullRepresenter = new RepresentNull();
        this.representers.put(String.class, new RepresentString());
        this.representers.put(Boolean.class, new RepresentBoolean());
        this.representers.put(Character.class, new RepresentString());
        this.representers.put(UUID.class, new RepresentUuid());
        this.representers.put(Optional.class, new RepresentOptional());
        this.representers.put(byte[].class, new RepresentByteArray());
        RepresentPrimitiveArray primitiveArray = new RepresentPrimitiveArray();
        this.representers.put(short[].class, primitiveArray);
        this.representers.put(int[].class, primitiveArray);
        this.representers.put(long[].class, primitiveArray);
        this.representers.put(float[].class, primitiveArray);
        this.representers.put(double[].class, primitiveArray);
        this.representers.put(char[].class, primitiveArray);
        this.representers.put(boolean[].class, primitiveArray);
        this.parentClassRepresenters.put(Number.class, new RepresentNumber());
        this.parentClassRepresenters.put(List.class, new RepresentList());
        this.parentClassRepresenters.put(Map.class, new RepresentMap());
        this.parentClassRepresenters.put(Set.class, new RepresentSet());
        this.parentClassRepresenters.put(Iterator.class, new RepresentIterator());
        this.parentClassRepresenters.put(new Object[0].getClass(), new RepresentArray());
        this.parentClassRepresenters.put(Enum.class, new RepresentEnum());
        this.classTags = new HashMap<Class<? extends Object>, Tag>();
        this.settings = settings;
    }

    protected Tag getTag(Class<?> clazz, Tag defaultTag) {
        if (this.classTags.containsKey(clazz)) {
            return this.classTags.get(clazz);
        }
        return defaultTag;
    }

    public Tag addClassTag(Class<? extends Object> clazz, Tag tag) {
        if (tag == null) {
            throw new NullPointerException("Tag must be provided.");
        }
        return this.classTags.put(clazz, tag);
    }

    protected class RepresentOptional
    implements RepresentToNode {
        protected RepresentOptional() {
        }

        @Override
        public Node representData(Object data2) {
            Optional opt = (Optional)data2;
            if (opt.isPresent()) {
                Node node = StandardRepresenter.this.represent(opt.get());
                node.setTag(new Tag(Optional.class));
                return node;
            }
            return StandardRepresenter.this.representScalar(Tag.NULL, "null");
        }
    }

    protected class RepresentUuid
    implements RepresentToNode {
        protected RepresentUuid() {
        }

        @Override
        public Node representData(Object data2) {
            return StandardRepresenter.this.representScalar(StandardRepresenter.this.getTag(data2.getClass(), new Tag(UUID.class)), data2.toString());
        }
    }

    protected class RepresentByteArray
    implements RepresentToNode {
        protected RepresentByteArray() {
        }

        @Override
        public Node representData(Object data2) {
            return StandardRepresenter.this.representScalar(Tag.BINARY, Base64.getEncoder().encodeToString((byte[])data2), ScalarStyle.LITERAL);
        }
    }

    protected class RepresentEnum
    implements RepresentToNode {
        protected RepresentEnum() {
        }

        @Override
        public Node representData(Object data2) {
            Tag tag = new Tag(data2.getClass());
            return StandardRepresenter.this.representScalar(StandardRepresenter.this.getTag(data2.getClass(), tag), ((Enum)data2).name());
        }
    }

    protected class RepresentSet
    implements RepresentToNode {
        protected RepresentSet() {
        }

        @Override
        public Node representData(Object data2) {
            LinkedHashMap value2 = new LinkedHashMap();
            Set set2 = (Set)data2;
            for (Object key : set2) {
                value2.put(key, null);
            }
            return StandardRepresenter.this.representMapping(StandardRepresenter.this.getTag(data2.getClass(), Tag.SET), value2, FlowStyle.AUTO);
        }
    }

    protected class RepresentMap
    implements RepresentToNode {
        protected RepresentMap() {
        }

        @Override
        public Node representData(Object data2) {
            return StandardRepresenter.this.representMapping(StandardRepresenter.this.getTag(data2.getClass(), Tag.MAP), (Map)data2, FlowStyle.AUTO);
        }
    }

    protected class RepresentPrimitiveArray
    implements RepresentToNode {
        protected RepresentPrimitiveArray() {
        }

        @Override
        public Node representData(Object data2) {
            Class<?> type = data2.getClass().getComponentType();
            if (Byte.TYPE == type) {
                return StandardRepresenter.this.representSequence(Tag.SEQ, this.asByteList(data2), FlowStyle.AUTO);
            }
            if (Short.TYPE == type) {
                return StandardRepresenter.this.representSequence(Tag.SEQ, this.asShortList(data2), FlowStyle.AUTO);
            }
            if (Integer.TYPE == type) {
                return StandardRepresenter.this.representSequence(Tag.SEQ, this.asIntList(data2), FlowStyle.AUTO);
            }
            if (Long.TYPE == type) {
                return StandardRepresenter.this.representSequence(Tag.SEQ, this.asLongList(data2), FlowStyle.AUTO);
            }
            if (Float.TYPE == type) {
                return StandardRepresenter.this.representSequence(Tag.SEQ, this.asFloatList(data2), FlowStyle.AUTO);
            }
            if (Double.TYPE == type) {
                return StandardRepresenter.this.representSequence(Tag.SEQ, this.asDoubleList(data2), FlowStyle.AUTO);
            }
            if (Character.TYPE == type) {
                return StandardRepresenter.this.representSequence(Tag.SEQ, this.asCharList(data2), FlowStyle.AUTO);
            }
            if (Boolean.TYPE == type) {
                return StandardRepresenter.this.representSequence(Tag.SEQ, this.asBooleanList(data2), FlowStyle.AUTO);
            }
            throw new YamlEngineException("Unexpected primitive '" + type.getCanonicalName() + "'");
        }

        private List<Byte> asByteList(Object in2) {
            byte[] array = (byte[])in2;
            ArrayList<Byte> list = new ArrayList<Byte>(array.length);
            for (int i = 0; i < array.length; ++i) {
                list.add(array[i]);
            }
            return list;
        }

        private List<Short> asShortList(Object in2) {
            short[] array = (short[])in2;
            ArrayList<Short> list = new ArrayList<Short>(array.length);
            for (int i = 0; i < array.length; ++i) {
                list.add(array[i]);
            }
            return list;
        }

        private List<Integer> asIntList(Object in2) {
            int[] array = (int[])in2;
            ArrayList<Integer> list = new ArrayList<Integer>(array.length);
            for (int i = 0; i < array.length; ++i) {
                list.add(array[i]);
            }
            return list;
        }

        private List<Long> asLongList(Object in2) {
            long[] array = (long[])in2;
            ArrayList<Long> list = new ArrayList<Long>(array.length);
            for (int i = 0; i < array.length; ++i) {
                list.add(array[i]);
            }
            return list;
        }

        private List<Float> asFloatList(Object in2) {
            float[] array = (float[])in2;
            ArrayList<Float> list = new ArrayList<Float>(array.length);
            for (int i = 0; i < array.length; ++i) {
                list.add(Float.valueOf(array[i]));
            }
            return list;
        }

        private List<Double> asDoubleList(Object in2) {
            double[] array = (double[])in2;
            ArrayList<Double> list = new ArrayList<Double>(array.length);
            for (int i = 0; i < array.length; ++i) {
                list.add(array[i]);
            }
            return list;
        }

        private List<Character> asCharList(Object in2) {
            char[] array = (char[])in2;
            ArrayList<Character> list = new ArrayList<Character>(array.length);
            for (int i = 0; i < array.length; ++i) {
                list.add(Character.valueOf(array[i]));
            }
            return list;
        }

        private List<Boolean> asBooleanList(Object in2) {
            boolean[] array = (boolean[])in2;
            ArrayList<Boolean> list = new ArrayList<Boolean>(array.length);
            for (int i = 0; i < array.length; ++i) {
                list.add(array[i]);
            }
            return list;
        }
    }

    protected class RepresentArray
    implements RepresentToNode {
        protected RepresentArray() {
        }

        @Override
        public Node representData(Object data2) {
            Object[] array = (Object[])data2;
            List<Object> list = Arrays.asList(array);
            return StandardRepresenter.this.representSequence(Tag.SEQ, list, FlowStyle.AUTO);
        }
    }

    private static class IteratorWrapper
    implements Iterable<Object> {
        private final Iterator<Object> iter;

        public IteratorWrapper(Iterator<Object> iter) {
            this.iter = iter;
        }

        @Override
        public Iterator<Object> iterator() {
            return this.iter;
        }
    }

    protected class RepresentIterator
    implements RepresentToNode {
        protected RepresentIterator() {
        }

        @Override
        public Node representData(Object data2) {
            Iterator iter = (Iterator)data2;
            return StandardRepresenter.this.representSequence(StandardRepresenter.this.getTag(data2.getClass(), Tag.SEQ), new IteratorWrapper(iter), FlowStyle.AUTO);
        }
    }

    protected class RepresentList
    implements RepresentToNode {
        protected RepresentList() {
        }

        @Override
        public Node representData(Object data2) {
            return StandardRepresenter.this.representSequence(StandardRepresenter.this.getTag(data2.getClass(), Tag.SEQ), (List)data2, FlowStyle.AUTO);
        }
    }

    protected class RepresentNumber
    implements RepresentToNode {
        protected RepresentNumber() {
        }

        @Override
        public Node representData(Object data2) {
            String value2;
            Tag tag;
            if (data2 instanceof Byte || data2 instanceof Short || data2 instanceof Integer || data2 instanceof Long || data2 instanceof BigInteger) {
                tag = Tag.INT;
                value2 = data2.toString();
            } else {
                Number number2 = (Number)data2;
                tag = Tag.FLOAT;
                value2 = number2.equals(Double.NaN) ? ".NaN" : (number2.equals(Double.POSITIVE_INFINITY) ? ".inf" : (number2.equals(Double.NEGATIVE_INFINITY) ? "-.inf" : number2.toString()));
            }
            return StandardRepresenter.this.representScalar(StandardRepresenter.this.getTag(data2.getClass(), tag), value2);
        }
    }

    protected class RepresentBoolean
    implements RepresentToNode {
        protected RepresentBoolean() {
        }

        @Override
        public Node representData(Object data2) {
            String value2 = Boolean.TRUE.equals(data2) ? "true" : "false";
            return StandardRepresenter.this.representScalar(Tag.BOOL, value2);
        }
    }

    protected class RepresentString
    implements RepresentToNode {
        protected RepresentString() {
        }

        @Override
        public Node representData(Object data2) {
            Tag tag = Tag.STR;
            ScalarStyle style = ScalarStyle.PLAIN;
            String value2 = data2.toString();
            if (StandardRepresenter.this.settings.getNonPrintableStyle() == NonPrintableStyle.BINARY && !StreamReader.isPrintable(value2)) {
                tag = Tag.BINARY;
                byte[] bytes = value2.getBytes(StandardCharsets.UTF_8);
                String checkValue = new String(bytes, StandardCharsets.UTF_8);
                if (!checkValue.equals(value2)) {
                    throw new YamlEngineException("invalid string value has occurred");
                }
                value2 = Base64.getEncoder().encodeToString(bytes);
                style = ScalarStyle.LITERAL;
            }
            if (StandardRepresenter.this.defaultScalarStyle == ScalarStyle.PLAIN && MULTILINE_PATTERN.matcher(value2).find()) {
                style = ScalarStyle.LITERAL;
            }
            return StandardRepresenter.this.representScalar(tag, value2, style);
        }
    }

    protected class RepresentNull
    implements RepresentToNode {
        protected RepresentNull() {
        }

        @Override
        public Node representData(Object data2) {
            return StandardRepresenter.this.representScalar(Tag.NULL, "null");
        }
    }
}

