/*
 * Decompiled with CFR 0.152.
 */
package dev.bloedarend.plugin.libs.org.snakeyaml.engine.v2.nodes;

import dev.bloedarend.plugin.libs.org.snakeyaml.engine.v2.common.FlowStyle;
import dev.bloedarend.plugin.libs.org.snakeyaml.engine.v2.exceptions.Mark;
import dev.bloedarend.plugin.libs.org.snakeyaml.engine.v2.nodes.CollectionNode;
import dev.bloedarend.plugin.libs.org.snakeyaml.engine.v2.nodes.NodeTuple;
import dev.bloedarend.plugin.libs.org.snakeyaml.engine.v2.nodes.NodeType;
import dev.bloedarend.plugin.libs.org.snakeyaml.engine.v2.nodes.Tag;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class MappingNode
extends CollectionNode<NodeTuple> {
    private List<NodeTuple> value;

    public MappingNode(Tag tag, boolean resolved, List<NodeTuple> value2, FlowStyle flowStyle, Optional<Mark> startMark, Optional<Mark> endMark) {
        super(tag, flowStyle, startMark, endMark);
        Objects.requireNonNull(value2);
        this.value = value2;
        this.resolved = resolved;
    }

    public MappingNode(Tag tag, List<NodeTuple> value2, FlowStyle flowStyle) {
        this(tag, true, value2, flowStyle, Optional.empty(), Optional.empty());
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.MAPPING;
    }

    @Override
    public List<NodeTuple> getValue() {
        return this.value;
    }

    public void setValue(List<NodeTuple> mergedValue) {
        this.value = mergedValue;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        for (NodeTuple node : this.getValue()) {
            buf.append("{ key=");
            buf.append(node.getKeyNode());
            buf.append("; value=");
            if (node.getValueNode() instanceof CollectionNode) {
                buf.append(System.identityHashCode(node.getValueNode()));
            } else {
                buf.append(node);
            }
            buf.append(" }");
        }
        String values2 = buf.toString();
        return "<" + this.getClass().getName() + " (tag=" + this.getTag() + ", values=" + values2 + ")>";
    }
}

