/*
 * Decompiled with CFR 0.152.
 */
package dev.bloedarend.plugin.libs.org.snakeyaml.engine.v2.exceptions;

import dev.bloedarend.plugin.libs.org.snakeyaml.engine.v2.common.CharConstants;
import java.io.Serializable;

public final class Mark
implements Serializable {
    private final String name;
    private final int index;
    private final int line;
    private final int column;
    private final int[] buffer;
    private final int pointer;

    private static int[] toCodePoints(char[] str) {
        int[] codePoints = new int[Character.codePointCount(str, 0, str.length)];
        int i = 0;
        int c = 0;
        while (i < str.length) {
            int cp;
            codePoints[c] = cp = Character.codePointAt(str, i);
            i += Character.charCount(cp);
            ++c;
        }
        return codePoints;
    }

    public Mark(String name2, int index, int line, int column, int[] buffer, int pointer) {
        this.name = name2;
        this.index = index;
        this.line = line;
        this.column = column;
        this.buffer = buffer;
        this.pointer = pointer;
    }

    public Mark(String name2, int index, int line, int column, char[] str, int pointer) {
        this(name2, index, line, column, Mark.toCodePoints(str), pointer);
    }

    private boolean isLineBreak(int c) {
        return CharConstants.NULL_OR_LINEBR.has(c);
    }

    public String createSnippet(int indent, int maxLength2) {
        int i;
        float half = (float)maxLength2 / 2.0f - 1.0f;
        int start2 = this.pointer;
        String head2 = "";
        while (start2 > 0 && !this.isLineBreak(this.buffer[start2 - 1])) {
            if (!((float)(this.pointer - --start2) > half)) continue;
            head2 = " ... ";
            start2 += 5;
            break;
        }
        String tail = "";
        int end2 = this.pointer;
        while (end2 < this.buffer.length && !this.isLineBreak(this.buffer[end2])) {
            if (!((float)(++end2 - this.pointer) > half)) continue;
            tail = " ... ";
            end2 -= 5;
            break;
        }
        StringBuilder result2 = new StringBuilder();
        for (i = 0; i < indent; ++i) {
            result2.append(" ");
        }
        result2.append(head2);
        for (i = start2; i < end2; ++i) {
            result2.appendCodePoint(this.buffer[i]);
        }
        result2.append(tail);
        result2.append("\n");
        for (i = 0; i < indent + this.pointer - start2 + head2.length(); ++i) {
            result2.append(" ");
        }
        result2.append("^");
        return result2.toString();
    }

    public String createSnippet() {
        return this.createSnippet(4, 75);
    }

    public String toString() {
        String snippet = this.createSnippet();
        StringBuilder builder = new StringBuilder(" in ");
        builder.append(this.name);
        builder.append(", line ");
        builder.append(this.line + 1);
        builder.append(", column ");
        builder.append(this.column + 1);
        builder.append(":\n");
        builder.append(snippet);
        return builder.toString();
    }

    public String getName() {
        return this.name;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public int getIndex() {
        return this.index;
    }

    public int[] getBuffer() {
        return this.buffer;
    }

    public int getPointer() {
        return this.pointer;
    }
}

